/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.amazonpay.v1;

import com.amazon.ask.model.interfaces.amazonpay.model.v1.AuthorizeAttributes;
import com.amazon.ask.model.interfaces.amazonpay.model.v1.PaymentAction;
import com.amazon.ask.model.interfaces.amazonpay.model.v1.ProviderAttributes;
import com.amazon.ask.model.interfaces.amazonpay.model.v1.SellerOrderAttributes;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ChargeAmazonPay {
    @JsonProperty(value="consentToken")
    private String consentToken = null;
    @JsonProperty(value="sellerId")
    private String sellerId = null;
    @JsonProperty(value="billingAgreementId")
    private String billingAgreementId = null;
    @JsonProperty(value="paymentAction")
    private String paymentAction = null;
    @JsonProperty(value="authorizeAttributes")
    private AuthorizeAttributes authorizeAttributes = null;
    @JsonProperty(value="sellerOrderAttributes")
    private SellerOrderAttributes sellerOrderAttributes = null;
    @JsonProperty(value="providerAttributes")
    private ProviderAttributes providerAttributes = null;

    public static Builder builder() {
        return new Builder();
    }

    private ChargeAmazonPay(Builder builder) {
        if (builder.consentToken != null) {
            this.consentToken = builder.consentToken;
        }
        if (builder.sellerId != null) {
            this.sellerId = builder.sellerId;
        }
        if (builder.billingAgreementId != null) {
            this.billingAgreementId = builder.billingAgreementId;
        }
        if (builder.paymentAction != null) {
            this.paymentAction = builder.paymentAction;
        }
        if (builder.authorizeAttributes != null) {
            this.authorizeAttributes = builder.authorizeAttributes;
        }
        if (builder.sellerOrderAttributes != null) {
            this.sellerOrderAttributes = builder.sellerOrderAttributes;
        }
        if (builder.providerAttributes != null) {
            this.providerAttributes = builder.providerAttributes;
        }
    }

    @JsonProperty(value="consentToken")
    public String getConsentToken() {
        return this.consentToken;
    }

    @JsonProperty(value="sellerId")
    public String getSellerId() {
        return this.sellerId;
    }

    @JsonProperty(value="billingAgreementId")
    public String getBillingAgreementId() {
        return this.billingAgreementId;
    }

    public PaymentAction getPaymentAction() {
        return PaymentAction.fromValue(this.paymentAction);
    }

    @JsonProperty(value="paymentAction")
    public String getPaymentActionAsString() {
        return this.paymentAction;
    }

    @JsonProperty(value="authorizeAttributes")
    public AuthorizeAttributes getAuthorizeAttributes() {
        return this.authorizeAttributes;
    }

    @JsonProperty(value="sellerOrderAttributes")
    public SellerOrderAttributes getSellerOrderAttributes() {
        return this.sellerOrderAttributes;
    }

    @JsonProperty(value="providerAttributes")
    public ProviderAttributes getProviderAttributes() {
        return this.providerAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeAmazonPay interfacesAmazonpayV1ChargeAmazonPay = (ChargeAmazonPay)o;
        return Objects.equals(this.consentToken, interfacesAmazonpayV1ChargeAmazonPay.consentToken) && Objects.equals(this.sellerId, interfacesAmazonpayV1ChargeAmazonPay.sellerId) && Objects.equals(this.billingAgreementId, interfacesAmazonpayV1ChargeAmazonPay.billingAgreementId) && Objects.equals(this.paymentAction, interfacesAmazonpayV1ChargeAmazonPay.paymentAction) && Objects.equals(this.authorizeAttributes, interfacesAmazonpayV1ChargeAmazonPay.authorizeAttributes) && Objects.equals(this.sellerOrderAttributes, interfacesAmazonpayV1ChargeAmazonPay.sellerOrderAttributes) && Objects.equals(this.providerAttributes, interfacesAmazonpayV1ChargeAmazonPay.providerAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.consentToken, this.sellerId, this.billingAgreementId, this.paymentAction, this.authorizeAttributes, this.sellerOrderAttributes, this.providerAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeAmazonPay {\n");
        sb.append("    consentToken: ").append(this.toIndentedString(this.consentToken)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    billingAgreementId: ").append(this.toIndentedString(this.billingAgreementId)).append("\n");
        sb.append("    paymentAction: ").append(this.toIndentedString(this.paymentAction)).append("\n");
        sb.append("    authorizeAttributes: ").append(this.toIndentedString(this.authorizeAttributes)).append("\n");
        sb.append("    sellerOrderAttributes: ").append(this.toIndentedString(this.sellerOrderAttributes)).append("\n");
        sb.append("    providerAttributes: ").append(this.toIndentedString(this.providerAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String consentToken;
        private String sellerId;
        private String billingAgreementId;
        private String paymentAction;
        private AuthorizeAttributes authorizeAttributes;
        private SellerOrderAttributes sellerOrderAttributes;
        private ProviderAttributes providerAttributes;

        private Builder() {
        }

        @JsonProperty(value="consentToken")
        public Builder withConsentToken(String consentToken) {
            this.consentToken = consentToken;
            return this;
        }

        @JsonProperty(value="sellerId")
        public Builder withSellerId(String sellerId) {
            this.sellerId = sellerId;
            return this;
        }

        @JsonProperty(value="billingAgreementId")
        public Builder withBillingAgreementId(String billingAgreementId) {
            this.billingAgreementId = billingAgreementId;
            return this;
        }

        @JsonProperty(value="paymentAction")
        public Builder withPaymentAction(String paymentAction) {
            this.paymentAction = paymentAction;
            return this;
        }

        public Builder withPaymentAction(PaymentAction paymentAction) {
            this.paymentAction = paymentAction != null ? paymentAction.toString() : null;
            return this;
        }

        @JsonProperty(value="authorizeAttributes")
        public Builder withAuthorizeAttributes(AuthorizeAttributes authorizeAttributes) {
            this.authorizeAttributes = authorizeAttributes;
            return this;
        }

        @JsonProperty(value="sellerOrderAttributes")
        public Builder withSellerOrderAttributes(SellerOrderAttributes sellerOrderAttributes) {
            this.sellerOrderAttributes = sellerOrderAttributes;
            return this;
        }

        @JsonProperty(value="providerAttributes")
        public Builder withProviderAttributes(ProviderAttributes providerAttributes) {
            this.providerAttributes = providerAttributes;
            return this;
        }

        public ChargeAmazonPay build() {
            return new ChargeAmazonPay(this);
        }
    }
}

