/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Cause;
import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SessionResumedRequest
extends Request {
    @JsonProperty(value="cause")
    private Cause cause = null;

    public static Builder builder() {
        return new Builder();
    }

    private SessionResumedRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "SessionResumedRequest";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.cause != null) {
            this.cause = builder.cause;
        }
    }

    @JsonProperty(value="cause")
    public Cause getCause() {
        return this.cause;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionResumedRequest sessionResumedRequest = (SessionResumedRequest)o;
        return Objects.equals(this.cause, sessionResumedRequest.cause) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cause, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionResumedRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cause: ").append(this.toIndentedString(this.cause)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private Cause cause;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="cause")
        public Builder withCause(Cause cause) {
            this.cause = cause;
            return this;
        }

        public SessionResumedRequest build() {
            return new SessionResumedRequest(this);
        }
    }
}

