/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Application;
import com.amazon.ask.model.User;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Session {
    @JsonProperty(value="new")
    private Boolean _new = null;
    @JsonProperty(value="sessionId")
    private String sessionId = null;
    @JsonProperty(value="user")
    private User user = null;
    @JsonProperty(value="attributes")
    private Map<String, Object> attributes = new HashMap<String, Object>();
    @JsonProperty(value="application")
    private Application application = null;

    public static Builder builder() {
        return new Builder();
    }

    private Session(Builder builder) {
        if (builder._new != null) {
            this._new = builder._new;
        }
        if (builder.sessionId != null) {
            this.sessionId = builder.sessionId;
        }
        if (builder.user != null) {
            this.user = builder.user;
        }
        if (builder.attributes != null) {
            this.attributes = builder.attributes;
        }
        if (builder.application != null) {
            this.application = builder.application;
        }
    }

    @JsonProperty(value="new")
    public Boolean getNew() {
        return this._new;
    }

    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    @JsonProperty(value="attributes")
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="application")
    public Application getApplication() {
        return this.application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this._new, session._new) && Objects.equals(this.sessionId, session.sessionId) && Objects.equals(this.user, session.user) && Objects.equals(this.attributes, session.attributes) && Objects.equals(this.application, session.application);
    }

    public int hashCode() {
        return Objects.hash(this._new, this.sessionId, this.user, this.attributes, this.application);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    _new: ").append(this.toIndentedString(this._new)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Boolean _new;
        private String sessionId;
        private User user;
        private Map<String, Object> attributes;
        private Application application;

        private Builder() {
        }

        @JsonProperty(value="new")
        public Builder withNew(Boolean _new) {
            this._new = _new;
            return this;
        }

        @JsonProperty(value="sessionId")
        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @JsonProperty(value="user")
        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="attributes")
        public Builder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder putAttributesItem(String key, Object attributesItem) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, attributesItem);
            return this;
        }

        @JsonProperty(value="application")
        public Builder withApplication(Application application) {
            this.application = application;
            return this;
        }

        public Session build() {
            return new Session(this);
        }
    }
}

