/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.Task;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class LaunchRequest
extends Request {
    @JsonProperty(value="task")
    private Task task = null;

    public static Builder builder() {
        return new Builder();
    }

    private LaunchRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "LaunchRequest";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.task != null) {
            this.task = builder.task;
        }
    }

    @JsonProperty(value="task")
    public Task getTask() {
        return this.task;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LaunchRequest launchRequest = (LaunchRequest)o;
        return Objects.equals(this.task, launchRequest.task) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.task, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LaunchRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    task: ").append(this.toIndentedString(this.task)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private Task task;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="task")
        public Builder withTask(Task task) {
            this.task = task;
            return this;
        }

        public LaunchRequest build() {
            return new LaunchRequest(this);
        }
    }
}

