/*
* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file
* except in compliance with the License. A copy of the License is located at
*
* http://aws.amazon.com/apache2.0/
*
* or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for
* the specific language governing permissions and limitations under the License.
*/


package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import java.util.Objects;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The LoadTokenListData event is sent to the skill to retrieve additional list items.
 */

@JsonDeserialize(builder = LoadTokenListDataEvent.Builder.class)
public final class LoadTokenListDataEvent extends com.amazon.ask.model.Request  {

    @JsonProperty("token")
    private String token = null;

    @JsonProperty("correlationToken")
    private String correlationToken = null;

    @JsonProperty("listId")
    private String listId = null;

    @JsonProperty("pageToken")
    private String pageToken = null;

    public static Builder builder() {
        return new Builder();
    }

    private LoadTokenListDataEvent(Builder builder) {
        String discriminatorValue = "Alexa.Presentation.APL.LoadTokenListData";

        this.type = discriminatorValue;
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.correlationToken != null) {
            this.correlationToken = builder.correlationToken;
        }
        if (builder.listId != null) {
            this.listId = builder.listId;
        }
        if (builder.pageToken != null) {
            this.pageToken = builder.pageToken;
        }
    }

    /**
     * The token as specified in the presentation's RenderDocument directive.
     * @return token
    **/
    @JsonProperty("token")
    public String getToken() {
        return token;
    }


    /**
     * An identifier generated by a device that is used to correlate requests with their corresponding response directives.
     * @return correlationToken
    **/
    @JsonProperty("correlationToken")
    public String getCorrelationToken() {
        return correlationToken;
    }


    /**
     * The identifier of the list whose items to fetch.
     * @return listId
    **/
    @JsonProperty("listId")
    public String getListId() {
        return listId;
    }


    /**
     * Opaque token of the array of items to fetch. The skill is expected to be able to identify whether the token represents a forward or backward scroll direction.
     * @return pageToken
    **/
    @JsonProperty("pageToken")
    public String getPageToken() {
        return pageToken;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LoadTokenListDataEvent interfacesAlexaPresentationAplLoadTokenListDataEvent = (LoadTokenListDataEvent) o;
        return Objects.equals(this.token, interfacesAlexaPresentationAplLoadTokenListDataEvent.token) &&
            Objects.equals(this.correlationToken, interfacesAlexaPresentationAplLoadTokenListDataEvent.correlationToken) &&
            Objects.equals(this.listId, interfacesAlexaPresentationAplLoadTokenListDataEvent.listId) &&
            Objects.equals(this.pageToken, interfacesAlexaPresentationAplLoadTokenListDataEvent.pageToken) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(token, correlationToken, listId, pageToken, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoadTokenListDataEvent {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("    correlationToken: ").append(toIndentedString(correlationToken)).append("\n");
        sb.append("    listId: ").append(toIndentedString(listId)).append("\n");
        sb.append("    pageToken: ").append(toIndentedString(pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
  
    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String token;
        private String correlationToken;
        private String listId;
        private String pageToken;

        private Builder() {}

        @JsonProperty("requestId")

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }


        @JsonProperty("timestamp")

        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }


        @JsonProperty("locale")

        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }


        @JsonProperty("token")

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }


        @JsonProperty("correlationToken")

        public Builder withCorrelationToken(String correlationToken) {
            this.correlationToken = correlationToken;
            return this;
        }


        @JsonProperty("listId")

        public Builder withListId(String listId) {
            this.listId = listId;
            return this;
        }


        @JsonProperty("pageToken")

        public Builder withPageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        public LoadTokenListDataEvent build() {
            return new LoadTokenListDataEvent(this);
        }
    }
}

