/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response.template.loader.impl;

import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.response.template.loader.TemplateEnumerator;
import com.amazon.ask.util.ValidationUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocaleTemplateEnumerator
implements TemplateEnumerator<HandlerInput> {
    private static final int THIRD_CURSOR_STATE = 3;
    private static final int FOURTH_CURSOR_STATE = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocaleTemplateEnumerator.class);
    private static final String FILE_SEPARATOR = File.separator;
    private static final String UNDERSCORE = "_";
    private static final int NULL_LOCALE_ENUMERATION_SIZE = 1;
    private static final int NON_NULL_LOCALE_ENUMERATION_SIZE = 6;
    protected String templateName;
    protected HandlerInput handlerInput;
    private int enumerationSize;
    private Matcher matcher;
    private int cursor;

    protected LocaleTemplateEnumerator(String templateName, HandlerInput handlerInput) {
        this.templateName = (String)ValidationUtils.assertNotNull((Object)templateName, (String)"templateName");
        this.handlerInput = (HandlerInput)((Object)ValidationUtils.assertNotNull((Object)((Object)handlerInput), (String)"handlerInput"));
        this.enumerationSize = this.getEnumerationSize(handlerInput);
        this.cursor = 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasNext() {
        return this.cursor < this.enumerationSize;
    }

    public String next() {
        if (this.hasNext()) {
            if (this.enumerationSize == 1) {
                ++this.cursor;
                return this.templateName;
            }
            String language = this.matcher.group(1);
            String country = this.matcher.group(2);
            switch (this.cursor) {
                case 0: {
                    ++this.cursor;
                    return this.templateName + FILE_SEPARATOR + language + FILE_SEPARATOR + country;
                }
                case 1: {
                    ++this.cursor;
                    return this.templateName + FILE_SEPARATOR + language + UNDERSCORE + country;
                }
                case 2: {
                    ++this.cursor;
                    return this.templateName + FILE_SEPARATOR + language;
                }
                case 3: {
                    ++this.cursor;
                    return this.templateName + UNDERSCORE + language + UNDERSCORE + country;
                }
                case 4: {
                    ++this.cursor;
                    return this.templateName + UNDERSCORE + language;
                }
            }
            ++this.cursor;
            return this.templateName;
        }
        String message = "No next available template name combination.";
        LOGGER.error(message);
        throw new IllegalStateException(message);
    }

    private int getEnumerationSize(HandlerInput handlerInput) {
        String locale = handlerInput.getRequestEnvelope().getRequest().getLocale();
        if (locale == null || locale.isEmpty()) {
            return 1;
        }
        Pattern localeParser = Pattern.compile("^([a-z]{2})\\-([A-Z]{2})$");
        this.matcher = localeParser.matcher(locale);
        if (this.matcher.matches()) {
            return 6;
        }
        String message = String.format("Invalid locale: %s", locale);
        LOGGER.error(message);
        throw new IllegalArgumentException(message);
    }

    public static final class Builder {
        private String templateName;
        private HandlerInput handlerInput;

        public Builder withTemplateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder withHandlerInput(HandlerInput handlerInput) {
            this.handlerInput = handlerInput;
            return this;
        }

        public LocaleTemplateEnumerator build() {
            return new LocaleTemplateEnumerator(this.templateName, this.handlerInput);
        }
    }
}

