/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request.viewport;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.interfaces.viewport.Shape;
import com.amazon.ask.model.interfaces.viewport.ViewportState;
import com.amazon.ask.request.viewport.Density;
import com.amazon.ask.request.viewport.Orientation;
import com.amazon.ask.request.viewport.Size;
import com.amazon.ask.request.viewport.ViewportProfile;

public final class ViewportUtils {
    private static final int XLOW_DENSITY_UPPER_BOUND = 121;
    private static final int LOW_DENSITY_UPPER_BOUND = 161;
    private static final int MEDIUM_DENSITY_UPPER_BOUND = 241;
    private static final int HIGH_DENSITY_UPPER_BOUND = 321;
    private static final int XHIGH_DENSITY_UPPER_BOUND = 481;
    private static final int XSMALL_SIZE_UPPER_BOUND = 600;
    private static final int SMALL_SIZE_UPPER_BOUND = 960;
    private static final int MEDIUM_SIZE_UPPER_BOUND = 1280;
    private static final int LARGE_SIZE_UPPER_BOUND = 1920;

    private ViewportUtils() {
    }

    public static ViewportProfile getViewportProfile(RequestEnvelope requestEnvelope) {
        if (requestEnvelope.getContext().getViewport() != null) {
            ViewportState viewportState = requestEnvelope.getContext().getViewport();
            Shape shape = viewportState.getShape();
            int currentPixelWidth = viewportState.getCurrentPixelWidth().intValueExact();
            int currentPixelHeight = viewportState.getCurrentPixelHeight().intValueExact();
            int dpi = viewportState.getDpi().intValueExact();
            Orientation orientation = ViewportUtils.getOrientation(currentPixelHeight, currentPixelWidth);
            if (shape == Shape.ROUND && orientation == Orientation.EQUAL && ViewportUtils.getSize(currentPixelHeight) == Size.XSMALL && ViewportUtils.getSize(currentPixelWidth) == Size.XSMALL && ViewportUtils.getDensity(dpi) == Density.LOW) {
                return ViewportProfile.HUB_ROUND_SMALL;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth).ordinal() <= Size.MEDIUM.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() <= Size.XSMALL.ordinal() && ViewportUtils.getDensity(dpi) == Density.LOW) {
                return ViewportProfile.HUB_LANDSCAPE_SMALL;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth).ordinal() <= Size.MEDIUM.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() <= Size.SMALL.ordinal() && ViewportUtils.getDensity(dpi) == Density.LOW) {
                return ViewportProfile.HUB_LANDSCAPE_MEDIUM;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth).ordinal() >= Size.LARGE.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() >= Size.SMALL.ordinal() && ViewportUtils.getDensity(dpi) == Density.LOW) {
                return ViewportProfile.HUB_LANDSCAPE_LARGE;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth).ordinal() >= Size.MEDIUM.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() >= Size.SMALL.ordinal() && ViewportUtils.getDensity(dpi) == Density.MEDIUM) {
                return ViewportProfile.MOBILE_LANDSCAPE_MEDIUM;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.PORTRAIT && ViewportUtils.getSize(currentPixelWidth).ordinal() >= Size.SMALL.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() >= Size.MEDIUM.ordinal() && ViewportUtils.getDensity(dpi) == Density.MEDIUM) {
                return ViewportProfile.MOBILE_PORTRAIT_MEDIUM;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth).ordinal() >= Size.SMALL.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() >= Size.XSMALL.ordinal() && ViewportUtils.getDensity(dpi) == Density.MEDIUM) {
                return ViewportProfile.MOBILE_LANDSCAPE_SMALL;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.PORTRAIT && ViewportUtils.getSize(currentPixelWidth).ordinal() >= Size.XSMALL.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() >= Size.SMALL.ordinal() && ViewportUtils.getDensity(dpi) == Density.MEDIUM) {
                return ViewportProfile.MOBILE_PORTRAIT_SMALL;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth).ordinal() >= Size.XLARGE.ordinal() && ViewportUtils.getSize(currentPixelHeight).ordinal() >= Size.MEDIUM.ordinal() && ViewportUtils.getDensity(dpi).ordinal() >= Density.HIGH.ordinal()) {
                return ViewportProfile.TV_LANDSCAPE_XLARGE;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.PORTRAIT && ViewportUtils.getSize(currentPixelWidth) == Size.XSMALL && ViewportUtils.getSize(currentPixelHeight) == Size.XLARGE && ViewportUtils.getDensity(dpi).ordinal() >= Density.HIGH.ordinal()) {
                return ViewportProfile.TV_PORTRAIT_MEDIUM;
            }
            if (shape == Shape.RECTANGLE && orientation == Orientation.LANDSCAPE && ViewportUtils.getSize(currentPixelWidth) == Size.MEDIUM && ViewportUtils.getSize(currentPixelHeight) == Size.SMALL && ViewportUtils.getDensity(dpi).ordinal() >= Density.HIGH.ordinal()) {
                return ViewportProfile.TV_LANDSCAPE_MEDIUM;
            }
        }
        return ViewportProfile.UNKNOWN_VIEWPORT_PROFILE;
    }

    private static Density getDensity(int dpi) {
        if (ViewportUtils.isBetween(dpi, 0, 121)) {
            return Density.XLOW;
        }
        if (ViewportUtils.isBetween(dpi, 121, 161)) {
            return Density.LOW;
        }
        if (ViewportUtils.isBetween(dpi, 161, 241)) {
            return Density.MEDIUM;
        }
        if (ViewportUtils.isBetween(dpi, 241, 321)) {
            return Density.HIGH;
        }
        if (ViewportUtils.isBetween(dpi, 321, 481)) {
            return Density.XHIGH;
        }
        if (dpi >= 481) {
            return Density.XXHIGH;
        }
        throw new AskSdkException("Unknown density dpi value " + dpi);
    }

    private static Orientation getOrientation(int height, int width) {
        if (height > width) {
            return Orientation.PORTRAIT;
        }
        if (height < width) {
            return Orientation.LANDSCAPE;
        }
        return Orientation.EQUAL;
    }

    private static Size getSize(int dpi) {
        if (ViewportUtils.isBetween(dpi, 0, 600)) {
            return Size.XSMALL;
        }
        if (ViewportUtils.isBetween(dpi, 600, 960)) {
            return Size.SMALL;
        }
        if (ViewportUtils.isBetween(dpi, 960, 1280)) {
            return Size.MEDIUM;
        }
        if (ViewportUtils.isBetween(dpi, 1280, 1920)) {
            return Size.LARGE;
        }
        if (dpi >= 1920) {
            return Size.XLARGE;
        }
        throw new AskSdkException("Unknown size group value " + dpi);
    }

    private static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x < upper;
    }
}

