/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.builder;

import com.amazon.ask.Skill;
import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.builder.SkillConfiguration;
import com.amazon.ask.builder.impl.AbstractSkillBuilder;
import com.amazon.ask.builder.impl.AbstractSkillConfiguration;
import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.dispatcher.request.handler.RequestHandler;
import com.amazon.ask.model.Response;
import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.module.SdkModule;
import com.amazon.ask.module.SdkModuleContext;
import com.amazon.ask.request.handler.adapter.GenericHandlerAdapter;
import com.amazon.ask.request.handler.adapter.impl.BaseHandlerAdapter;
import com.amazon.ask.response.template.TemplateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SkillBuilder<T extends SkillBuilder<T>>
extends AbstractSkillBuilder<HandlerInput, Optional<Response>, T> {
    protected final List<SdkModule> sdkModules = new ArrayList<SdkModule>();
    protected PersistenceAdapter persistenceAdapter;
    protected ApiClient apiClient;
    protected String skillId;
    protected TemplateFactory<HandlerInput, Response> templateFactory;

    public T withPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
        return this.getThis();
    }

    public T withApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        return this.getThis();
    }

    public T registerSdkModule(SdkModule sdkModule) {
        this.sdkModules.add(sdkModule);
        return this.getThis();
    }

    public T withSkillId(String skillId) {
        this.skillId = skillId;
        return this.getThis();
    }

    public T withTemplateFactory(TemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
        return this.getThis();
    }

    private T getThis() {
        return (T)((Object)this);
    }

    protected SkillConfiguration.Builder getConfigBuilder() {
        SkillConfiguration.Builder skillConfigBuilder = SkillConfiguration.builder();
        super.populateConfig((AbstractSkillConfiguration.Builder)skillConfigBuilder);
        if (!this.requestHandlers.isEmpty()) {
            skillConfigBuilder.addHandlerAdapter((GenericHandlerAdapter)new BaseHandlerAdapter(RequestHandler.class));
        }
        skillConfigBuilder.withPersistenceAdapter(this.persistenceAdapter).withApiClient(this.apiClient).withSkillId(this.skillId);
        if (this.templateFactory != null) {
            skillConfigBuilder.withTemplateFactory(this.templateFactory);
        }
        SdkModuleContext sdkModuleContext = new SdkModuleContext(skillConfigBuilder);
        for (SdkModule sdkModule : this.sdkModules) {
            sdkModule.setupModule(sdkModuleContext);
        }
        return skillConfigBuilder;
    }

    public Skill build() {
        return new Skill(this.getConfigBuilder().build());
    }
}

