/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="support-start", aggregator=true)
public class GitFlowSupportStartMojo
extends AbstractGitFlowMojo {
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="tagName")
    private String tagName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(new String[0]);
        try {
            this.initGitFlowConfig();
            this.checkUncommittedChanges();
            String tag = null;
            if (this.settings.isInteractiveMode()) {
                String tagsStr = this.gitFindTags();
                if (StringUtils.isBlank((String)tagsStr)) {
                    throw new MojoFailureException("There are no tags.");
                }
                try {
                    tag = this.prompter.prompt("Choose tag to start support branch", Arrays.asList(tagsStr.split("\\r?\\n")));
                }
                catch (PrompterException e) {
                    throw new MojoFailureException("support-start", (Throwable)e);
                }
            } else if (StringUtils.isNotBlank((String)this.tagName)) {
                if (!this.gitCheckTagExists(this.tagName)) throw new MojoFailureException("The tag '" + this.tagName + "' doesn't exist.");
                tag = this.tagName;
            } else {
                this.getLog().info((CharSequence)"The tagName is blank. Using the last tag.");
                tag = this.gitFindLastTag();
            }
            if (StringUtils.isBlank((String)tag)) {
                throw new MojoFailureException("Tag is blank.");
            }
            boolean supportBranchExists = this.gitCheckBranchExists(this.gitFlowConfig.getSupportBranchPrefix() + tag);
            if (supportBranchExists) {
                throw new MojoFailureException("Support branch with that name already exists.");
            }
            this.gitCreateAndCheckout(this.gitFlowConfig.getSupportBranchPrefix() + tag, tag);
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (!this.pushRemote) return;
            this.gitPush(this.gitFlowConfig.getSupportBranchPrefix() + tag, false);
            return;
        }
        catch (CommandLineException e) {
            throw new MojoFailureException("support-start", (Throwable)e);
        }
    }
}

