/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glanimation;

import android.os.SystemClock;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.base.ae.gmap.GLMapState;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimation;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam1V;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam2V;

public class AdglMapAnimGroup
extends AbstractAdglAnimation {
    public static final int CAMERA_MAX_DEGREE = 80;
    public static final int CAMERA_MIN_DEGREE = 0;
    public static final int MAXMAPLEVEL = 20;
    public static final int MINMAPLEVEL = 3;
    boolean hasCheckParams;
    boolean needZoom;
    boolean hasMidZoom;
    AbstractAdglAnimationParam1V zoomStartParam = null;
    AbstractAdglAnimationParam1V zoomEndParam = null;
    int midZoomDuration;
    int startZoomDuration;
    int endZoomDuration;
    public boolean needMove;
    AbstractAdglAnimationParam2V moveParam = null;
    boolean needRotateMap;
    AbstractAdglAnimationParam1V rotateMapParam = null;
    boolean needRotateCamera;
    AbstractAdglAnimationParam1V rotateCameraParam = null;

    public AdglMapAnimGroup(int n2) {
        this.reset();
        this.duration = n2;
    }

    public void setDuration(int n2) {
        this.duration = n2;
    }

    public void reset() {
        this.isOver = false;
        this.hasCheckParams = false;
        this.needZoom = false;
        this.needMove = false;
        this.moveParam = null;
        this.needRotateMap = false;
        this.rotateMapParam = null;
        this.hasMidZoom = false;
        this.duration = 0;
        if (this.rotateMapParam != null) {
            this.rotateMapParam.reset();
        }
        if (this.moveParam != null) {
            this.moveParam.reset();
        }
        if (this.zoomStartParam != null) {
            this.zoomStartParam.reset();
        }
        if (this.zoomEndParam != null) {
            this.zoomEndParam.reset();
        }
        if (this.rotateCameraParam != null) {
            this.rotateCameraParam.reset();
        }
    }

    @Override
    public boolean isValid() {
        return this.needRotateCamera || this.needRotateMap || this.needMove || this.needZoom;
    }

    public void setToMapAngle(float f2, int n2) {
        f2 %= 360.0f;
        this.needRotateMap = true;
        if (this.rotateMapParam == null) {
            this.rotateMapParam = new AbstractAdglAnimationParam1V();
        }
        this.rotateMapParam.reset();
        this.rotateMapParam.setInterpolatorType(n2, 1.0f);
        this.rotateMapParam.setToValue(f2);
    }

    public void setToMapCenterGeo(int n2, int n3, int n4) {
        if (n2 > 0 && n3 > 0) {
            this.needMove = true;
            if (this.moveParam == null) {
                this.moveParam = new AbstractAdglAnimationParam2V();
            }
            this.moveParam.reset();
            this.moveParam.setInterpolatorType(n4, 1.0f);
            this.moveParam.setToValue(n2, n3);
        }
    }

    public void setToMapLevel(float f2, int n2) {
        this.needZoom = true;
        this.midZoomDuration = 0;
        this.hasMidZoom = false;
        if (AdglMapAnimGroup.checkLevel(f2)) {
            this.initZoomStartParam(f2, n2);
            return;
        }
        this.needZoom = false;
    }

    public void setToMapLevel(float f2, float f3, int n2) {
        this.needZoom = true;
        this.midZoomDuration = 0;
        this.hasMidZoom = false;
        if (n2 > 0 && n2 < this.duration) {
            this.midZoomDuration = n2;
        }
        if (AdglMapAnimGroup.checkLevel(f2) && AdglMapAnimGroup.checkLevel(f3)) {
            this.hasMidZoom = true;
            this.initZoomStartParam(f3, 0);
            this.initZoomEndParam(f3, f2, 0);
            return;
        }
        if (AdglMapAnimGroup.checkLevel(f2)) {
            this.hasMidZoom = false;
            this.initZoomStartParam(f2, 0);
            return;
        }
        if (AdglMapAnimGroup.checkLevel(f3)) {
            this.hasMidZoom = false;
            this.initZoomStartParam(f3, 0);
            return;
        }
        this.needZoom = false;
    }

    public void setToCameraDegree(float f2, int n2) {
        this.needRotateCamera = false;
        if (f2 <= 80.0f && f2 >= 0.0f) {
            this.needRotateCamera = true;
            if (this.rotateCameraParam == null) {
                this.rotateCameraParam = new AbstractAdglAnimationParam1V();
            }
            this.rotateCameraParam.reset();
            this.rotateCameraParam.setInterpolatorType(n2, 1.0f);
            this.rotateCameraParam.setToValue(f2);
        }
    }

    public static boolean checkLevel(float f2) {
        return f2 >= 3.0f && f2 <= 20.0f;
    }

    private void initZoomStartParam(float f2, int n2) {
        if (this.zoomStartParam == null) {
            this.zoomStartParam = new AbstractAdglAnimationParam1V();
        }
        this.zoomStartParam.reset();
        this.zoomStartParam.setInterpolatorType(n2, 1.0f);
        this.zoomStartParam.setToValue(f2);
    }

    private void initZoomEndParam(float f2, float f3, int n2) {
        if (this.zoomEndParam == null) {
            this.zoomEndParam = new AbstractAdglAnimationParam1V();
        }
        this.zoomEndParam.reset();
        this.zoomEndParam.setInterpolatorType(n2, 1.0f);
        this.zoomEndParam.setToValue(f3);
        this.zoomEndParam.setFromValue(f2);
    }

    public void commitAnimation(Object object) {
        float f2;
        float f3;
        this.isOver = true;
        this.hasCheckParams = false;
        if ((object = (GLMapState)object) == null) {
            return;
        }
        if (this.needZoom) {
            if (this.zoomStartParam == null) {
                this.hasCheckParams = true;
                return;
            }
            f3 = ((GLMapState)object).getMapZoomer();
            this.zoomStartParam.setFromValue(f3);
            if (this.hasMidZoom) {
                f2 = this.zoomStartParam.getToValue() - f3;
                float f4 = this.zoomEndParam.getFromValue() - this.zoomEndParam.getToValue();
                if ((double)Math.abs(f2) < 1.0E-6 || (double)Math.abs(f4) < 1.0E-6) {
                    this.hasMidZoom = false;
                    this.zoomStartParam.setToValue(this.zoomEndParam.getToValue());
                    this.zoomStartParam.needToCaculate();
                    this.zoomEndParam = null;
                } else {
                    this.zoomStartParam.needToCaculate();
                    this.zoomEndParam.needToCaculate();
                }
            }
            if (!this.hasMidZoom && (double)Math.abs(this.zoomStartParam.getFromValue() - this.zoomStartParam.getToValue()) < 1.0E-6) {
                this.needZoom = false;
            }
            if (this.needZoom) {
                if (this.hasMidZoom) {
                    this.endZoomDuration = this.startZoomDuration = this.duration - this.midZoomDuration >> 1;
                } else {
                    this.startZoomDuration = this.duration;
                }
            }
        }
        if (this.needMove && this.moveParam != null) {
            IPoint iPoint = IPoint.obtain();
            ((GLMapState)object).getMapGeoCenter(iPoint);
            int n2 = iPoint.x;
            int n3 = iPoint.y;
            iPoint.recycle();
            this.moveParam.setFromValue(n2, n3);
            this.needMove = this.moveParam.needToCaculate();
        }
        if (this.needRotateMap && this.rotateMapParam != null) {
            int n4;
            f3 = ((GLMapState)object).getMapAngle();
            f2 = this.rotateMapParam.getToValue();
            if (f3 > 180.0f && f2 == 0.0f) {
                f2 = 360.0f;
            }
            int n5 = (int)f2 - (int)f3;
            if ((float)n4 > 180.0f) {
                f2 -= 360.0f;
            } else if ((float)n5 < -180.0f) {
                f2 += 360.0f;
            }
            this.rotateMapParam.setFromValue(f3);
            this.rotateMapParam.setToValue(f2);
            this.needRotateMap = this.rotateMapParam.needToCaculate();
        }
        if (this.needRotateCamera && this.rotateCameraParam != null) {
            f3 = ((GLMapState)object).getCameraDegree();
            this.rotateCameraParam.setFromValue(f3);
            this.needRotateCamera = this.rotateCameraParam.needToCaculate();
        }
        this.isOver = !this.needMove && !this.needZoom && !this.needRotateMap && !this.needRotateCamera;
        this.hasCheckParams = true;
        this.startTime = SystemClock.uptimeMillis();
    }

    @Override
    public void doAnimation(Object object) {
        float f2;
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this.hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this.isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.offsetTime = l2 - this.startTime;
        if ((float)this.duration == 0.0f) {
            this.isOver = true;
            return;
        }
        float f3 = (float)this.offsetTime / (float)this.duration;
        if (f2 > 1.0f) {
            f3 = 1.0f;
            this.isOver = true;
        } else if (f3 < 0.0f) {
            this.isOver = true;
            return;
        }
        if (this.needZoom) {
            float f4;
            gLMapState.getMapZoomer();
            if (this.hasMidZoom) {
                float f5;
                if (this.offsetTime <= (long)this.startZoomDuration) {
                    f5 = (float)this.offsetTime / (float)this.startZoomDuration;
                    this.zoomStartParam.setNormalizedTime(f5);
                    f4 = this.zoomStartParam.getCurValue();
                } else if (this.offsetTime <= (long)(this.startZoomDuration + this.midZoomDuration)) {
                    f4 = this.zoomStartParam.getToValue();
                } else {
                    f5 = (float)(this.offsetTime - (long)this.startZoomDuration - (long)this.midZoomDuration) / (float)this.endZoomDuration;
                    this.zoomEndParam.setNormalizedTime(f5);
                    f4 = this.zoomEndParam.getCurValue();
                }
                if (this.isOver) {
                    f4 = this.zoomEndParam.getToValue();
                }
            } else {
                this.zoomStartParam.setNormalizedTime(f3);
                f4 = this.zoomStartParam.getCurValue();
            }
            gLMapState.setMapZoomer(f4);
        }
        if (this.moveParam != null && this.needMove) {
            this.moveParam.setNormalizedTime(f3);
            int n2 = (int)this.moveParam.getFromXValue();
            int n3 = (int)this.moveParam.getFromYValue();
            int n4 = (int)this.moveParam.getToXValue();
            int n5 = (int)this.moveParam.getToYValue();
            float f6 = this.moveParam.getCurMult();
            n4 = (int)((float)(n4 - n2) * f6);
            n5 = (int)((float)(n5 - n3) * f6);
            gLMapState.setMapGeoCenter(n2 + n4, n3 + n5);
        }
        if (this.rotateMapParam != null && this.needRotateMap) {
            this.rotateMapParam.setNormalizedTime(f3);
            float f7 = this.rotateMapParam.getCurValue();
            gLMapState.setMapAngle((int)f7);
        }
        if (this.rotateCameraParam != null && this.needRotateCamera) {
            this.rotateCameraParam.setNormalizedTime(f3);
            float f8 = this.rotateCameraParam.getCurValue();
            gLMapState.setCameraDegree((int)f8);
        }
    }

    public boolean typeEqueal(AdglMapAnimGroup adglMapAnimGroup) {
        return this.needRotateCamera == adglMapAnimGroup.needRotateCamera && this.needRotateMap == adglMapAnimGroup.needRotateMap && this.needZoom == adglMapAnimGroup.needZoom && this.needMove == adglMapAnimGroup.needMove;
    }
}

