/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.amap.api.col.3nl.ib;

public class DirectionView
extends ImageView {
    private Bitmap mDirectionBitmap;
    private PaintFlagsDrawFilter mPaintFlagsDrawFilter;
    private int mLastAngle;
    private int width;
    private int height;

    public DirectionView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        try {
            this.mDirectionBitmap = BitmapFactory.decodeResource((Resources)ib.b(context), (int)2130837713);
            DirectionView directionView = this;
            directionView.setImageBitmap(directionView.mDirectionBitmap);
            this.mPaintFlagsDrawFilter = new PaintFlagsDrawFilter(0, 3);
            this.width = this.mDirectionBitmap.getWidth();
            this.height = this.mDirectionBitmap.getHeight();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public DirectionView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DirectionView(Context context) {
        this(context, null);
    }

    protected void onDraw(Canvas canvas) {
        try {
            this.getImageMatrix().setRotate((float)this.mLastAngle, (float)this.width / 2.0f, (float)this.height / 2.0f);
            canvas.setDrawFilter((DrawFilter)this.mPaintFlagsDrawFilter);
            super.onDraw(canvas);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setRotate(float f2) {
        try {
            if (this.mLastAngle == (int)f2) {
                return;
            }
            this.mLastAngle = (int)f2;
            this.invalidate();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void recycleResource() {
        try {
            if (this.mDirectionBitmap != null) {
                this.mDirectionBitmap.recycle();
                this.mDirectionBitmap = null;
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public Bitmap getDirectionBitmap() {
        return this.mDirectionBitmap;
    }

    public void setDirectionBitmap(Bitmap bitmap) {
        this.mDirectionBitmap = bitmap;
        DirectionView directionView = this;
        directionView.setImageBitmap(directionView.mDirectionBitmap);
    }
}

