/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import com.amap.api.col.3nl.ex;
import com.amap.api.col.3nl.hx;
import com.amap.api.col.3nl.ib;
import com.amap.api.col.3nl.kz;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.NavigateArrow;
import com.amap.api.maps.model.NavigateArrowOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.navi.model.AMapNaviLink;
import com.amap.api.navi.model.AMapNaviLocation;
import com.amap.api.navi.model.AMapNaviPath;
import com.amap.api.navi.model.AMapNaviStep;
import com.amap.api.navi.model.AMapNotAvoidInfo;
import com.amap.api.navi.model.BubbleInfo;
import com.amap.api.navi.model.NaviLatLng;
import com.amap.api.navi.model.RouteOverlayOptions;
import com.amap.api.navi.view.NaviLimitOverlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BaseRouteOverLay {
    protected Marker routeStart;
    protected Marker routeEnd;
    protected Marker startMarker;
    protected Marker endMarker;
    protected Marker footMarker;
    protected List<Marker> wayMarkers = new ArrayList<Marker>();
    protected List<Marker> mTrafficLights = new ArrayList<Marker>();
    protected List<Marker> ferryMarkers = new ArrayList<Marker>();
    protected NaviLimitOverlay naviLimitOverlay;
    protected Marker bubbleMarker;
    protected NavigateArrow mTurnArrow;
    public ex mDefaultPolyline;
    protected Polyline mTrafficColorfulPolyline;
    protected PolylineOptions mTrafficColorfulPolylineOptions = null;
    protected List<Polyline> mCustomPolyLines = new ArrayList<Polyline>();
    protected AMap mAMap;
    protected Context mContext;
    protected Resources mResources;
    protected AMapNaviPath mAMapNaviPath;
    protected RouteOverlayOptions mRouteOverlayOptions;
    protected float mWidth;
    protected List<NaviLatLng> arrowPoints = null;
    protected Bitmap startBitmap;
    protected Bitmap endBitmap;
    protected Bitmap wayBitmap;
    protected Bitmap footBitmap;
    protected BitmapDescriptor arrowOnRoute;
    protected BitmapDescriptor unknownTraffic;
    protected BitmapDescriptor smoothTraffic;
    protected BitmapDescriptor slowTraffic;
    protected BitmapDescriptor jamTraffic;
    protected BitmapDescriptor veryJamTraffic;
    protected BitmapDescriptor fairWayRes;
    protected BitmapDescriptor passRoute;
    protected BitmapDescriptor trafficLightRes;
    protected BitmapDescriptor[] wayPoisRes = new BitmapDescriptor[3];
    protected BitmapDescriptor routeStartIcon;
    protected BitmapDescriptor routeEndIcon;
    public List<Integer> independentStepStartIndexList = null;
    public List<Integer> independentStepEndIndexList = null;
    public List<Integer> independentLinkStartIndexList = null;
    public List<Integer> independentLinkEndIndexList = null;
    protected boolean isAllOverlayVisible = true;
    protected int arrowColor = -1;
    protected int arrowSideColor = 1990523135;
    protected boolean turnArrowIs3D = true;
    protected boolean showTurnArrow = true;
    protected boolean showTrafficLights = true;
    protected boolean showStartMarker = true;
    protected boolean showEndMarker = true;
    protected boolean showViaMarker = true;
    protected boolean showFootFerryMarker = true;
    protected boolean showForbiddenMarker = true;
    protected boolean showPassRoute = true;
    protected boolean isTrafficLine = true;
    protected boolean showArrowOnRoute = false;
    protected boolean showRouteStart = true;
    protected boolean showRouteEnd = true;
    protected AMapNaviLocation mCurrentLocation;
    protected boolean showTrafficRedLight = true;

    protected void init(Context context, AMap aMap, AMapNaviPath aMapNaviPath) {
        try {
            ib.a(context);
            this.mContext = context;
            this.mResources = ib.b(context);
            this.mAMap = aMap;
            this.mAMapNaviPath = aMapNaviPath;
            this.mWidth = hx.a(context, 28);
            this.naviLimitOverlay = new NaviLimitOverlay(this.mContext, aMap);
            this.arrowOnRoute = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837550));
            this.smoothTraffic = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837624));
            this.unknownTraffic = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837618));
            this.slowTraffic = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837628));
            this.jamTraffic = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837619));
            this.veryJamTraffic = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837623));
            this.fairWayRes = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837621));
            this.passRoute = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837634));
            this.endBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837540);
            this.startBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837545);
            this.footBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837583);
            this.wayBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837541);
            this.wayPoisRes[0] = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837542));
            this.wayPoisRes[1] = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837543));
            this.wayPoisRes[2] = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837544));
            this.trafficLightRes = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837529));
            this.routeStartIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130838011));
            this.routeEndIcon = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)this.mResources, (int)2130838981));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public float getWidth() {
        return this.mWidth;
    }

    public RouteOverlayOptions getRouteOverlayOptions() {
        return this.mRouteOverlayOptions;
    }

    public void setRouteOverlayOptions(RouteOverlayOptions routeOverlayOptions) {
    }

    public AMapNaviPath getAMapNaviPath() {
        return this.mAMapNaviPath;
    }

    public void setAMapNaviPath(AMapNaviPath aMapNaviPath) {
        this.mAMapNaviPath = aMapNaviPath;
    }

    public void addToMap() {
    }

    public void setStartPointBitmap(Bitmap bitmap) {
        this.startBitmap = bitmap;
    }

    public void setWayPointBitmap(Bitmap object) {
        try {
            this.wayBitmap = object;
            if (object != null) {
                object = BitmapDescriptorFactory.fromBitmap(object);
                this.wayPoisRes[0] = object;
                this.wayPoisRes[1] = object;
                this.wayPoisRes[2] = object;
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setEndPointBitmap(Bitmap bitmap) {
        this.endBitmap = bitmap;
    }

    public void setCartoFootBitmap(Bitmap bitmap) {
        this.footBitmap = bitmap;
    }

    public void removeFromMap() {
    }

    public void onArriveDestination() {
        if (this.mTurnArrow != null) {
            this.mTurnArrow.remove();
            this.mTurnArrow = null;
        }
    }

    public void zoomToSpan() {
        this.zoomToSpan(100);
    }

    public void zoomToSpan(int n2) {
        try {
            if (this.mAMapNaviPath == null) {
                return;
            }
            CameraUpdate cameraUpdate = CameraUpdateFactory.newLatLngBounds(this.mAMapNaviPath.getBoundsForPath(), n2);
            this.mAMap.animateCamera(cameraUpdate, 1000L, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "zoomToSpan()");
            return;
        }
    }

    public void zoomToSpan(int n2, AMapNaviPath aMapNaviPath) {
        try {
            int n3 = n2;
            int n4 = n2;
            this.zoomToSpan(n3, n3, n4, n4, aMapNaviPath);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "zoomToSpan()");
            return;
        }
    }

    public void zoomToSpan(int n2, int n3, int n4, int n5, AMapNaviPath aMapNaviPath) {
        if (aMapNaviPath == null) {
            return;
        }
        try {
            CameraUpdate cameraUpdate = CameraUpdateFactory.newLatLngBoundsRect(aMapNaviPath.getBoundsForPath(), n2, n3, n4, n5);
            this.mAMap.animateCamera(cameraUpdate, 1000L, null);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void destroy() {
    }

    protected void clearMarkers() {
        if (this.startMarker != null) {
            this.startMarker.remove();
            this.startMarker = null;
        }
        Iterator<Marker> iterator = this.wayMarkers.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove();
        }
        this.wayMarkers.clear();
        if (this.endMarker != null) {
            this.endMarker.remove();
            this.endMarker = null;
        }
        if (this.mTurnArrow != null) {
            this.mTurnArrow.remove();
            this.mTurnArrow = null;
        }
        if (this.footMarker != null) {
            this.footMarker.remove();
            this.footMarker = null;
        }
        if (this.bubbleMarker != null) {
            this.bubbleMarker.remove();
            this.bubbleMarker = null;
        }
        if (this.naviLimitOverlay != null) {
            this.naviLimitOverlay.removeAllMarker();
        }
        if (this.routeStart != null) {
            this.routeStart.remove();
        }
        if (this.routeEnd != null) {
            this.routeEnd.remove();
        }
        this.clearTrafficLights();
    }

    protected void drawPoi() {
        NaviLatLng naviLatLng;
        if (this.routeStartIcon != null) {
            NaviLatLng object3 = this.mAMapNaviPath.getCoordList().get(0);
            this.routeStart = this.mAMap.addMarker(new MarkerOptions().position(hx.a(object3, true)).anchor(0.5f, 0.5f).icon(this.routeStartIcon).visible(this.showRouteStart));
        }
        if (this.routeEndIcon != null) {
            NaviLatLng naviLatLng2 = this.mAMapNaviPath.getCoordList().get(this.mAMapNaviPath.getCoordList().size() - 1);
            this.routeEnd = this.mAMap.addMarker(new MarkerOptions().position(hx.a(naviLatLng2, true)).anchor(0.5f, 0.5f).icon(this.routeEndIcon).visible(this.showRouteEnd));
        }
        LatLng latLng = hx.a(this.mAMapNaviPath.getStartPoint(), true);
        LatLng latLng2 = hx.a(this.mAMapNaviPath.getEndPoint(), true);
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        List<NaviLatLng> list = this.mAMapNaviPath.getWayPoint();
        if (list != null) {
            for (NaviLatLng naviLatLng3 : list) {
                arrayList.add(hx.a(naviLatLng3, true));
            }
        }
        if (this.startBitmap != null) {
            this.startMarker = this.mAMap.addMarker(new MarkerOptions().position(latLng).visible(this.showStartMarker).icon(BitmapDescriptorFactory.fromBitmap(this.startBitmap)));
        }
        if (arrayList.size() > 0 && this.wayBitmap != null) {
            this.wayMarkers.clear();
            if (arrayList.size() == 1 || arrayList.size() > 3) {
                list = BitmapDescriptorFactory.fromBitmap(this.wayBitmap);
                for (LatLng latLng3 : arrayList) {
                    Marker marker = this.mAMap.addMarker(new MarkerOptions().position(latLng3).visible(this.showViaMarker).icon((BitmapDescriptor)((Object)list)));
                    this.wayMarkers.add(marker);
                }
            } else {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    Marker marker = this.mAMap.addMarker(new MarkerOptions().position((LatLng)arrayList.get(i2)).visible(this.showViaMarker).icon(this.wayPoisRes[i2]));
                    this.wayMarkers.add(marker);
                }
            }
        }
        if (this.endBitmap != null) {
            this.endMarker = this.mAMap.addMarker(new MarkerOptions().position(latLng2).visible(this.showEndMarker).icon(BitmapDescriptorFactory.fromBitmap(this.endBitmap)));
        }
        if ((naviLatLng = this.mAMapNaviPath.getCarToFootPoint()) != null && this.footBitmap != null) {
            this.footMarker = this.mAMap.addMarker(new MarkerOptions().position(hx.a(naviLatLng, true)).anchor(0.5f, 0.5f).visible(this.showFootFerryMarker).zIndex(-1.0f).icon(BitmapDescriptorFactory.fromBitmap(this.footBitmap)));
        }
    }

    public void drawArrow(List<NaviLatLng> object) {
        try {
            if (this.mTurnArrow != null) {
                this.mTurnArrow.remove();
                this.mTurnArrow = null;
            }
            this.arrowPoints = object;
            if (!this.isAllOverlayVisible) {
                return;
            }
            if (object == null || object.size() < 2) {
                return;
            }
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
            object = object.iterator();
            while (object.hasNext()) {
                NaviLatLng naviLatLng = (NaviLatLng)object.next();
                arrayList.add(hx.a(naviLatLng, false));
            }
            if (this.mTurnArrow == null) {
                this.mTurnArrow = this.mAMap.addNavigateArrow(new NavigateArrowOptions().topColor(this.arrowColor).sideColor(this.arrowSideColor).width(this.mWidth * 0.7f).set3DModel(this.turnArrowIs3D).visible(this.showTurnArrow));
            }
            this.mTurnArrow.setPoints(arrayList);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "drawArrow(List<NaviLatLng> list) ");
            return;
        }
    }

    protected void drawCustomPolyline(int[] nArray, int[] nArray2, BitmapDescriptor[] bitmapDescriptorArray) {
        try {
            Polyline polyline;
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
            int n2 = 0;
            int n3 = nArray == null ? bitmapDescriptorArray.length : nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (nArray2 != null && i2 < nArray2.length && nArray2[i2] <= 0) continue;
                arrayList.clear();
                while (n2 < this.mAMapNaviPath.getCoordList().size()) {
                    arrayList.add(hx.a(this.mAMapNaviPath.getCoordList().get(n2), false));
                    if (nArray2 != null && i2 < nArray2.length && n2 == nArray2[i2]) break;
                    ++n2;
                }
                polyline = bitmapDescriptorArray == null || bitmapDescriptorArray.length == 0 ? this.mAMap.addPolyline(new PolylineOptions().addAll(arrayList).color(nArray[i2]).width(this.mWidth)) : this.mAMap.addPolyline(new PolylineOptions().addAll(arrayList).setCustomTexture(bitmapDescriptorArray[i2]).width(this.mWidth));
                this.mCustomPolyLines.add(polyline);
            }
            if (this.showArrowOnRoute) {
                ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
                for (int i3 = 0; i3 < this.mAMapNaviPath.getCoordList().size(); ++i3) {
                    arrayList2.add(hx.a(this.mAMapNaviPath.getCoordList().get(i3), false));
                }
                polyline = this.mAMap.addPolyline(new PolylineOptions().addAll(arrayList2).width(this.mWidth * 2.5f).setCustomTexture(this.arrowOnRoute));
                this.mCustomPolyLines.add(polyline);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public List<NaviLatLng> getArrowPoints(int n2) {
        try {
            float f2;
            NaviLatLng naviLatLng;
            int n3;
            if (this.mAMapNaviPath == null) {
                return null;
            }
            if (n2 >= this.mAMapNaviPath.getStepsCount() || n2 < 0) {
                return null;
            }
            List<NaviLatLng> list = this.mAMapNaviPath.getCoordList();
            int n4 = list.size();
            n2 = this.mAMapNaviPath.getSteps().get(n2).getEndIndex();
            NaviLatLng naviLatLng2 = list.get(n2);
            Vector<NaviLatLng> vector = new Vector<NaviLatLng>();
            NaviLatLng naviLatLng3 = naviLatLng2;
            int n5 = 0;
            for (n3 = n2 - 1; n3 >= 0; --n3) {
                naviLatLng = list.get(n3);
                f2 = hx.a(naviLatLng3, naviLatLng);
                if ((n5 = (int)((float)n5 + f2)) >= 50) {
                    naviLatLng3 = hx.a(naviLatLng3, naviLatLng, 50.0f + f2 - (float)n5);
                    vector.add(naviLatLng3);
                    break;
                }
                naviLatLng3 = naviLatLng;
                vector.add(naviLatLng);
            }
            Collections.reverse(vector);
            vector.add(naviLatLng2);
            n5 = 0;
            naviLatLng3 = naviLatLng2;
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                naviLatLng = list.get(n3);
                f2 = hx.a(naviLatLng3, naviLatLng);
                if ((n5 = (int)((float)n5 + f2)) >= 50) {
                    naviLatLng3 = hx.a(naviLatLng3, naviLatLng, 50.0f + f2 - (float)n5);
                    vector.add(naviLatLng3);
                    break;
                }
                naviLatLng3 = naviLatLng;
                vector.add(naviLatLng);
            }
            if (vector.size() > 2) {
                return vector;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "getArrowPoints(int stepIndex)");
        }
        return null;
    }

    public void setRouteOverlayVisible(boolean bl2) {
        this.isAllOverlayVisible = bl2;
    }

    public void setPassRouteVisible(boolean bl2) {
    }

    private void addLightMarkers() {
        if (this.mAMapNaviPath == null) {
            return;
        }
        List<NaviLatLng> list = this.mAMapNaviPath.getLightList();
        if (list != null && list.size() > 0) {
            for (NaviLatLng naviLatLng : list) {
                Marker object = this.mAMap.addMarker(new MarkerOptions().zIndex(-1.0f).anchor(0.5f, 0.5f).position(hx.a(naviLatLng, true)).icon(this.trafficLightRes).visible(this.showTrafficLights));
                this.mTrafficLights.add(object);
            }
        }
    }

    public void setLightsVisible(boolean bl2) {
        try {
            if (this.showTrafficLights != bl2) {
                this.showTrafficLights = bl2;
                if (this.showTrafficLights && (this.mTrafficLights == null || this.mTrafficLights.size() <= 0)) {
                    this.addLightMarkers();
                    return;
                }
                for (Marker marker : this.mTrafficLights) {
                    if (marker == null) continue;
                    marker.setVisible(this.showTrafficLights);
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setNaviArrowVisible(boolean bl2) {
        try {
            this.showTurnArrow = bl2;
            if (this.mTurnArrow != null) {
                this.mTurnArrow.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void drawLights() {
        this.clearTrafficLights();
        if (this.showTrafficLights) {
            this.addLightMarkers();
        }
    }

    public void clearTrafficLights() {
        for (Marker marker : this.mTrafficLights) {
            if (marker == null) continue;
            marker.remove();
        }
        this.mTrafficLights.clear();
    }

    public void setArrowOnRoute(boolean bl2) {
    }

    public void showStartMarker(boolean bl2) {
        try {
            this.showStartMarker = bl2;
            if (this.startMarker != null) {
                this.startMarker.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void showEndMarker(boolean bl2) {
        try {
            this.showEndMarker = bl2;
            if (this.endMarker != null) {
                this.endMarker.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void showViaMarker(boolean bl2) {
        try {
            this.showViaMarker = bl2;
            Iterator<Marker> iterator = this.wayMarkers.iterator();
            while (iterator.hasNext()) {
                iterator.next().setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void showFootFerryMarker(boolean bl2) {
        try {
            this.showFootFerryMarker = bl2;
            if (this.footMarker != null) {
                this.footMarker.setVisible(bl2);
            }
            Iterator<Marker> iterator = this.ferryMarkers.iterator();
            while (iterator.hasNext()) {
                iterator.next().setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void showForbiddenMarker(boolean bl2) {
        try {
            this.showForbiddenMarker = bl2;
            if (this.naviLimitOverlay != null) {
                this.naviLimitOverlay.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void showRouteStart(boolean bl2) {
        try {
            this.showRouteStart = bl2;
            if (this.routeStart != null) {
                this.routeStart.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void showRouteEnd(boolean bl2) {
        try {
            this.showRouteEnd = bl2;
            if (this.routeEnd != null) {
                this.routeEnd.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean isTrafficLine() {
        return this.isTrafficLine;
    }

    public void setTrafficLine(boolean bl2) {
        try {
            if (this.isTrafficLine == bl2) {
                return;
            }
            this.isTrafficLine = bl2;
            this.addToMap();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, "RouteOverLay", "setTrafficLine(Boolean enabled)");
            return;
        }
    }

    public void addToMap(int[] nArray, int[] nArray2) {
    }

    public void addToMap(BitmapDescriptor[] bitmapDescriptorArray, int[] nArray) {
    }

    public void setTransparency(float f2) {
    }

    public void setZindex(int n2) {
    }

    public void handlePassLimitAndForbidden(AMapNotAvoidInfo aMapNotAvoidInfo) {
        if (aMapNotAvoidInfo == null) {
            return;
        }
        try {
            if (this.naviLimitOverlay != null) {
                this.naviLimitOverlay.handlePassLimitAndForbidden(aMapNotAvoidInfo);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void updatePolyline(AMapNaviLocation aMapNaviLocation) {
    }

    public BubbleInfo getBubbleInfo(int n2, int n3) {
        try {
            if (this.mAMapNaviPath == null) {
                return null;
            }
            if (this.independentStepStartIndexList == null || this.independentStepEndIndexList == null || this.independentLinkStartIndexList == null || this.independentLinkEndIndexList == null) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < this.independentStepStartIndexList.size(); ++i2) {
                AMapNaviLink aMapNaviLink;
                int n4;
                int n5;
                Object object;
                Object object2;
                int n6;
                int n7 = this.independentStepStartIndexList.get(i2);
                int n8 = this.independentStepEndIndexList.get(i2);
                int n9 = this.independentLinkStartIndexList.get(i2);
                int n10 = this.independentLinkEndIndexList.get(i2);
                for (n6 = n7 + 1; n6 < n8 && n6 < this.mAMapNaviPath.getSteps().size(); ++n6) {
                    object2 = this.mAMapNaviPath.getSteps().get(n6);
                    object = this.isInsideScreen((LatLng)(object2 = hx.a(((AMapNaviStep)object2).getCoords().get(((AMapNaviStep)object2).getCoords().size() - 1), true)), n2, n3);
                    if (object == null) continue;
                    arrayList.add(object);
                }
                if (arrayList.size() > 0) {
                    ArrayList<Object> arrayList2 = arrayList;
                    return (BubbleInfo)arrayList2.get((arrayList2.size() - 1) / 2);
                }
                for (n6 = n7; n6 <= n8 && n6 < this.mAMapNaviPath.getSteps().size(); ++n6) {
                    object = this.mAMapNaviPath.getSteps().get(n6).getLinks();
                    n5 = 0;
                    if (n6 == n7) {
                        n5 = Math.max(0, n9);
                    }
                    n4 = object.size();
                    if (n6 == n8) {
                        n4 = Math.min(object.size(), n10 + 1);
                    }
                    while (n5 < n4) {
                        aMapNaviLink = (AMapNaviLink)object.get(n5);
                        object2 = hx.a(aMapNaviLink.getCoords().get(aMapNaviLink.getCoords().size() - 1), true);
                        BubbleInfo bubbleInfo = this.isInsideScreen((LatLng)object2, n2, n3);
                        if (bubbleInfo != null && (n6 != n7 || n5 != n9 || n9 != object.size() - 1)) {
                            arrayList.add(bubbleInfo);
                        }
                        ++n5;
                    }
                }
                if (arrayList.size() > 0) {
                    ArrayList<Object> arrayList3 = arrayList;
                    return (BubbleInfo)arrayList3.get((arrayList3.size() - 1) / 2);
                }
                for (n6 = n7; n6 <= n8 && n6 < this.mAMapNaviPath.getSteps().size(); ++n6) {
                    object = this.mAMapNaviPath.getSteps().get(n6).getLinks();
                    n5 = 0;
                    if (n6 == n7) {
                        n5 = Math.max(0, n9);
                    }
                    n4 = object.size();
                    if (n6 == n8) {
                        n4 = Math.min(object.size(), n10 + 1);
                    }
                    while (n5 < n4) {
                        aMapNaviLink = (AMapNaviLink)object.get(n5);
                        for (int i3 = 0; i3 < aMapNaviLink.getCoords().size(); ++i3) {
                            object2 = hx.a(aMapNaviLink.getCoords().get(i3), true);
                            if ((object2 = this.isInsideScreen((LatLng)object2, n2, n3)) == null) continue;
                            arrayList.add(object2);
                        }
                        ++n5;
                    }
                }
                if (arrayList.size() <= 0) continue;
                ArrayList<Object> arrayList4 = arrayList;
                return (BubbleInfo)arrayList4.get((arrayList4.size() - 1) / 2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private BubbleInfo isInsideScreen(LatLng latLng, int n2, int n3) {
        try {
            Point point = this.mAMap.getProjection().toScreenLocation(latLng);
            if (point.x > 0 && point.x < n2 && point.y > 100 && point.y < n3) {
                BubbleInfo bubbleInfo = new BubbleInfo();
                bubbleInfo.setBubblePosition(latLng);
                if (point.x < (n2 /= 2) && point.y < n2) {
                    bubbleInfo.setBubblePositionScreen(4);
                }
                if (point.x > n2 && point.y < n2) {
                    bubbleInfo.setBubblePositionScreen(2);
                }
                if (point.x < n2 && point.y > n2) {
                    bubbleInfo.setBubblePositionScreen(3);
                }
                if (point.x > n2 && point.y > n2) {
                    bubbleInfo.setBubblePositionScreen(1);
                }
                return bubbleInfo;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public List<String> getPolylineIdList() {
        return null;
    }

    public void drawBubbleMarker(LatLng latLng, float f2, float f3, BitmapDescriptor bitmapDescriptor) {
        try {
            if (this.bubbleMarker == null) {
                this.bubbleMarker = this.mAMap.addMarker(new MarkerOptions().zIndex(1.0f));
                this.bubbleMarker.setClickable(true);
            }
            this.bubbleMarker.setVisible((double)this.mAMap.getCameraPosition().zoom > 8.5);
            this.bubbleMarker.setPosition(latLng);
            this.bubbleMarker.setAnchor(f2, f3);
            this.bubbleMarker.setIcon(bitmapDescriptor);
            this.bubbleMarker.setObject(this.mAMapNaviPath.getPathid());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public Marker getBubbleMarker() {
        return this.bubbleMarker;
    }
}

