/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.content.Context;
import com.amap.api.col.3nl.an;
import com.amap.api.col.3nl.dr;
import com.amap.api.col.3nl.dv;
import com.amap.api.col.3nl.kz;
import com.amap.api.maps.model.LatLng;

public class CoordinateConverter {
    private static final String TAG = "CoordinateConverter";
    private Context ctx;
    private CoordType coordType = null;
    private LatLng sourceLatLng = null;

    public CoordinateConverter(Context context) {
        this.ctx = context;
    }

    public CoordinateConverter from(CoordType coordType) {
        this.coordType = coordType;
        return this;
    }

    public CoordinateConverter coord(LatLng latLng) {
        this.sourceLatLng = latLng;
        return this;
    }

    public LatLng convert() {
        if (this.coordType == null) {
            return null;
        }
        if (this.sourceLatLng == null) {
            return null;
        }
        LatLng latLng = null;
        try {
            String string2 = "";
            switch (this.coordType) {
                case BAIDU: {
                    latLng = an.a(this.sourceLatLng);
                    string2 = "baidu";
                    break;
                }
                case MAPBAR: {
                    latLng = an.b(this.ctx, this.sourceLatLng);
                    string2 = "mapbar";
                    break;
                }
                case MAPABC: {
                    string2 = "mapabc";
                    latLng = this.sourceLatLng;
                    break;
                }
                case SOSOMAP: {
                    string2 = "sosomap";
                    latLng = this.sourceLatLng;
                    break;
                }
                case ALIYUN: {
                    string2 = "aliyun";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GOOGLE: {
                    string2 = "google";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GPS: {
                    string2 = "gps";
                    latLng = an.a(this.ctx, this.sourceLatLng);
                }
            }
            dv.a(this.ctx, string2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            kz.c(throwable2, TAG, "convert");
            latLng = this.sourceLatLng;
        }
        return latLng;
    }

    public static boolean isAMapDataAvailable(double d2, double d3) {
        return dr.a(d2, d3);
    }

    public static enum CoordType {
        BAIDU,
        MAPBAR,
        GPS,
        MAPABC,
        SOSOMAP,
        ALIYUN,
        GOOGLE;

    }
}

