/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.idst.nui;

import android.util.Log;
import com.alibaba.idst.nui.Constants;
import com.alibaba.idst.nui.INativeSpeechRecognizerCallback;

public class NuiSpeechRecognizer {
    private static final String TAG = "SpeechRecognizer_JAVA";
    private boolean mInit = false;
    private long speech_recognizer_handle = 0L;
    private static boolean soLoadedInThisClassLoader = false;
    private INativeSpeechRecognizerCallback callback;

    private synchronized int CheckHandle() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return -9999;
        }
        if (this.speech_recognizer_handle == 0L) {
            this.speech_recognizer_handle = this.native_get_new_speech_recognizer();
        }
        return 0;
    }

    public NuiSpeechRecognizer() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return;
        }
        this.speech_recognizer_handle = this.native_get_new_speech_recognizer();
        new StringBuilder("speech_recognizer_handle = ").append(this.speech_recognizer_handle);
    }

    protected void finalize() {
        this.release();
    }

    public synchronized int initialize(INativeSpeechRecognizerCallback iNativeSpeechRecognizerCallback, String string2, Constants.LogLevel logLevel, boolean bl2) {
        this.callback = iNativeSpeechRecognizerCallback;
        int n2 = this.CheckHandle();
        if (n2 != 0) {
            return n2;
        }
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        return nuiSpeechRecognizer.native_speech_recognizer_init(nuiSpeechRecognizer.speech_recognizer_handle, string2, Constants.LogLevel.toInt(logLevel), bl2);
    }

    public synchronized int setParams(String string2) {
        this.CheckHandle();
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        return nuiSpeechRecognizer.native_speech_recognizer_set_params(nuiSpeechRecognizer.speech_recognizer_handle, string2);
    }

    public synchronized int updateAudio(byte[] byArray, int n2) {
        this.CheckHandle();
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        return nuiSpeechRecognizer.native_speech_recognizer_update_audio(nuiSpeechRecognizer.speech_recognizer_handle, byArray, n2);
    }

    public synchronized int start(String string2) {
        this.CheckHandle();
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        return nuiSpeechRecognizer.native_speech_recognizer_start(nuiSpeechRecognizer.speech_recognizer_handle, string2);
    }

    public synchronized int stop() {
        this.CheckHandle();
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        return nuiSpeechRecognizer.native_speech_recognizer_stop(nuiSpeechRecognizer.speech_recognizer_handle);
    }

    public synchronized int cancel() {
        this.CheckHandle();
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        return nuiSpeechRecognizer.native_speech_recognizer_cancel(nuiSpeechRecognizer.speech_recognizer_handle);
    }

    public synchronized int release() {
        this.CheckHandle();
        NuiSpeechRecognizer nuiSpeechRecognizer = this;
        nuiSpeechRecognizer.native_speech_recognizer_release(nuiSpeechRecognizer.speech_recognizer_handle);
        this.speech_recognizer_handle = 0L;
        return 0;
    }

    private native long native_get_new_speech_recognizer();

    private native int native_speech_recognizer_init(long var1, String var3, int var4, boolean var5);

    private native int native_speech_recognizer_set_params(long var1, String var3);

    private native int native_speech_recognizer_update_audio(long var1, byte[] var3, int var4);

    private native int native_speech_recognizer_start(long var1, String var3);

    private native int native_speech_recognizer_stop(long var1);

    private native int native_speech_recognizer_cancel(long var1);

    private native int native_speech_recognizer_release(long var1);

    private native String native_speech_recognizer_get_version();

    private void onSpeechRecognizerEventCallback_(long l2, int n2, byte[] byArray, int n3) {
        if (l2 != this.speech_recognizer_handle) {
            new StringBuilder("recognizer event callback handle ").append(l2).append(" current obj handle ").append(this.speech_recognizer_handle);
            return;
        }
        new StringBuilder("event = ").append(n2).append(" result = ").append(byArray).append(" errcode = ").append(n3);
        if (this.callback != null) {
            this.callback.onSpeechRecognizerEventCallback(SpeechRecognizerEvent.values()[n2], new String(byArray), n3);
        }
    }

    private int onNuiNeedAudioData_(byte[] byArray, int n2) {
        if (this.callback != null) {
            return this.callback.onNuiNeedAudioData(byArray, n2);
        }
        return -1;
    }

    private void onNuiAudioStateChanged_(int n2) {
        if (this.callback != null) {
            this.callback.onNuiAudioStateChanged(Constants.AudioState.values()[n2]);
        }
    }

    private void onNuiRMSChanged_(float f2) {
        if (this.callback != null) {
            this.callback.onNuiAudioRMSChanged(f2);
        }
    }

    private void onEventTrackerCallback_(long l2, byte[] byArray) {
        if (l2 != this.speech_recognizer_handle) {
            new StringBuilder("event track callback handle ").append(l2).append(" current obj handle ").append(this.speech_recognizer_handle);
            return;
        }
        new StringBuilder("event tracker: ").append(new String(byArray));
        if (this.callback != null) {
            this.callback.onSpeechRecognizerEventTrackerCallback(new String(byArray));
        }
    }

    static {
        try {
            System.loadLibrary("speech_recognizer_jni");
            soLoadedInThisClassLoader = true;
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"load library failed, ".concat(String.valueOf(throwable)));
        }
    }

    public static enum SpeechRecognizerEvent {
        SR_EVENT_VAD_START,
        SR_EVENT_VAD_TIMEOUT,
        SR_EVENT_VAD_END,
        SR_EVENT_SESSION_START,
        SR_EVENT_ASR_PARTIAL_RESULT,
        SR_EVENT_ASR_RESULT,
        NuiSpeechRecognizer,
        SR_EVENT_ASR_ERROR,
        SR_EVENT_ATTR_RESULT,
        SR_EVENT_MIC_ERROR;

    }
}

