/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.idst.nui;

import android.os.Environment;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FileUtil {
    public static final String FILE_EXTENSION_SEPARATOR = ".";
    public static final String SEP = File.separator;
    public static final String SDPATH = Environment.getExternalStorageDirectory() + File.separator;

    private FileUtil() {
        throw new Error("error");
    }

    public static boolean hasSdcard() {
        String string2 = Environment.getExternalStorageState();
        return "mounted".equals(string2);
    }

    public static String readFile(String string2) throws IOException {
        return FileUtil.readFile(string2, "utf-8");
    }

    public static String readFile(String object, String string2) throws IOException {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "utf-8";
        }
        object = new File((String)object);
        StringBuilder stringBuilder = new StringBuilder("");
        if (!((File)object).isFile()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), string2);
            bufferedReader = new BufferedReader((Reader)object);
            while ((object = bufferedReader.readLine()) != null) {
                if (!stringBuilder.toString().equals("")) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append((String)object);
            }
            object = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public static List<String> readFileToList(String string2) throws IOException {
        return FileUtil.readFileToList(string2, "utf-8");
    }

    public static List<String> readFileToList(String arrayList, String string2) throws IOException {
        if (TextUtils.isEmpty((CharSequence)((Object)arrayList))) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "utf-8";
        }
        arrayList = new File((String)((Object)arrayList));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!((File)((Object)arrayList)).isFile()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            arrayList = new InputStreamReader((InputStream)new FileInputStream((File)((Object)arrayList)), string2);
            bufferedReader = new BufferedReader((Reader)((Object)arrayList));
            while ((arrayList = bufferedReader.readLine()) != null) {
                arrayList2.add((String)((Object)arrayList));
            }
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static boolean writeFile(String string2, String string3, boolean bl2) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return false;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileUtil.createFile(string2);
            outputStreamWriter = new FileWriter(string2, bl2);
            outputStreamWriter.write(string3);
            outputStreamWriter.flush();
        }
        catch (Throwable throwable) {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            throw throwable;
        }
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public static boolean writeFile(String string2, InputStream inputStream) throws IOException {
        return FileUtil.writeFile(string2, inputStream, false);
    }

    public static boolean writeFile(String string2, InputStream inputStream, boolean bl2) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new NullPointerException("filePath is Empty");
        }
        if (inputStream == null) {
            throw new NullPointerException("InputStream is null");
        }
        return FileUtil.writeFile(new File(string2), inputStream, bl2);
    }

    public static boolean writeFile(File file, InputStream inputStream) throws IOException {
        return FileUtil.writeFile(file, inputStream, false);
    }

    public static boolean writeFile(File object, InputStream inputStream, boolean n2) throws IOException {
        if (object == null) {
            throw new NullPointerException("file = null");
        }
        OutputStream outputStream = null;
        try {
            FileUtil.createFile(((File)object).getAbsolutePath());
            outputStream = new FileOutputStream((File)object, n2 != 0);
            object = new byte[1024];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                outputStream.write((byte[])object, 0, n2);
            }
            outputStream.flush();
        }
        catch (Throwable throwable) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            throw throwable;
        }
        try {
            outputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public static boolean copyFile(String object, String string2) throws IOException {
        object = new FileInputStream((String)object);
        return FileUtil.writeFile(string2, (InputStream)object);
    }

    public static List<String> getFileNameList(String fileArray, FilenameFilter object) {
        if (object == null) {
            return FileUtil.getFileNameList((String)fileArray);
        }
        if (TextUtils.isEmpty((CharSequence)fileArray)) {
            return Collections.emptyList();
        }
        if ((fileArray = new File((String)fileArray).listFiles((FilenameFilter)object)) == null) {
            return Collections.emptyList();
        }
        object = new ArrayList();
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            object.add(file.getName());
        }
        return object;
    }

    public static List<String> getFileNameList(String fileArray) {
        if (TextUtils.isEmpty((CharSequence)fileArray)) {
            return Collections.emptyList();
        }
        if ((fileArray = new File((String)fileArray).listFiles()) == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            arrayList.add(file.getName());
        }
        return arrayList;
    }

    public static List<String> getFileNameList(String fileArray, String object) {
        if (TextUtils.isEmpty((CharSequence)fileArray)) {
            return Collections.emptyList();
        }
        if ((fileArray = new File((String)fileArray).listFiles(new FilenameFilter((String)object){
            final /* synthetic */ String val$extension;
            {
                this.val$extension = string2;
            }

            @Override
            public boolean accept(File file, String string2) {
                return string2.indexOf(FileUtil.FILE_EXTENSION_SEPARATOR + this.val$extension) > 0;
            }
        })) == null) {
            return Collections.emptyList();
        }
        object = new ArrayList();
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            object.add(file.getName());
        }
        return object;
    }

    public static String getFileExtension(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        int n2 = string2.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int n3 = string2.lastIndexOf(File.separator);
        if (n2 == -1) {
            return "";
        }
        if (n3 >= n2) {
            return "";
        }
        return string2.substring(n2 + 1);
    }

    public static boolean createFile(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return FileUtil.createFile(new File(string2));
    }

    public static boolean createFile(File file) {
        if (file == null || !FileUtil.makeDirs(FileUtil.getFolderName(file.getAbsolutePath()))) {
            return false;
        }
        if (!file.exists()) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static boolean makeDirs(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        if (((File)(object = new File((String)object))).exists() && ((File)object).isDirectory()) {
            return true;
        }
        return ((File)object).mkdirs();
    }

    public static boolean makeDirs(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isDirectory()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean isFileExist(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        return ((File)(object = new File((String)object))).exists() && ((File)object).isFile();
    }

    public static String getFileNameWithoutExtension(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        int n2 = string2.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int n3 = string2.lastIndexOf(File.separator);
        if (n3 == -1) {
            if (n2 == -1) {
                return string2;
            }
            return string2.substring(0, n2);
        }
        if (n2 == -1) {
            return string2.substring(n3 + 1);
        }
        if (n3 < n2) {
            return string2.substring(n3 + 1, n2);
        }
        return string2.substring(n3 + 1);
    }

    public static String getFileName(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        int n2 = string2.lastIndexOf(File.separator);
        if (n2 == -1) {
            return string2;
        }
        return string2.substring(n2 + 1);
    }

    public static String getFolderName(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        int n2 = string2.lastIndexOf(File.separator);
        if (n2 == -1) {
            return "";
        }
        return string2.substring(0, n2);
    }

    public static boolean isFolderExist(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        return ((File)(object = new File((String)object))).exists() && ((File)object).isDirectory();
    }

    public static boolean deleteFile(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return true;
        }
        return FileUtil.deleteFile(new File(string2));
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                file2.delete();
                continue;
            }
            if (!file2.isDirectory()) continue;
            FileUtil.deleteFile(file2.getAbsolutePath());
        }
        return file.delete();
    }

    public static void delete(String fileArray, FilenameFilter filenameFilter) {
        if (TextUtils.isEmpty((CharSequence)fileArray)) {
            return;
        }
        if (!(fileArray = new File((String)fileArray)).exists()) {
            return;
        }
        if (fileArray.isFile()) {
            fileArray.delete();
        }
        if (!fileArray.isDirectory()) {
            return;
        }
        fileArray = filenameFilter != null ? fileArray.listFiles(filenameFilter) : fileArray.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    public static long getFileSize(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return -1L;
        }
        if (((File)(object = new File((String)object))).exists() && ((File)object).isFile()) {
            return ((File)object).length();
        }
        return -1L;
    }
}

