/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps2d.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.amap.api.mapcore2d.cm;
import com.amap.api.maps2d.AMapException;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.e;

public final class LatLngBounds
implements Parcelable {
    public static final e CREATOR = new e();
    private final int a;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int n2, LatLng latLng, LatLng latLng2) throws AMapException {
        String string = "LatLngBounds";
        if (latLng == null) {
            throw new AMapException("null southwest");
        }
        if (latLng2 == null) {
            throw new AMapException("null northeast");
        }
        if (latLng2.latitude < latLng.latitude) {
            throw new AMapException("southern latitude exceeds northern latitude (" + latLng.latitude + " > " + latLng2.latitude + ")");
        }
        this.a = n2;
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) throws AMapException {
        this(1, latLng, latLng2);
    }

    int a() {
        return this.a;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng latLng) {
        if (latLng == null) {
            return false;
        }
        LatLng latLng2 = latLng;
        return this.a(latLng2.latitude) && this.b(latLng2.longitude);
    }

    public boolean contains(LatLngBounds latLngBounds) {
        boolean bl2 = false;
        if (latLngBounds == null) {
            return bl2;
        }
        if (this.contains(latLngBounds.southwest) && this.contains(latLngBounds.northeast)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean intersects(LatLngBounds latLngBounds) {
        if (latLngBounds == null) {
            return false;
        }
        return this.a(latLngBounds) || latLngBounds.a(this);
    }

    private boolean a(LatLngBounds latLngBounds) {
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null || this.northeast == null || this.southwest == null) {
            return false;
        }
        double d2 = latLngBounds.northeast.longitude + latLngBounds.southwest.longitude - this.northeast.longitude - this.southwest.longitude;
        double d3 = this.northeast.longitude - this.southwest.longitude + latLngBounds.northeast.longitude - this.southwest.longitude;
        double d4 = latLngBounds.northeast.latitude + latLngBounds.southwest.latitude - this.northeast.latitude - this.southwest.latitude;
        double d5 = this.northeast.latitude - this.southwest.latitude + latLngBounds.northeast.latitude - latLngBounds.southwest.latitude;
        return Math.abs(d2) < d3 && Math.abs(d4) < d5;
    }

    public LatLngBounds including(LatLng latLng) {
        if (latLng == null) {
            return this;
        }
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.c(d5, d6) < LatLngBounds.d(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        try {
            return new LatLngBounds(new LatLng(d2, d6), new LatLng(d3, d6));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this;
        }
    }

    private static double c(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double d(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return cm.a(new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)object;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return cm.a(cm.a("southwest", (Object)this.southwest), cm.a("northeast", (Object)this.northeast));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        e.a(this, parcel, n2);
    }

    public static final class Builder {
        private double a = Double.POSITIVE_INFINITY;
        private double b = Double.NEGATIVE_INFINITY;
        private double c = Double.NaN;
        private double d = Double.NaN;

        public Builder include(LatLng latLng) {
            if (latLng == null) {
                return this;
            }
            this.a = Math.min(this.a, latLng.latitude);
            this.b = Math.max(this.b, latLng.latitude);
            double d2 = latLng.longitude;
            if (Double.isNaN(this.c)) {
                this.c = d2;
                this.d = d2;
            } else if (!this.a(d2)) {
                if (LatLngBounds.c(this.c, d2) < LatLngBounds.d(this.d, d2)) {
                    this.c = d2;
                } else {
                    this.d = d2;
                }
            }
            return this;
        }

        private boolean a(double d2) {
            if (this.c <= this.d) {
                return this.c <= d2 && d2 <= this.d;
            }
            return this.c <= d2 || d2 <= this.d;
        }

        public LatLngBounds build() {
            String string = "build";
            try {
                if (Double.isNaN(this.c)) {
                    Log.w((String)"LatLngBounds", (String)"no included points");
                    return null;
                }
                if (this.c > this.d) {
                    double d2 = this.c;
                    this.c = this.d;
                    this.d = d2;
                }
                if (this.a > this.b) {
                    double d3 = this.a;
                    this.a = this.b;
                    this.b = d3;
                }
                return new LatLngBounds(new LatLng(this.a, this.c), new LatLng(this.b, this.d));
            }
            catch (Throwable throwable) {
                cm.a(throwable, "LatLngBounds", string);
                return null;
            }
        }
    }
}

