/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.scheme;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.aliyun.sls.android.SLSLog;
import com.aliyun.sls.android.utdid.Utdid;
import com.aliyun.sls.android.utils.PermissionHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;

class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    public static final String NETWORK_CLASS_WIFI = "Wi-Fi";
    private static final String NETWORK_CLASS_2_G = "2G";
    private static final String NETWORK_CLASS_3_G = "3G";
    private static final String NETWORK_CLASS_4_G = "4G";
    private static final String NETWORK_CLASS_UNKNOWN = "Unknown";
    private static String cpuName = null;
    private static final String[] NETWORK_INFO_DEFAULT = new String[]{"Unknown", "Unknown"};
    private static final String[] NETWORK_INFO = new String[]{"Unknown", "Unknown"};
    private static String imsi = null;
    private static String imei = null;

    private DeviceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuName() {
        if (cpuName != null) {
            return cpuName;
        }
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(str1);
            localBufferedReader = new BufferedReader(fr);
            while ((str2 = localBufferedReader.readLine()) != null) {
                String var4;
                if (!str2.contains("Hardware")) continue;
                String string = var4 = (cpuName = str2.split(":")[1]);
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String getCarrier(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getNetworkOperatorName();
        }
        catch (Exception var2) {
            return null;
        }
    }

    public static String getAccessName(Context context) {
        return DeviceUtils.getNetworkType(context)[0];
    }

    public static String getAccessSubTypeName(Context context) {
        String[] networkStatus = DeviceUtils.getNetworkType(context);
        String accessName = networkStatus[0];
        if (networkStatus.length > 1 && accessName != null && !NETWORK_CLASS_WIFI.equals(accessName)) {
            return networkStatus[1];
        }
        return NETWORK_INFO_DEFAULT[1];
    }

    @SuppressLint(value={"WrongConstant"})
    public static String[] getNetworkType(Context context) {
        if (context == null) {
            return NETWORK_INFO_DEFAULT;
        }
        try {
            if (!PermissionHelper.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                return NETWORK_INFO_DEFAULT;
            }
            ConnectivityManager cManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (cManager == null) {
                return NETWORK_INFO_DEFAULT;
            }
            NetworkInfo nInfo = cManager.getActiveNetworkInfo();
            if (nInfo == null) {
                return NETWORK_INFO_DEFAULT;
            }
            if (nInfo.isConnected()) {
                if (nInfo.getType() == 1) {
                    DeviceUtils.NETWORK_INFO[0] = NETWORK_CLASS_WIFI;
                    return NETWORK_INFO;
                }
                if (nInfo.getType() == 0) {
                    DeviceUtils.NETWORK_INFO[0] = DeviceUtils.getNetworkClass(nInfo.getSubtype());
                    DeviceUtils.NETWORK_INFO[1] = nInfo.getSubtypeName();
                    return NETWORK_INFO;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NETWORK_INFO_DEFAULT;
    }

    private static String getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return NETWORK_CLASS_2_G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return NETWORK_CLASS_3_G;
            }
            case 13: 
            case 18: {
                return NETWORK_CLASS_4_G;
            }
            case 20: {
                return "5G";
            }
        }
        return NETWORK_CLASS_UNKNOWN;
    }

    public static String getLanguage() {
        try {
            return Locale.getDefault().getLanguage();
        }
        catch (Exception var1) {
            SLSLog.e(TAG, "get country error: " + var1.getMessage());
            return null;
        }
    }

    public static String getCountry() {
        try {
            return Locale.getDefault().getCountry();
        }
        catch (Exception var1) {
            SLSLog.e(TAG, "get country error: " + var1.getMessage());
            return null;
        }
    }

    public static String getResolution(Context context) {
        String resolution = NETWORK_CLASS_UNKNOWN;
        try {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            int width = dm.widthPixels;
            int height = dm.heightPixels;
            if (width > height) {
                width ^= height;
                height ^= width;
                width ^= height;
            }
            resolution = height + "*" + width;
        }
        catch (Exception var5) {
            SLSLog.e(TAG, "DeviceUtils getResolution: error: " + var5.getMessage());
        }
        return resolution;
    }

    public static String getUtdid(Context context) {
        try {
            return Utdid.getInstance().getUtdid(context);
        }
        catch (Exception var2) {
            return "";
        }
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    public static String getImsi(Context context) {
        if (imsi != null) {
            return imsi;
        }
        imsi = Utdid.getImsi(context);
        return imsi;
    }

    public static String getImei(Context context) {
        if (imei != null) {
            return imei;
        }
        imei = Utdid.getImei(context);
        return imei;
    }
}

