/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.scheme;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

public class AppUtils {
    private static String packageName;
    private static String appVersion;
    private static String appName;

    private AppUtils() {
    }

    public static String getPackageName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            return packageName;
        }
        packageName = context.getPackageName();
        return packageName;
    }

    public static String getAppVersion(Context context) {
        if (!TextUtils.isEmpty((CharSequence)appVersion)) {
            return appVersion;
        }
        PackageInfo info = AppUtils.getPackageInfo(context);
        if (null != info) {
            appVersion = info.versionName;
            return appVersion;
        }
        return "";
    }

    public static String getAppName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (null != applicationInfo) {
            int resId = applicationInfo.labelRes;
            appName = 0 == resId ? applicationInfo.nonLocalizedLabel.toString() : context.getString(resId);
            return appName;
        }
        return "";
    }

    private static PackageInfo getPackageInfo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static ApplicationInfo getApplicationInfo(Context context) {
        return context.getApplicationInfo();
    }
}

