/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sls.android.producer.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SoLoader {
    private static final int MAX_RETRY_COUNT = 5;

    private SoLoader() {
    }

    public static SoLoader instance() {
        return new SoLoader();
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    public void loadLibrary(Context context, String library) {
        try {
            System.loadLibrary(library);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (null == context) {
                return;
            }
            File libraryFile = this.getLibraryFile(context, library);
            if (!libraryFile.exists()) {
                this.cleanup(context, library);
            }
            this.installLibrary(context, library);
            System.load(libraryFile.getAbsolutePath());
            return;
        }
    }

    private void cleanup(Context context, String library) {
        File libraryDir = this.getLibraryDir(context);
        if (!libraryDir.exists()) {
            return;
        }
        File libraryFile = this.getLibraryFile(context, library);
        final String mapLibraryName = this.mapLibraryName(library);
        File[] files = libraryDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(mapLibraryName);
            }
        });
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.getAbsolutePath().equals(libraryFile.getAbsolutePath())) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SetWorldReadable", "SetWorldWritable"})
    private void installLibrary(Context context, String library) {
        String[] abis = this.getSupportABIs();
        String mapLibraryName = this.mapLibraryName(library);
        File libraryFile = this.getLibraryFile(context, library);
        ZipFileInEntry zipFileInEntry = this.getZipFileInEntry(context, abis, mapLibraryName);
        if (null == zipFileInEntry) {
            return;
        }
        int tries = 0;
        while (tries++ < 5) {
            try {
                if (!libraryFile.exists() && !libraryFile.createNewFile()) {
                }
            }
            catch (IOException e) {}
            continue;
            InputStream ins = null;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(libraryFile);
                ins = zipFileInEntry.zipFile.getInputStream(zipFileInEntry.zipEntry);
                long written = this.copy(ins, fos);
                fos.getFD().sync();
                if (written != libraryFile.length()) {
                }
            }
            catch (IOException e) {}
            continue;
            finally {
                try {
                    if (ins != null) {
                        ins.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (fos == null) continue;
                    fos.close();
                }
                catch (Throwable throwable) {}
                continue;
            }
            libraryFile.setReadable(true, false);
            libraryFile.setExecutable(true, false);
            libraryFile.setWritable(true, false);
            return;
        }
        try {
            zipFileInEntry.zipFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        long copied = 0L;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            copied += (long)read;
        }
        out.flush();
        return copied;
    }

    private ZipFileInEntry getZipFileInEntry(Context context, String[] abis, String mapLibraryName) {
        for (String apkFile : this.getAPKFiles(context)) {
            ZipFile zipFile = null;
            int tries = 0;
            while (tries++ < 5) {
                try {
                    zipFile = new ZipFile(new File(apkFile), 1);
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (null == zipFile) {
                return null;
            }
            tries = 0;
            while (tries++ < 5) {
                for (String abi : abis) {
                    String soNameInApk = "lib" + File.separatorChar + abi + File.separatorChar + mapLibraryName;
                    ZipEntry libraryEntry = zipFile.getEntry(soNameInApk);
                    if (libraryEntry == null) continue;
                    return new ZipFileInEntry(zipFile, libraryEntry);
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private File getLibraryFile(Context context, String library) {
        return new File(this.getLibraryDir(context), this.mapLibraryName(library));
    }

    private File getLibraryDir(Context context) {
        return context.getDir("libs", 0);
    }

    private String mapLibraryName(String library) {
        if (library.startsWith("lib") && library.endsWith(".so")) {
            return library;
        }
        return System.mapLibraryName(library);
    }

    private String[] getSupportABIs() {
        if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS.length > 0) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    private String[] getAPKFiles(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 21 && applicationInfo.splitSourceDirs != null && applicationInfo.splitSourceDirs.length != 0) {
            String[] apks = new String[applicationInfo.splitSourceDirs.length + 1];
            apks[0] = applicationInfo.sourceDir;
            System.arraycopy(applicationInfo.splitSourceDirs, 0, apks, 1, applicationInfo.splitSourceDirs.length);
            return apks;
        }
        return new String[]{applicationInfo.sourceDir};
    }

    private static class ZipFileInEntry {
        public ZipFile zipFile;
        public ZipEntry zipEntry;

        public ZipFileInEntry(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }
    }
}

