/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.EncryptRequest;
import com.aliyun.dkms.gcs.sdk.models.EncryptResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.kms.model.v20160120.AsymmetricEncryptRequest;
import com.aliyuncs.kms.model.v20160120.AsymmetricEncryptResponse;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsymmetricEncryptTransferHandler
implements KmsTransferHandler<EncryptRequest, EncryptResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public AsymmetricEncryptTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public <T extends AcsResponse> EncryptRequest buildDKMSRequest(AcsRequest<T> request, RuntimeOptions runtimeOptions) throws ClientException {
        AsymmetricEncryptRequest asymmetricEncryptKmsRequest = (AsymmetricEncryptRequest)request;
        if (StringUtils.isEmpty((CharSequence)asymmetricEncryptKmsRequest.getPlaintext())) {
            throw this.newMissingParameterClientException("Plaintext");
        }
        EncryptRequest asymmetricEncryptDKmsRequest = new EncryptRequest();
        asymmetricEncryptDKmsRequest.setKeyId(asymmetricEncryptKmsRequest.getKeyId());
        asymmetricEncryptDKmsRequest.setPlaintext(base64.decode(asymmetricEncryptKmsRequest.getPlaintext()));
        asymmetricEncryptDKmsRequest.setAlgorithm(asymmetricEncryptKmsRequest.getAlgorithm());
        final String keyVersionId = asymmetricEncryptKmsRequest.getKeyVersionId();
        if (!StringUtils.isEmpty((CharSequence)keyVersionId)) {
            asymmetricEncryptDKmsRequest.setRequestHeaders((Map)new HashMap<String, String>(){
                {
                    this.put("x-kms-migrationkeyversionid", keyVersionId);
                }
            });
        }
        return asymmetricEncryptDKmsRequest;
    }

    @Override
    public EncryptResponse callDKMS(EncryptRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.encryptWithOptions(dkmsRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, EncryptResponse response) throws ClientException {
        Map responseHeaders = response.getResponseHeaders();
        String keyVersionId = null;
        if (responseHeaders != null) {
            keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid");
        }
        AsymmetricEncryptResponse asymmetricEncryptKmsResponse = new AsymmetricEncryptResponse();
        asymmetricEncryptKmsResponse.setKeyId(response.getKeyId());
        asymmetricEncryptKmsResponse.setKeyVersionId(keyVersionId);
        asymmetricEncryptKmsResponse.setCiphertextBlob(base64.encodeToString(response.getCiphertextBlob()));
        asymmetricEncryptKmsResponse.setRequestId(response.getRequestId());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)asymmetricEncryptKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

