package com.aliyun.core.tracing;

import com.aliyun.core.logging.ClientLogger;

import java.util.Iterator;
import java.util.ServiceLoader;

public final class AlibabaCloudTracerProvider implements TracerProvider {
    private static final ClientLogger logger = new ClientLogger(AlibabaCloudTracerProvider.class);
    private static final String NO_DEFAULT_PROVIDER = "There is no TracerProvider provider could be found on the classpath.";
    private static final TracerProvider INSTANCE = new AlibabaCloudTracerProvider();
    private static final AlibabaCloudTracer LOAD_TRACER = createTracer();

    private AlibabaCloudTracerProvider() {
    }

    private static AlibabaCloudTracer createTracer() {
        ServiceLoader<AlibabaCloudTracer> serviceLoader = ServiceLoader.load(AlibabaCloudTracer.class, AlibabaCloudTracer.class.getClassLoader());
        Iterator<AlibabaCloudTracer> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            AlibabaCloudTracer tracer = iterator.next();
            logger.info("Found Tracer implementation on the classpath: " + tracer.getClass().getName());
            return tracer;
        } else {
            logger.info(NO_DEFAULT_PROVIDER);
            return NoopAlibabaCloudTracer.INSTANCE;
        }
    }

    public static TracerProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public AlibabaCloudTracer getTracer() {
        return LOAD_TRACER;
    }
}
