/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.text.TextUtils;
import android.util.Xml;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.CRC64;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.AbstractResponseParser;
import com.alibaba.sdk.android.oss.internal.CheckCRC64DownloadInputStream;
import com.alibaba.sdk.android.oss.internal.ResponseMessage;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.AppendObjectResult;
import com.alibaba.sdk.android.oss.model.BucketLifecycleRule;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.CopyObjectResult;
import com.alibaba.sdk.android.oss.model.CreateBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketLifecycleResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketLoggingResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteMultipleObjectResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectTaggingResult;
import com.alibaba.sdk.android.oss.model.GetBucketACLResult;
import com.alibaba.sdk.android.oss.model.GetBucketInfoResult;
import com.alibaba.sdk.android.oss.model.GetBucketLifecycleResult;
import com.alibaba.sdk.android.oss.model.GetBucketLoggingResult;
import com.alibaba.sdk.android.oss.model.GetBucketRefererResult;
import com.alibaba.sdk.android.oss.model.GetObjectACLResult;
import com.alibaba.sdk.android.oss.model.GetObjectMetaResult;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.GetObjectTaggingResult;
import com.alibaba.sdk.android.oss.model.GetSymlinkResult;
import com.alibaba.sdk.android.oss.model.HeadObjectResult;
import com.alibaba.sdk.android.oss.model.ImagePersistResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListBucketsResult;
import com.alibaba.sdk.android.oss.model.ListMultipartUploadsResult;
import com.alibaba.sdk.android.oss.model.ListObjectsResult;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.OSSBucketSummary;
import com.alibaba.sdk.android.oss.model.OSSObjectSummary;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import com.alibaba.sdk.android.oss.model.Owner;
import com.alibaba.sdk.android.oss.model.PartSummary;
import com.alibaba.sdk.android.oss.model.PutBucketLifecycleResult;
import com.alibaba.sdk.android.oss.model.PutBucketLoggingResult;
import com.alibaba.sdk.android.oss.model.PutBucketRefererResult;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.alibaba.sdk.android.oss.model.PutObjectTaggingResult;
import com.alibaba.sdk.android.oss.model.PutSymlinkResult;
import com.alibaba.sdk.android.oss.model.RestoreObjectResult;
import com.alibaba.sdk.android.oss.model.TriggerCallbackResult;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResponseParsers {
    private static CopyObjectResult parseCopyObjectResponseXML(InputStream in, CopyObjectResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("LastModified".equals(name)) {
                        result.setLastModified(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if (!"ETag".equals(name)) break;
                    result.setEtag(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static ListPartsResult parseListPartsResponseXML(InputStream in, ListPartsResult result) throws Exception {
        ArrayList<PartSummary> partEtagList = new ArrayList<PartSummary>();
        PartSummary partSummary = null;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String size;
                    String name = parser.getName();
                    if ("Bucket".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Key".equals(name)) {
                        result.setKey(parser.nextText());
                        break;
                    }
                    if ("UploadId".equals(name)) {
                        result.setUploadId(parser.nextText());
                        break;
                    }
                    if ("PartNumberMarker".equals(name)) {
                        String partNumberMarker = parser.nextText();
                        if (OSSUtils.isEmptyString(partNumberMarker)) break;
                        result.setPartNumberMarker(Integer.parseInt(partNumberMarker));
                        break;
                    }
                    if ("NextPartNumberMarker".equals(name)) {
                        String nextPartNumberMarker = parser.nextText();
                        if (OSSUtils.isEmptyString(nextPartNumberMarker)) break;
                        result.setNextPartNumberMarker(Integer.parseInt(nextPartNumberMarker));
                        break;
                    }
                    if ("MaxParts".equals(name)) {
                        String maxParts = parser.nextText();
                        if (OSSUtils.isEmptyString(maxParts)) break;
                        result.setMaxParts(Integer.parseInt(maxParts));
                        break;
                    }
                    if ("IsTruncated".equals(name)) {
                        String isTruncated = parser.nextText();
                        if (OSSUtils.isEmptyString(isTruncated)) break;
                        result.setTruncated(Boolean.valueOf(isTruncated));
                        break;
                    }
                    if ("StorageClass".equals(name)) {
                        result.setStorageClass(parser.nextText());
                        break;
                    }
                    if ("Part".equals(name)) {
                        partSummary = new PartSummary();
                        break;
                    }
                    if ("PartNumber".equals(name)) {
                        String partNum = parser.nextText();
                        if (OSSUtils.isEmptyString(partNum)) break;
                        partSummary.setPartNumber(Integer.valueOf(partNum));
                        break;
                    }
                    if ("LastModified".equals(name)) {
                        partSummary.setLastModified(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if ("ETag".equals(name)) {
                        partSummary.setETag(parser.nextText());
                        break;
                    }
                    if (!"Size".equals(name) || OSSUtils.isEmptyString(size = parser.nextText())) break;
                    partSummary.setSize(Long.valueOf(size));
                    break;
                }
                case 3: {
                    if (!"Part".equals(parser.getName())) break;
                    partEtagList.add(partSummary);
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        if (partEtagList.size() > 0) {
            result.setParts(partEtagList);
        }
        return result;
    }

    private static CompleteMultipartUploadResult parseCompleteMultipartUploadResponseXML(InputStream in, CompleteMultipartUploadResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Location".equals(name)) {
                        result.setLocation(parser.nextText());
                        break;
                    }
                    if ("Bucket".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Key".equals(name)) {
                        result.setObjectKey(parser.nextText());
                        break;
                    }
                    if (!"ETag".equals(name)) break;
                    result.setETag(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static InitiateMultipartUploadResult parseInitMultipartResponseXML(InputStream in, InitiateMultipartUploadResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Bucket".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Key".equals(name)) {
                        result.setObjectKey(parser.nextText());
                        break;
                    }
                    if (!"UploadId".equals(name)) break;
                    result.setUploadId(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetObjectACLResult parseGetObjectACLResponse(InputStream in, GetObjectACLResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Grant".equals(name)) {
                        result.setObjectACL(parser.nextText());
                        break;
                    }
                    if ("ID".equals(name)) {
                        result.setObjectOwnerID(parser.nextText());
                        break;
                    }
                    if (!"DisplayName".equals(name)) break;
                    result.setObjectOwner(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetBucketInfoResult parseGetBucketInfoResponse(InputStream in, GetBucketInfoResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        OSSBucketSummary bucket = null;
        Owner owner = null;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if (name == null) break;
                    if ("Owner".equals(name)) {
                        owner = new Owner();
                        break;
                    }
                    if ("ID".equals(name)) {
                        if (owner == null) break;
                        owner.setId(parser.nextText());
                        break;
                    }
                    if ("DisplayName".equals(name)) {
                        if (owner == null) break;
                        owner.setDisplayName(parser.nextText());
                        break;
                    }
                    if ("Bucket".equals(name)) {
                        bucket = new OSSBucketSummary();
                        break;
                    }
                    if ("CreationDate".equals(name)) {
                        if (bucket == null) break;
                        bucket.createDate = DateUtil.parseIso8601Date(parser.nextText());
                        break;
                    }
                    if ("ExtranetEndpoint".equals(name)) {
                        if (bucket == null) break;
                        bucket.extranetEndpoint = parser.nextText();
                        break;
                    }
                    if ("IntranetEndpoint".equals(name)) {
                        if (bucket == null) break;
                        bucket.intranetEndpoint = parser.nextText();
                        break;
                    }
                    if ("Location".equals(name)) {
                        if (bucket == null) break;
                        bucket.location = parser.nextText();
                        break;
                    }
                    if ("Name".equals(name)) {
                        if (bucket == null) break;
                        bucket.name = parser.nextText();
                        break;
                    }
                    if ("StorageClass".equals(name)) {
                        if (bucket == null) break;
                        bucket.storageClass = parser.nextText();
                        break;
                    }
                    if (!"Grant".equals(name) || bucket == null) break;
                    bucket.setAcl(parser.nextText());
                    break;
                }
                case 3: {
                    String endTagName = parser.getName();
                    if (endTagName == null) break;
                    if ("Bucket".equals(endTagName)) {
                        if (bucket == null) break;
                        result.setBucket(bucket);
                        break;
                    }
                    if (!"Owner".equals(endTagName) || bucket == null) break;
                    bucket.owner = owner;
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetBucketACLResult parseGetBucketACLResponse(InputStream in, GetBucketACLResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Grant".equals(name)) {
                        result.setBucketACL(parser.nextText());
                        break;
                    }
                    if ("ID".equals(name)) {
                        result.setBucketOwnerID(parser.nextText());
                        break;
                    }
                    if (!"DisplayName".equals(name)) break;
                    result.setBucketOwner(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetBucketRefererResult parseGetBucketRefererResponse(InputStream in, GetBucketRefererResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if (!"Referer".equals(name)) break;
                    result.addReferer(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetBucketLoggingResult parseGetBucketLoggingResponse(InputStream in, GetBucketLoggingResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("LoggingEnabled".equals(name)) {
                        result.setLoggingEnabled(true);
                        break;
                    }
                    if ("TargetBucket".equals(name)) {
                        result.setTargetBucketName(parser.nextText());
                        break;
                    }
                    if (!"TargetPrefix".equals(name)) break;
                    result.setTargetPrefix(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetBucketLifecycleResult parseGetBucketLifecycleResponse(InputStream in, GetBucketLifecycleResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        BucketLifecycleRule lifecycleRule = null;
        boolean isExpirationConf = false;
        boolean isMultipartConf = false;
        boolean isTransitionConf = false;
        String daysValue = null;
        String dateValue = null;
        String storageClass = null;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Rule".equals(name)) {
                        lifecycleRule = new BucketLifecycleRule();
                        break;
                    }
                    if ("ID".equals(name)) {
                        lifecycleRule.setIdentifier(parser.nextText());
                        break;
                    }
                    if ("Prefix".equals(name)) {
                        lifecycleRule.setPrefix(parser.nextText());
                        break;
                    }
                    if ("Status".equals(name)) {
                        String statusValue = parser.nextText();
                        if ("Enabled".equals(statusValue)) {
                            lifecycleRule.setStatus(true);
                            break;
                        }
                        lifecycleRule.setStatus(false);
                        break;
                    }
                    if ("Expiration".equals(name)) {
                        isExpirationConf = true;
                        break;
                    }
                    if ("AbortMultipartUpload".equals(name)) {
                        isMultipartConf = true;
                        break;
                    }
                    if ("Transition".equals(name)) {
                        isTransitionConf = true;
                        break;
                    }
                    if ("Days".equals(name)) {
                        daysValue = parser.nextText();
                        if (lifecycleRule == null) break;
                        if (isExpirationConf) {
                            lifecycleRule.setDays(daysValue);
                            break;
                        }
                        if (isMultipartConf) {
                            lifecycleRule.setMultipartDays(daysValue);
                            break;
                        }
                        if (!isTransitionConf || storageClass == null) break;
                        if ("IA".equals(storageClass)) {
                            lifecycleRule.setIADays(daysValue);
                            break;
                        }
                        if (!"Archive".equals(storageClass)) break;
                        lifecycleRule.setArchiveDays(daysValue);
                        break;
                    }
                    if ("Date".equals(name)) {
                        dateValue = parser.nextText();
                        if (lifecycleRule == null) break;
                        if (isExpirationConf) {
                            lifecycleRule.setExpireDate(dateValue);
                            break;
                        }
                        if (isMultipartConf) {
                            lifecycleRule.setMultipartExpireDate(dateValue);
                            break;
                        }
                        if (!isTransitionConf || storageClass == null) break;
                        if ("IA".equals(storageClass)) {
                            lifecycleRule.setIAExpireDate(dateValue);
                            break;
                        }
                        if (!"Archive".equals(storageClass)) break;
                        lifecycleRule.setArchiveExpireDate(dateValue);
                        break;
                    }
                    if (!"StorageClass".equals(name)) break;
                    storageClass = parser.nextText();
                    if (lifecycleRule == null) break;
                    if ("IA".equals(storageClass)) {
                        lifecycleRule.setIADays(daysValue);
                        lifecycleRule.setIAExpireDate(dateValue);
                        break;
                    }
                    if (!"Archive".equals(storageClass)) break;
                    lifecycleRule.setArchiveDays(dateValue);
                    lifecycleRule.setArchiveExpireDate(dateValue);
                    break;
                }
                case 3: {
                    String endTag = parser.getName();
                    if ("Rule".equals(endTag)) {
                        result.addLifecycleRule(lifecycleRule);
                        break;
                    }
                    if ("Expiration".equals(endTag)) {
                        isExpirationConf = false;
                        break;
                    }
                    if ("AbortMultipartUpload".equals(endTag)) {
                        isMultipartConf = false;
                        break;
                    }
                    if (!"Transition".equals(endTag)) break;
                    isTransitionConf = false;
                    daysValue = null;
                    dateValue = null;
                    storageClass = null;
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static DeleteMultipleObjectResult parseDeleteMultipleObjectResponse(InputStream in, DeleteMultipleObjectResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if (!"Key".equals(name)) break;
                    result.addDeletedObject(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static ListBucketsResult parseBucketListResponse(InputStream in, ListBucketsResult result) throws Exception {
        result.clearBucketList();
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        OSSBucketSummary bucket = null;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if (name == null) break;
                    if ("Prefix".equals(name)) {
                        result.setPrefix(parser.nextText());
                        break;
                    }
                    if ("Marker".equals(name)) {
                        result.setMarker(parser.nextText());
                        break;
                    }
                    if ("MaxKeys".equals(name)) {
                        String maxKeys = parser.nextText();
                        if (maxKeys == null) break;
                        result.setMaxKeys(Integer.valueOf(maxKeys));
                        break;
                    }
                    if ("IsTruncated".equals(name)) {
                        String isTruncated = parser.nextText();
                        if (isTruncated == null) break;
                        result.setTruncated(Boolean.valueOf(isTruncated));
                        break;
                    }
                    if ("NextMarker".equals(name)) {
                        result.setNextMarker(parser.nextText());
                        break;
                    }
                    if ("ID".equals(name)) {
                        result.setOwnerId(parser.nextText());
                        break;
                    }
                    if ("DisplayName".equals(name)) {
                        result.setOwnerDisplayName(parser.nextText());
                        break;
                    }
                    if ("Bucket".equals(name)) {
                        bucket = new OSSBucketSummary();
                        break;
                    }
                    if ("CreationDate".equals(name)) {
                        if (bucket == null) break;
                        bucket.createDate = DateUtil.parseIso8601Date(parser.nextText());
                        break;
                    }
                    if ("ExtranetEndpoint".equals(name)) {
                        if (bucket == null) break;
                        bucket.extranetEndpoint = parser.nextText();
                        break;
                    }
                    if ("IntranetEndpoint".equals(name)) {
                        if (bucket == null) break;
                        bucket.intranetEndpoint = parser.nextText();
                        break;
                    }
                    if ("Location".equals(name)) {
                        if (bucket == null) break;
                        bucket.location = parser.nextText();
                        break;
                    }
                    if ("Name".equals(name)) {
                        if (bucket == null) break;
                        bucket.name = parser.nextText();
                        break;
                    }
                    if (!"StorageClass".equals(name) || bucket == null) break;
                    bucket.storageClass = parser.nextText();
                    break;
                }
                case 3: {
                    String endTagName = parser.getName();
                    if (!"Bucket".equals(endTagName) || bucket == null) break;
                    result.addBucket(bucket);
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static ListObjectsResult parseObjectListResponse(InputStream in, ListObjectsResult result) throws Exception {
        result.clearCommonPrefixes();
        result.clearObjectSummaries();
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        OSSObjectSummary object = null;
        Owner owner = null;
        boolean isCommonPrefixes = false;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Name".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Prefix".equals(name)) {
                        if (isCommonPrefixes) {
                            String commonPrefix = parser.nextText();
                            if (OSSUtils.isEmptyString(commonPrefix)) break;
                            result.addCommonPrefix(commonPrefix);
                            break;
                        }
                        result.setPrefix(parser.nextText());
                        break;
                    }
                    if ("Marker".equals(name)) {
                        result.setMarker(parser.nextText());
                        break;
                    }
                    if ("Delimiter".equals(name)) {
                        result.setDelimiter(parser.nextText());
                        break;
                    }
                    if ("EncodingType".equals(name)) {
                        result.setEncodingType(parser.nextText());
                        break;
                    }
                    if ("MaxKeys".equals(name)) {
                        String maxKeys = parser.nextText();
                        if (OSSUtils.isEmptyString(maxKeys)) break;
                        result.setMaxKeys(Integer.valueOf(maxKeys));
                        break;
                    }
                    if ("NextMarker".equals(name)) {
                        result.setNextMarker(parser.nextText());
                        break;
                    }
                    if ("IsTruncated".equals(name)) {
                        String isTruncated = parser.nextText();
                        if (OSSUtils.isEmptyString(isTruncated)) break;
                        result.setTruncated(Boolean.valueOf(isTruncated));
                        break;
                    }
                    if ("Contents".equals(name)) {
                        object = new OSSObjectSummary();
                        break;
                    }
                    if ("Key".equals(name)) {
                        object.setKey(parser.nextText());
                        break;
                    }
                    if ("LastModified".equals(name)) {
                        object.setLastModified(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if ("Size".equals(name)) {
                        String size = parser.nextText();
                        if (OSSUtils.isEmptyString(size)) break;
                        object.setSize(Long.valueOf(size));
                        break;
                    }
                    if ("ETag".equals(name)) {
                        object.setETag(parser.nextText());
                        break;
                    }
                    if ("Type".equals(name)) {
                        object.setType(parser.nextText());
                        break;
                    }
                    if ("StorageClass".equals(name)) {
                        object.setStorageClass(parser.nextText());
                        break;
                    }
                    if ("Owner".equals(name)) {
                        owner = new Owner();
                        break;
                    }
                    if ("ID".equals(name)) {
                        owner.setId(parser.nextText());
                        break;
                    }
                    if ("DisplayName".equals(name)) {
                        owner.setDisplayName(parser.nextText());
                        break;
                    }
                    if (!"CommonPrefixes".equals(name)) break;
                    isCommonPrefixes = true;
                    break;
                }
                case 3: {
                    String endTagName = parser.getName();
                    if ("Owner".equals(parser.getName())) {
                        if (owner == null) break;
                        object.setOwner(owner);
                        break;
                    }
                    if ("Contents".equals(endTagName)) {
                        if (object == null) break;
                        object.setBucketName(result.getBucketName());
                        result.addObjectSummary(object);
                        break;
                    }
                    if (!"CommonPrefixes".equals(endTagName)) break;
                    isCommonPrefixes = false;
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    public static String trimQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws Exception {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    objectMetadata.addUserMetadata(key, headers.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Last-Modified") || key.equalsIgnoreCase("Date")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.getMessage(), pe);
                    }
                }
                if (key.equalsIgnoreCase("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equalsIgnoreCase("ETag")) {
                    objectMetadata.setHeader(key, ResponseParsers.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static Exception parseResponseErrorXML(ResponseMessage response, boolean isHeadRequest) {
        int statusCode = response.getStatusCode();
        String requestId = response.getResponse().header("x-oss-request-id");
        String code = null;
        String message = null;
        String hostId = null;
        String partNumber = null;
        String partEtag = null;
        String errorMessage = null;
        String ec = response.getResponse().header("x-oss-ec");
        String recommendDoc = null;
        if (!isHeadRequest) {
            try {
                errorMessage = response.getResponse().body().string();
                OSSLog.logDebug("errorMessage  \uff1a  \n " + errorMessage);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(errorMessage.getBytes());
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((InputStream)inputStream, "utf-8");
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    switch (eventType) {
                        case 2: {
                            if ("Code".equals(parser.getName())) {
                                code = parser.nextText();
                                break;
                            }
                            if ("Message".equals(parser.getName())) {
                                message = parser.nextText();
                                break;
                            }
                            if ("RequestId".equals(parser.getName())) {
                                requestId = parser.nextText();
                                break;
                            }
                            if ("HostId".equals(parser.getName())) {
                                hostId = parser.nextText();
                                break;
                            }
                            if ("PartNumber".equals(parser.getName())) {
                                partNumber = parser.nextText();
                                break;
                            }
                            if ("PartEtag".equals(parser.getName())) {
                                partEtag = parser.nextText();
                                break;
                            }
                            if ("EC".equals(parser.getName())) {
                                ec = parser.nextText();
                                break;
                            }
                            if (!"RecommendDoc".equals(parser.getName())) break;
                            recommendDoc = parser.nextText();
                        }
                    }
                    if ((eventType = parser.next()) != 4) continue;
                    eventType = parser.next();
                }
            }
            catch (IOException e) {
                return new ClientException(e.getMessage(), e);
            }
            catch (XmlPullParserException e) {
                return new ClientException(e.getMessage(), e);
            }
        }
        ServiceException serviceException = new ServiceException(statusCode, message, code, requestId, hostId, errorMessage, ec);
        if (!TextUtils.isEmpty(partEtag)) {
            serviceException.setPartEtag(partEtag);
        }
        if (!TextUtils.isEmpty(partNumber)) {
            serviceException.setPartNumber(partNumber);
        }
        if (!TextUtils.isEmpty(recommendDoc)) {
            serviceException.setRecommendDoc(recommendDoc);
        }
        return serviceException;
    }

    private static GetObjectTaggingResult parseGetObjectTaggingResponse(InputStream in, GetObjectTaggingResult result) throws Exception {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        HashMap<String, String> tags = new HashMap<String, String>();
        String key = null;
        String value = null;
        while (eventType != 1) {
            String name = parser.getName();
            switch (eventType) {
                case 2: {
                    if ("Key".equals(name)) {
                        key = parser.nextText();
                        break;
                    }
                    if (!"Value".equals(name)) break;
                    value = parser.nextText();
                    break;
                }
                case 3: {
                    if (!"Tag".equals(name)) break;
                    if (key != null && value != null) {
                        tags.put(key, value);
                    }
                    key = null;
                    value = null;
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        result.setTags(tags);
        return result;
    }

    public static final class DeleteObjectTaggingResponseParser
    extends AbstractResponseParser<DeleteObjectTaggingResult> {
        @Override
        DeleteObjectTaggingResult parseData(ResponseMessage response, DeleteObjectTaggingResult result) throws Exception {
            return result;
        }
    }

    public static final class GetObjectTaggingResponseParser
    extends AbstractResponseParser<GetObjectTaggingResult> {
        @Override
        GetObjectTaggingResult parseData(ResponseMessage response, GetObjectTaggingResult result) throws Exception {
            result = ResponseParsers.parseGetObjectTaggingResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class PutObjectTaggingResponseParser
    extends AbstractResponseParser<PutObjectTaggingResult> {
        @Override
        PutObjectTaggingResult parseData(ResponseMessage response, PutObjectTaggingResult result) throws Exception {
            return result;
        }
    }

    public static final class RestoreObjectResponseParser
    extends AbstractResponseParser<RestoreObjectResult> {
        @Override
        RestoreObjectResult parseData(ResponseMessage response, RestoreObjectResult result) throws Exception {
            return result;
        }
    }

    public static final class GetSymlinkResponseParser
    extends AbstractResponseParser<GetSymlinkResult> {
        @Override
        GetSymlinkResult parseData(ResponseMessage response, GetSymlinkResult result) throws Exception {
            result.setTargetObjectName((String)response.getHeaders().get("x-oss-symlink-target"));
            return result;
        }
    }

    public static final class PutSymlinkResponseParser
    extends AbstractResponseParser<PutSymlinkResult> {
        @Override
        PutSymlinkResult parseData(ResponseMessage response, PutSymlinkResult result) throws Exception {
            return result;
        }
    }

    public static final class ImagePersistResponseParser
    extends AbstractResponseParser<ImagePersistResult> {
        @Override
        public ImagePersistResult parseData(ResponseMessage response, ImagePersistResult result) throws Exception {
            return result;
        }
    }

    public static final class TriggerCallbackResponseParser
    extends AbstractResponseParser<TriggerCallbackResult> {
        @Override
        public TriggerCallbackResult parseData(ResponseMessage response, TriggerCallbackResult result) throws Exception {
            String body = response.getResponse().body().string();
            if (!TextUtils.isEmpty((CharSequence)body)) {
                result.setServerCallbackReturnBody(body);
            }
            return result;
        }
    }

    public static final class ListMultipartUploadsResponseParser
    extends AbstractResponseParser<ListMultipartUploadsResult> {
        @Override
        public ListMultipartUploadsResult parseData(ResponseMessage response, ListMultipartUploadsResult result) throws Exception {
            return result.parseData(response);
        }
    }

    public static final class ListPartsResponseParser
    extends AbstractResponseParser<ListPartsResult> {
        @Override
        public ListPartsResult parseData(ResponseMessage response, ListPartsResult result) throws Exception {
            result = ResponseParsers.parseListPartsResponseXML(response.getContent(), result);
            return result;
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    extends AbstractResponseParser<CompleteMultipartUploadResult> {
        @Override
        public CompleteMultipartUploadResult parseData(ResponseMessage response, CompleteMultipartUploadResult result) throws Exception {
            if (((String)response.getHeaders().get("Content-Type")).equals("application/xml")) {
                result = ResponseParsers.parseCompleteMultipartUploadResponseXML(response.getContent(), result);
            } else {
                String body = response.getResponse().body().string();
                if (!TextUtils.isEmpty((CharSequence)body)) {
                    result.setServerCallbackReturnBody(body);
                }
            }
            return result;
        }
    }

    public static final class AbortMultipartUploadResponseParser
    extends AbstractResponseParser<AbortMultipartUploadResult> {
        @Override
        public AbortMultipartUploadResult parseData(ResponseMessage response, AbortMultipartUploadResult result) throws Exception {
            return result;
        }
    }

    public static final class UploadPartResponseParser
    extends AbstractResponseParser<UploadPartResult> {
        @Override
        public UploadPartResult parseData(ResponseMessage response, UploadPartResult result) throws Exception {
            result.setETag(ResponseParsers.trimQuotes((String)response.getHeaders().get("ETag")));
            return result;
        }
    }

    public static final class InitMultipartResponseParser
    extends AbstractResponseParser<InitiateMultipartUploadResult> {
        @Override
        public InitiateMultipartUploadResult parseData(ResponseMessage response, InitiateMultipartUploadResult result) throws Exception {
            return ResponseParsers.parseInitMultipartResponseXML(response.getContent(), result);
        }
    }

    public static final class ListBucketResponseParser
    extends AbstractResponseParser<ListBucketsResult> {
        @Override
        ListBucketsResult parseData(ResponseMessage response, ListBucketsResult result) throws Exception {
            result = ResponseParsers.parseBucketListResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class ListObjectsResponseParser
    extends AbstractResponseParser<ListObjectsResult> {
        @Override
        public ListObjectsResult parseData(ResponseMessage response, ListObjectsResult result) throws Exception {
            result = ResponseParsers.parseObjectListResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class DeleteMultipleObjectResponseParser
    extends AbstractResponseParser<DeleteMultipleObjectResult> {
        @Override
        DeleteMultipleObjectResult parseData(ResponseMessage response, DeleteMultipleObjectResult result) throws Exception {
            result = ResponseParsers.parseDeleteMultipleObjectResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class DeleteObjectResponseParser
    extends AbstractResponseParser<DeleteObjectResult> {
        @Override
        public DeleteObjectResult parseData(ResponseMessage response, DeleteObjectResult result) throws Exception {
            return result;
        }
    }

    public static final class DeleteBucketLifecycleResponseParser
    extends AbstractResponseParser<DeleteBucketLifecycleResult> {
        @Override
        public DeleteBucketLifecycleResult parseData(ResponseMessage response, DeleteBucketLifecycleResult result) throws Exception {
            return result;
        }
    }

    public static final class GetBucketLifecycleResponseParser
    extends AbstractResponseParser<GetBucketLifecycleResult> {
        @Override
        public GetBucketLifecycleResult parseData(ResponseMessage response, GetBucketLifecycleResult result) throws Exception {
            result = ResponseParsers.parseGetBucketLifecycleResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class PutBucketLifecycleResponseParser
    extends AbstractResponseParser<PutBucketLifecycleResult> {
        @Override
        public PutBucketLifecycleResult parseData(ResponseMessage response, PutBucketLifecycleResult result) throws Exception {
            return result;
        }
    }

    public static final class DeleteBucketLoggingResponseParser
    extends AbstractResponseParser<DeleteBucketLoggingResult> {
        @Override
        public DeleteBucketLoggingResult parseData(ResponseMessage response, DeleteBucketLoggingResult result) throws Exception {
            return result;
        }
    }

    public static final class GetBucketLoggingResponseParser
    extends AbstractResponseParser<GetBucketLoggingResult> {
        @Override
        public GetBucketLoggingResult parseData(ResponseMessage response, GetBucketLoggingResult result) throws Exception {
            result = ResponseParsers.parseGetBucketLoggingResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class PutBucketLoggingResponseParser
    extends AbstractResponseParser<PutBucketLoggingResult> {
        @Override
        public PutBucketLoggingResult parseData(ResponseMessage response, PutBucketLoggingResult result) throws Exception {
            return result;
        }
    }

    public static final class GetBucketRefererResponseParser
    extends AbstractResponseParser<GetBucketRefererResult> {
        @Override
        public GetBucketRefererResult parseData(ResponseMessage response, GetBucketRefererResult result) throws Exception {
            result = ResponseParsers.parseGetBucketRefererResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class PutBucketRefererResponseParser
    extends AbstractResponseParser<PutBucketRefererResult> {
        @Override
        public PutBucketRefererResult parseData(ResponseMessage response, PutBucketRefererResult result) throws Exception {
            return result;
        }
    }

    public static final class GetBucketACLResponseParser
    extends AbstractResponseParser<GetBucketACLResult> {
        @Override
        public GetBucketACLResult parseData(ResponseMessage response, GetBucketACLResult result) throws Exception {
            result = ResponseParsers.parseGetBucketACLResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class GetBucketInfoResponseParser
    extends AbstractResponseParser<GetBucketInfoResult> {
        @Override
        public GetBucketInfoResult parseData(ResponseMessage response, GetBucketInfoResult result) throws Exception {
            result = ResponseParsers.parseGetBucketInfoResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class DeleteBucketResponseParser
    extends AbstractResponseParser<DeleteBucketResult> {
        @Override
        public DeleteBucketResult parseData(ResponseMessage response, DeleteBucketResult result) throws Exception {
            return result;
        }
    }

    public static final class CreateBucketResponseParser
    extends AbstractResponseParser<CreateBucketResult> {
        @Override
        public CreateBucketResult parseData(ResponseMessage response, CreateBucketResult result) throws Exception {
            if (result.getResponseHeader().containsKey("Location")) {
                result.bucketLocation = result.getResponseHeader().get("Location");
            }
            return result;
        }
    }

    public static final class CopyObjectResponseParser
    extends AbstractResponseParser<CopyObjectResult> {
        @Override
        public CopyObjectResult parseData(ResponseMessage response, CopyObjectResult result) throws Exception {
            result = ResponseParsers.parseCopyObjectResponseXML(response.getContent(), result);
            return result;
        }
    }

    public static final class GetObjectACLResponseParser
    extends AbstractResponseParser<GetObjectACLResult> {
        @Override
        GetObjectACLResult parseData(ResponseMessage response, GetObjectACLResult result) throws Exception {
            result = ResponseParsers.parseGetObjectACLResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class GetObjectResponseParser
    extends AbstractResponseParser<GetObjectResult> {
        @Override
        public GetObjectResult parseData(ResponseMessage response, GetObjectResult result) throws Exception {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            result.setContentLength(response.getContentLength());
            if (response.getRequest().isCheckCRC64()) {
                result.setObjectContent(new CheckCRC64DownloadInputStream(response.getContent(), new CRC64(), response.getContentLength(), result.getServerCRC(), result.getRequestId()));
            } else {
                result.setObjectContent(response.getContent());
            }
            return result;
        }

        @Override
        public boolean needCloseResponse() {
            return false;
        }
    }

    public static final class HeadObjectResponseParser
    extends AbstractResponseParser<HeadObjectResult> {
        @Override
        public HeadObjectResult parseData(ResponseMessage response, HeadObjectResult result) throws Exception {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            return result;
        }
    }

    public static final class AppendObjectResponseParser
    extends AbstractResponseParser<AppendObjectResult> {
        @Override
        public AppendObjectResult parseData(ResponseMessage response, AppendObjectResult result) throws IOException {
            String nextPosition = (String)response.getHeaders().get("x-oss-next-append-position");
            if (nextPosition != null) {
                result.setNextPosition(Long.valueOf(nextPosition));
            }
            result.setObjectCRC64((String)response.getHeaders().get("x-oss-hash-crc64ecma"));
            return result;
        }
    }

    public static final class PutObjectResponseParser
    extends AbstractResponseParser<PutObjectResult> {
        @Override
        public PutObjectResult parseData(ResponseMessage response, PutObjectResult result) throws IOException {
            result.setETag(ResponseParsers.trimQuotes((String)response.getHeaders().get("ETag")));
            String body = response.getResponse().body().string();
            if (!TextUtils.isEmpty((CharSequence)body)) {
                result.setServerCallbackReturnBody(body);
            }
            return result;
        }
    }

    public static final class GetObjectMetaResponseParser
    extends AbstractResponseParser<GetObjectMetaResult> {
        @Override
        public GetObjectMetaResult parseData(ResponseMessage response, GetObjectMetaResult result) throws Exception {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            return result;
        }
    }
}

