/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.content.Context;
import android.net.Proxy;
import android.os.Build;
import android.text.TextUtils;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.common.HttpMethod;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.BinaryUtil;
import com.alibaba.sdk.android.oss.common.utils.CRC64;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.HttpUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.common.utils.VersionInfoUtils;
import com.alibaba.sdk.android.oss.exception.InconsistentException;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParsers;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.AppendObjectRequest;
import com.alibaba.sdk.android.oss.model.AppendObjectResult;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.CopyObjectRequest;
import com.alibaba.sdk.android.oss.model.CopyObjectResult;
import com.alibaba.sdk.android.oss.model.CreateBucketRequest;
import com.alibaba.sdk.android.oss.model.CreateBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketLifecycleRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketLifecycleResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketLoggingRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketLoggingResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteMultipleObjectRequest;
import com.alibaba.sdk.android.oss.model.DeleteMultipleObjectResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectRequest;
import com.alibaba.sdk.android.oss.model.DeleteObjectResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectTaggingRequest;
import com.alibaba.sdk.android.oss.model.DeleteObjectTaggingResult;
import com.alibaba.sdk.android.oss.model.GetBucketACLRequest;
import com.alibaba.sdk.android.oss.model.GetBucketACLResult;
import com.alibaba.sdk.android.oss.model.GetBucketInfoRequest;
import com.alibaba.sdk.android.oss.model.GetBucketInfoResult;
import com.alibaba.sdk.android.oss.model.GetBucketLifecycleRequest;
import com.alibaba.sdk.android.oss.model.GetBucketLifecycleResult;
import com.alibaba.sdk.android.oss.model.GetBucketLoggingRequest;
import com.alibaba.sdk.android.oss.model.GetBucketLoggingResult;
import com.alibaba.sdk.android.oss.model.GetBucketRefererRequest;
import com.alibaba.sdk.android.oss.model.GetBucketRefererResult;
import com.alibaba.sdk.android.oss.model.GetObjectACLRequest;
import com.alibaba.sdk.android.oss.model.GetObjectACLResult;
import com.alibaba.sdk.android.oss.model.GetObjectMetaRequest;
import com.alibaba.sdk.android.oss.model.GetObjectMetaResult;
import com.alibaba.sdk.android.oss.model.GetObjectRequest;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.GetObjectTaggingRequest;
import com.alibaba.sdk.android.oss.model.GetObjectTaggingResult;
import com.alibaba.sdk.android.oss.model.GetSymlinkRequest;
import com.alibaba.sdk.android.oss.model.GetSymlinkResult;
import com.alibaba.sdk.android.oss.model.HeadObjectRequest;
import com.alibaba.sdk.android.oss.model.HeadObjectResult;
import com.alibaba.sdk.android.oss.model.ImagePersistRequest;
import com.alibaba.sdk.android.oss.model.ImagePersistResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListBucketsRequest;
import com.alibaba.sdk.android.oss.model.ListBucketsResult;
import com.alibaba.sdk.android.oss.model.ListMultipartUploadsRequest;
import com.alibaba.sdk.android.oss.model.ListMultipartUploadsResult;
import com.alibaba.sdk.android.oss.model.ListObjectsRequest;
import com.alibaba.sdk.android.oss.model.ListObjectsResult;
import com.alibaba.sdk.android.oss.model.ListPartsRequest;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.model.PartETag;
import com.alibaba.sdk.android.oss.model.PutBucketLifecycleRequest;
import com.alibaba.sdk.android.oss.model.PutBucketLifecycleResult;
import com.alibaba.sdk.android.oss.model.PutBucketLoggingRequest;
import com.alibaba.sdk.android.oss.model.PutBucketLoggingResult;
import com.alibaba.sdk.android.oss.model.PutBucketRefererRequest;
import com.alibaba.sdk.android.oss.model.PutBucketRefererResult;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.alibaba.sdk.android.oss.model.PutObjectTaggingRequest;
import com.alibaba.sdk.android.oss.model.PutObjectTaggingResult;
import com.alibaba.sdk.android.oss.model.PutSymlinkRequest;
import com.alibaba.sdk.android.oss.model.PutSymlinkResult;
import com.alibaba.sdk.android.oss.model.RestoreObjectRequest;
import com.alibaba.sdk.android.oss.model.RestoreObjectResult;
import com.alibaba.sdk.android.oss.model.TriggerCallbackRequest;
import com.alibaba.sdk.android.oss.model.TriggerCallbackResult;
import com.alibaba.sdk.android.oss.model.UploadPartRequest;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.alibaba.sdk.android.oss.network.OSSRequestTask;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class InternalRequestOperation {
    private static final int LIST_PART_MAX_RETURNS = 1000;
    private static final int MAX_PART_NUMBER = 10000;
    private static ExecutorService executorServiceDefault = Executors.newFixedThreadPool(5, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "oss-android-api-thread");
        }
    });
    private ExecutorService executorService;
    private volatile URI endpoint;
    private URI service;
    private OkHttpClient innerClient;
    private Context applicationContext;
    private OSSCredentialProvider credentialProvider;
    private int maxRetryCount = 2;
    private ClientConfiguration conf;

    public InternalRequestOperation(Context context, URI endpoint, OSSCredentialProvider credentialProvider, ClientConfiguration conf) {
        this.applicationContext = context;
        this.endpoint = endpoint;
        this.service = endpoint;
        this.credentialProvider = credentialProvider;
        this.conf = conf;
        this.maxRetryCount = conf.getMaxErrorRetry();
        this.executorService = conf.getExecutorService() != null ? conf.getExecutorService() : executorServiceDefault;
        this.innerClient = this.buildOkHttpClient(endpoint.getHost(), conf);
    }

    public InternalRequestOperation(Context context, OSSCredentialProvider credentialProvider, ClientConfiguration conf) {
        try {
            this.service = new URI(conf.getHttpProtocol().toString() + "://oss.aliyuncs.com");
            this.endpoint = new URI(conf.getHttpProtocol().toString() + "://127.0.0.1");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Endpoint must be a string like 'http://oss-cn-****.aliyuncs.com',or your cname like 'http://image.cnamedomain.com'!");
        }
        this.applicationContext = context;
        this.credentialProvider = credentialProvider;
        this.conf = conf;
        this.maxRetryCount = conf.getMaxErrorRetry();
        this.executorService = conf.getExecutorService() != null ? conf.getExecutorService() : executorServiceDefault;
        this.innerClient = this.buildOkHttpClient(this.service.getHost(), conf);
    }

    private OkHttpClient buildOkHttpClient(final String host, ClientConfiguration conf) {
        if (conf.getOkHttpClient() != null) {
            return conf.getOkHttpClient();
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(conf.isFollowRedirectsEnable()).followSslRedirects(conf.isFollowRedirectsEnable()).retryOnConnectionFailure(false).cache(null).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session);
            }
        });
        if (conf != null) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(conf.getMaxConcurrentRequest());
            if (conf.getMaxConcurrentRequestsPerHost() > 0) {
                dispatcher.setMaxRequestsPerHost(conf.getMaxConcurrentRequestsPerHost());
            }
            builder.connectTimeout((long)conf.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).dispatcher(dispatcher);
            if (conf.getProxyHost() != null && conf.getProxyPort() != 0) {
                builder.proxy(new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(conf.getProxyHost(), conf.getProxyPort())));
            }
        }
        return builder.build();
    }

    public PutObjectResult syncPutObject(PutObjectRequest request) throws ClientException, ServiceException {
        PutObjectResult result = this.putObject(request, null).getResult();
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<PutObjectResult> putObject(PutObjectRequest request, final OSSCompletedCallback<PutObjectRequest, PutObjectResult> completedCallback) {
        OSSLog.logDebug(" Internal putObject Start ");
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getUploadData() != null) {
            requestMessage.setUploadData(request.getUploadData());
        }
        if (request.getUploadFilePath() != null) {
            requestMessage.setUploadFilePath(request.getUploadFilePath());
        }
        if (request.getUploadUri() != null) {
            requestMessage.setUploadUri(request.getUploadUri());
        }
        if (request.getCallbackParam() != null) {
            requestMessage.getHeaders().put("x-oss-callback", OSSUtils.populateMapToBase64JsonString(request.getCallbackParam()));
        }
        if (request.getCallbackVars() != null) {
            requestMessage.getHeaders().put("x-oss-callback-var", OSSUtils.populateMapToBase64JsonString(request.getCallbackVars()));
        }
        OSSLog.logDebug(" populateRequestMetadata ");
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        OSSLog.logDebug(" canonicalizeRequestMessage ");
        this.canonicalizeRequestMessage(requestMessage, request);
        OSSLog.logDebug(" ExecutionContext ");
        ExecutionContext<PutObjectRequest, PutObjectResult> executionContext = new ExecutionContext<PutObjectRequest, PutObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

                @Override
                public void onSuccess(PutObjectRequest request, PutObjectResult result) {
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(PutObjectRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        if (request.getRetryCallback() != null) {
            executionContext.setRetryCallback(request.getRetryCallback());
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.PutObjectResponseParser parser = new ResponseParsers.PutObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        OSSLog.logDebug(" call OSSRequestTask ");
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CreateBucketResult> createBucket(CreateBucketRequest request, OSSCompletedCallback<CreateBucketRequest, CreateBucketResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        if (request.getBucketACL() != null) {
            requestMessage.getHeaders().put("x-oss-acl", request.getBucketACL().toString());
        }
        try {
            HashMap<String, String> configures = new HashMap<String, String>();
            if (request.getLocationConstraint() != null) {
                configures.put("LocationConstraint", request.getLocationConstraint());
            }
            configures.put("StorageClass", request.getBucketStorageClass().toString());
            requestMessage.createBucketRequestBodyMarshall(configures);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<CreateBucketRequest, CreateBucketResult> executionContext = new ExecutionContext<CreateBucketRequest, CreateBucketResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CreateBucketResponseParser parser = new ResponseParsers.CreateBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteBucketResult> deleteBucket(DeleteBucketRequest request, OSSCompletedCallback<DeleteBucketRequest, DeleteBucketResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteBucketRequest, DeleteBucketResult> executionContext = new ExecutionContext<DeleteBucketRequest, DeleteBucketResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteBucketResponseParser parser = new ResponseParsers.DeleteBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketInfoResult> getBucketInfo(GetBucketInfoRequest request, OSSCompletedCallback<GetBucketInfoRequest, GetBucketInfoResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("bucketInfo", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetBucketInfoRequest, GetBucketInfoResult> executionContext = new ExecutionContext<GetBucketInfoRequest, GetBucketInfoResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketInfoResponseParser parser = new ResponseParsers.GetBucketInfoResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketACLResult> getBucketACL(GetBucketACLRequest request, OSSCompletedCallback<GetBucketACLRequest, GetBucketACLResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("acl", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetBucketACLRequest, GetBucketACLResult> executionContext = new ExecutionContext<GetBucketACLRequest, GetBucketACLResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketACLResponseParser parser = new ResponseParsers.GetBucketACLResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<PutBucketRefererResult> putBucketReferer(PutBucketRefererRequest request, OSSCompletedCallback<PutBucketRefererRequest, PutBucketRefererResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("referer", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        try {
            requestMessage.putBucketRefererRequestBodyMarshall(request.getReferers(), request.isAllowEmpty());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<PutBucketRefererRequest, PutBucketRefererResult> executionContext = new ExecutionContext<PutBucketRefererRequest, PutBucketRefererResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.PutBucketRefererResponseParser parser = new ResponseParsers.PutBucketRefererResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketRefererResult> getBucketReferer(GetBucketRefererRequest request, OSSCompletedCallback<GetBucketRefererRequest, GetBucketRefererResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("referer", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetBucketRefererRequest, GetBucketRefererResult> executionContext = new ExecutionContext<GetBucketRefererRequest, GetBucketRefererResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketRefererResponseParser parser = new ResponseParsers.GetBucketRefererResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<PutBucketLoggingResult> putBucketLogging(PutBucketLoggingRequest request, OSSCompletedCallback<PutBucketLoggingRequest, PutBucketLoggingResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("logging", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        try {
            requestMessage.putBucketLoggingRequestBodyMarshall(request.getTargetBucketName(), request.getTargetPrefix());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<PutBucketLoggingRequest, PutBucketLoggingResult> executionContext = new ExecutionContext<PutBucketLoggingRequest, PutBucketLoggingResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.PutBucketLoggingResponseParser parser = new ResponseParsers.PutBucketLoggingResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketLoggingResult> getBucketLogging(GetBucketLoggingRequest request, OSSCompletedCallback<GetBucketLoggingRequest, GetBucketLoggingResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("logging", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetBucketLoggingRequest, GetBucketLoggingResult> executionContext = new ExecutionContext<GetBucketLoggingRequest, GetBucketLoggingResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketLoggingResponseParser parser = new ResponseParsers.GetBucketLoggingResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteBucketLoggingResult> deleteBucketLogging(DeleteBucketLoggingRequest request, OSSCompletedCallback<DeleteBucketLoggingRequest, DeleteBucketLoggingResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("logging", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteBucketLoggingRequest, DeleteBucketLoggingResult> executionContext = new ExecutionContext<DeleteBucketLoggingRequest, DeleteBucketLoggingResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteBucketLoggingResponseParser parser = new ResponseParsers.DeleteBucketLoggingResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<PutBucketLifecycleResult> putBucketLifecycle(PutBucketLifecycleRequest request, OSSCompletedCallback<PutBucketLifecycleRequest, PutBucketLifecycleResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("lifecycle", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        try {
            requestMessage.putBucketLifecycleRequestBodyMarshall(request.getLifecycleRules());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<PutBucketLifecycleRequest, PutBucketLifecycleResult> executionContext = new ExecutionContext<PutBucketLifecycleRequest, PutBucketLifecycleResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.PutBucketLifecycleResponseParser parser = new ResponseParsers.PutBucketLifecycleResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketLifecycleResult> getBucketLifecycle(GetBucketLifecycleRequest request, OSSCompletedCallback<GetBucketLifecycleRequest, GetBucketLifecycleResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("lifecycle", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetBucketLifecycleRequest, GetBucketLifecycleResult> executionContext = new ExecutionContext<GetBucketLifecycleRequest, GetBucketLifecycleResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketLifecycleResponseParser parser = new ResponseParsers.GetBucketLifecycleResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteBucketLifecycleResult> deleteBucketLifecycle(DeleteBucketLifecycleRequest request, OSSCompletedCallback<DeleteBucketLifecycleRequest, DeleteBucketLifecycleResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("lifecycle", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteBucketLifecycleRequest, DeleteBucketLifecycleResult> executionContext = new ExecutionContext<DeleteBucketLifecycleRequest, DeleteBucketLifecycleResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteBucketLifecycleResponseParser parser = new ResponseParsers.DeleteBucketLifecycleResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public AppendObjectResult syncAppendObject(AppendObjectRequest request) throws ClientException, ServiceException {
        boolean checkCRC;
        AppendObjectResult result = this.appendObject(request, null).getResult();
        boolean bl = checkCRC = request.getCRC64() == OSSRequest.CRC64Config.YES;
        if (request.getInitCRC64() != null && checkCRC) {
            result.setClientCRC(CRC64.combine(request.getInitCRC64(), result.getClientCRC(), result.getNextPosition() - request.getPosition()));
        }
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<AppendObjectResult> appendObject(AppendObjectRequest request, final OSSCompletedCallback<AppendObjectRequest, AppendObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getUploadData() != null) {
            requestMessage.setUploadData(request.getUploadData());
        }
        if (request.getUploadFilePath() != null) {
            requestMessage.setUploadFilePath(request.getUploadFilePath());
        }
        if (request.getUploadUri() != null) {
            requestMessage.setUploadUri(request.getUploadUri());
        }
        requestMessage.getParameters().put("append", "");
        requestMessage.getParameters().put("position", String.valueOf(request.getPosition()));
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<AppendObjectRequest, AppendObjectResult> executionContext = new ExecutionContext<AppendObjectRequest, AppendObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<AppendObjectRequest, AppendObjectResult>(){

                @Override
                public void onSuccess(AppendObjectRequest request, AppendObjectResult result) {
                    boolean checkCRC;
                    boolean bl = checkCRC = request.getCRC64() == OSSRequest.CRC64Config.YES;
                    if (request.getInitCRC64() != null && checkCRC) {
                        result.setClientCRC(CRC64.combine(request.getInitCRC64(), result.getClientCRC(), result.getNextPosition() - request.getPosition()));
                    }
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(AppendObjectRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.AppendObjectResponseParser parser = new ResponseParsers.AppendObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<HeadObjectResult> headObject(HeadObjectRequest request, OSSCompletedCallback<HeadObjectRequest, HeadObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.HEAD);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<HeadObjectRequest, HeadObjectResult> executionContext = new ExecutionContext<HeadObjectRequest, HeadObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.HeadObjectResponseParser parser = new ResponseParsers.HeadObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetObjectMetaResult> getObjectMeta(GetObjectMetaRequest request, OSSCompletedCallback<GetObjectMetaRequest, GetObjectMetaResult> completedCallback) {
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("objectMeta", "");
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.HEAD);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetObjectMetaRequest, GetObjectMetaResult> executionContext = new ExecutionContext<GetObjectMetaRequest, GetObjectMetaResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetObjectMetaResponseParser parser = new ResponseParsers.GetObjectMetaResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetObjectResult> getObject(GetObjectRequest request, OSSCompletedCallback<GetObjectRequest, GetObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getRange() != null) {
            requestMessage.getHeaders().put("Range", request.getRange().toString());
        }
        if (request.getxOssProcess() != null) {
            requestMessage.getParameters().put("x-oss-process", request.getxOssProcess());
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        if (request.getRequestHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getRequestHeaders().entrySet()) {
                requestMessage.getHeaders().put(entry.getKey(), entry.getValue());
            }
        }
        ExecutionContext<GetObjectRequest, GetObjectResult> executionContext = new ExecutionContext<GetObjectRequest, GetObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        executionContext.setProgressCallback(request.getProgressListener());
        ResponseParsers.GetObjectResponseParser parser = new ResponseParsers.GetObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetObjectACLResult> getObjectACL(GetObjectACLRequest request, OSSCompletedCallback<GetObjectACLRequest, GetObjectACLResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("acl", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setParameters(query);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetObjectACLRequest, GetObjectACLResult> executionContext = new ExecutionContext<GetObjectACLRequest, GetObjectACLResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetObjectACLResponseParser parser = new ResponseParsers.GetObjectACLResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CopyObjectResult> copyObject(CopyObjectRequest request, OSSCompletedCallback<CopyObjectRequest, CopyObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getDestinationBucketName());
        requestMessage.setObjectKey(request.getDestinationKey());
        OSSUtils.populateCopyObjectHeaders(request, requestMessage.getHeaders());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<CopyObjectRequest, CopyObjectResult> executionContext = new ExecutionContext<CopyObjectRequest, CopyObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CopyObjectResponseParser parser = new ResponseParsers.CopyObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteObjectResult> deleteObject(DeleteObjectRequest request, OSSCompletedCallback<DeleteObjectRequest, DeleteObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteObjectRequest, DeleteObjectResult> executionContext = new ExecutionContext<DeleteObjectRequest, DeleteObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteObjectResponseParser parser = new ResponseParsers.DeleteObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteMultipleObjectResult> deleteMultipleObject(DeleteMultipleObjectRequest request, OSSCompletedCallback<DeleteMultipleObjectRequest, DeleteMultipleObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("delete", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        try {
            byte[] bodyBytes = requestMessage.deleteMultipleObjectRequestBodyMarshall(request.getObjectKeys(), request.getQuiet());
            if (bodyBytes != null && bodyBytes.length > 0) {
                requestMessage.getHeaders().put("Content-MD5", BinaryUtil.calculateBase64Md5(bodyBytes));
                requestMessage.getHeaders().put("Content-Length", String.valueOf(bodyBytes.length));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteMultipleObjectRequest, DeleteMultipleObjectResult> executionContext = new ExecutionContext<DeleteMultipleObjectRequest, DeleteMultipleObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteMultipleObjectResponseParser parser = new ResponseParsers.DeleteMultipleObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListBucketsResult> listBuckets(ListBucketsRequest request, OSSCompletedCallback<ListBucketsRequest, ListBucketsResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setService(this.service);
        requestMessage.setEndpoint(this.endpoint);
        this.canonicalizeRequestMessage(requestMessage, request);
        OSSUtils.populateListBucketRequestParameters(request, requestMessage.getParameters());
        ExecutionContext<ListBucketsRequest, ListBucketsResult> executionContext = new ExecutionContext<ListBucketsRequest, ListBucketsResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListBucketResponseParser parser = new ResponseParsers.ListBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListObjectsResult> listObjects(ListObjectsRequest request, OSSCompletedCallback<ListObjectsRequest, ListObjectsResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        this.canonicalizeRequestMessage(requestMessage, request);
        OSSUtils.populateListObjectsRequestParameters(request, requestMessage.getParameters());
        ExecutionContext<ListObjectsRequest, ListObjectsResult> executionContext = new ExecutionContext<ListObjectsRequest, ListObjectsResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListObjectsResponseParser parser = new ResponseParsers.ListObjectsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<InitiateMultipartUploadResult> initMultipartUpload(InitiateMultipartUploadRequest request, OSSCompletedCallback<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploads", "");
        if (request.isSequential) {
            requestMessage.getParameters().put("sequential", "");
        }
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> executionContext = new ExecutionContext<InitiateMultipartUploadRequest, InitiateMultipartUploadResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.InitMultipartResponseParser parser = new ResponseParsers.InitMultipartResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public UploadPartResult syncUploadPart(UploadPartRequest request) throws ClientException, ServiceException {
        UploadPartResult result = this.uploadPart(request, null).getResult();
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<UploadPartResult> uploadPart(UploadPartRequest request, final OSSCompletedCallback<UploadPartRequest, UploadPartResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        requestMessage.getParameters().put("partNumber", String.valueOf(request.getPartNumber()));
        requestMessage.setUploadData(request.getPartContent());
        if (request.getMd5Digest() != null) {
            requestMessage.getHeaders().put("Content-MD5", request.getMd5Digest());
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<UploadPartRequest, UploadPartResult> executionContext = new ExecutionContext<UploadPartRequest, UploadPartResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<UploadPartRequest, UploadPartResult>(){

                @Override
                public void onSuccess(UploadPartRequest request, UploadPartResult result) {
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(UploadPartRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.UploadPartResponseParser parser = new ResponseParsers.UploadPartResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public CompleteMultipartUploadResult syncCompleteMultipartUpload(CompleteMultipartUploadRequest request) throws ClientException, ServiceException {
        CompleteMultipartUploadResult result = this.completeMultipartUpload(request, null).getResult();
        if (result.getServerCRC() != null) {
            long crc64 = this.calcObjectCRCFromParts(request.getPartETags());
            result.setClientCRC(crc64);
        }
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<CompleteMultipartUploadResult> completeMultipartUpload(CompleteMultipartUploadRequest request, final OSSCompletedCallback<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setStringBody(OSSUtils.buildXMLFromPartEtagList(request.getPartETags()));
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        if (request.getCallbackParam() != null) {
            requestMessage.getHeaders().put("x-oss-callback", OSSUtils.populateMapToBase64JsonString(request.getCallbackParam()));
        }
        if (request.getCallbackVars() != null) {
            requestMessage.getHeaders().put("x-oss-callback-var", OSSUtils.populateMapToBase64JsonString(request.getCallbackVars()));
        }
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> executionContext = new ExecutionContext<CompleteMultipartUploadRequest, CompleteMultipartUploadResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<CompleteMultipartUploadRequest, CompleteMultipartUploadResult>(){

                @Override
                public void onSuccess(CompleteMultipartUploadRequest request, CompleteMultipartUploadResult result) {
                    if (result.getServerCRC() != null) {
                        long crc64 = InternalRequestOperation.this.calcObjectCRCFromParts(request.getPartETags());
                        result.setClientCRC(crc64);
                    }
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(CompleteMultipartUploadRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        ResponseParsers.CompleteMultipartUploadResponseParser parser = new ResponseParsers.CompleteMultipartUploadResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<AbortMultipartUploadResult> abortMultipartUpload(AbortMultipartUploadRequest request, OSSCompletedCallback<AbortMultipartUploadRequest, AbortMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<AbortMultipartUploadRequest, AbortMultipartUploadResult> executionContext = new ExecutionContext<AbortMultipartUploadRequest, AbortMultipartUploadResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.AbortMultipartUploadResponseParser parser = new ResponseParsers.AbortMultipartUploadResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListPartsResult> listParts(ListPartsRequest request, OSSCompletedCallback<ListPartsRequest, ListPartsResult> completedCallback) {
        Integer partNumberMarker;
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        Integer maxParts = request.getMaxParts();
        if (maxParts != null) {
            if (!OSSUtils.checkParamRange(maxParts.intValue(), 0L, true, 1000L, true)) {
                throw new IllegalArgumentException("MaxPartsOutOfRange: 1000");
            }
            requestMessage.getParameters().put("max-parts", maxParts.toString());
        }
        if ((partNumberMarker = request.getPartNumberMarker()) != null) {
            if (!OSSUtils.checkParamRange(partNumberMarker.intValue(), 0L, false, 10000L, true)) {
                throw new IllegalArgumentException("PartNumberMarkerOutOfRange: 10000");
            }
            requestMessage.getParameters().put("part-number-marker", partNumberMarker.toString());
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<ListPartsRequest, ListPartsResult> executionContext = new ExecutionContext<ListPartsRequest, ListPartsResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListPartsResponseParser parser = new ResponseParsers.ListPartsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListMultipartUploadsResult> listMultipartUploads(ListMultipartUploadsRequest request, OSSCompletedCallback<ListMultipartUploadsRequest, ListMultipartUploadsResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.getParameters().put("uploads", "");
        OSSUtils.populateListMultipartUploadsRequestParameters(request, requestMessage.getParameters());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<ListMultipartUploadsRequest, ListMultipartUploadsResult> executionContext = new ExecutionContext<ListMultipartUploadsRequest, ListMultipartUploadsResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListMultipartUploadsResponseParser parser = new ResponseParsers.ListMultipartUploadsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    private boolean checkIfHttpDnsAvailable(boolean httpDnsEnable) {
        if (httpDnsEnable) {
            if (this.applicationContext == null) {
                return false;
            }
            boolean IS_ICS_OR_LATER = Build.VERSION.SDK_INT >= 14;
            String proxyHost = IS_ICS_OR_LATER ? System.getProperty("http.proxyHost") : Proxy.getHost((Context)this.applicationContext);
            String confProxyHost = this.conf.getProxyHost();
            if (!TextUtils.isEmpty((CharSequence)confProxyHost)) {
                proxyHost = confProxyHost;
            }
            return TextUtils.isEmpty((CharSequence)proxyHost);
        }
        return false;
    }

    public OkHttpClient getInnerClient() {
        return this.innerClient;
    }

    private void canonicalizeRequestMessage(RequestMessage message, OSSRequest request) {
        Map header = message.getHeaders();
        if (header.get("Date") == null) {
            header.put("Date", DateUtil.currentFixedSkewedTimeInRFC822Format());
        }
        if ((message.getMethod() == HttpMethod.POST || message.getMethod() == HttpMethod.PUT) && OSSUtils.isEmptyString((String)header.get("Content-Type"))) {
            String determineContentType = OSSUtils.determineContentType(null, message.getUploadFilePath(), message.getObjectKey());
            header.put("Content-Type", determineContentType);
        }
        message.setHttpDnsEnable(this.checkIfHttpDnsAvailable(this.conf.isHttpDnsEnable()));
        message.setCredentialProvider(this.credentialProvider);
        message.setPathStyleAccessEnable(this.conf.isPathStyleAccessEnable());
        message.setCustomPathPrefixEnable(this.conf.isCustomPathPrefixEnable());
        message.setIpWithHeader(this.conf.getIpWithHeader());
        message.getHeaders().put("User-Agent", VersionInfoUtils.getUserAgent(this.conf.getCustomUserMark()));
        if (message.getHeaders().containsKey("Range") || message.getParameters().containsKey("x-oss-process")) {
            message.setCheckCRC64(false);
        }
        message.setIsInCustomCnameExcludeList(OSSUtils.isInCustomCnameExcludeList(this.endpoint.getHost(), this.conf.getCustomCnameExcludeList()));
        boolean checkCRC64 = request.getCRC64() != OSSRequest.CRC64Config.NULL ? request.getCRC64() == OSSRequest.CRC64Config.YES : this.conf.isCheckCRC64();
        message.setCheckCRC64(checkCRC64);
        request.setCRC64(checkCRC64 ? OSSRequest.CRC64Config.YES : OSSRequest.CRC64Config.NO);
    }

    public void setCredentialProvider(OSSCredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    private <Request extends OSSRequest, Result extends OSSResult> void checkCRC64(Request request, Result result) throws ClientException {
        if (request.getCRC64() == OSSRequest.CRC64Config.YES) {
            try {
                OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
            }
            catch (InconsistentException e) {
                throw new ClientException(e.getMessage(), e);
            }
        }
    }

    private <Request extends OSSRequest, Result extends OSSResult> void checkCRC64(Request request, Result result, OSSCompletedCallback<Request, Result> completedCallback) {
        block3: {
            try {
                this.checkCRC64(request, result);
                if (completedCallback != null) {
                    completedCallback.onSuccess(request, result);
                }
            }
            catch (ClientException e) {
                if (completedCallback == null) break block3;
                completedCallback.onFailure(request, e, null);
            }
        }
    }

    private long calcObjectCRCFromParts(List<PartETag> partETags) {
        long crc = 0L;
        for (PartETag partETag : partETags) {
            if (partETag.getCRC64() == 0L || partETag.getPartSize() <= 0L) {
                return 0L;
            }
            crc = CRC64.combine(crc, partETag.getCRC64(), partETag.getPartSize());
        }
        return crc;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public ClientConfiguration getConf() {
        return this.conf;
    }

    public OSSAsyncTask<TriggerCallbackResult> triggerCallback(TriggerCallbackRequest request, OSSCompletedCallback<TriggerCallbackRequest, TriggerCallbackResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("x-oss-process", "");
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        String bodyString = OSSUtils.buildTriggerCallbackBody(request.getCallbackParam(), request.getCallbackVars());
        requestMessage.setStringBody(bodyString);
        String md5String = BinaryUtil.calculateBase64Md5(bodyString.getBytes());
        requestMessage.getHeaders().put("Content-MD5", md5String);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<TriggerCallbackRequest, TriggerCallbackResult> executionContext = new ExecutionContext<TriggerCallbackRequest, TriggerCallbackResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.TriggerCallbackResponseParser parser = new ResponseParsers.TriggerCallbackResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public TriggerCallbackResult asyncTriggerCallback(TriggerCallbackRequest request) throws ClientException, ServiceException {
        return this.triggerCallback(request, null).getResult();
    }

    public OSSAsyncTask<ImagePersistResult> imageActionPersist(ImagePersistRequest request, OSSCompletedCallback<ImagePersistRequest, ImagePersistResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("x-oss-process", "");
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.mFromBucket);
        requestMessage.setObjectKey(request.mFromObjectkey);
        requestMessage.setParameters(query);
        String bodyString = OSSUtils.buildImagePersistentBody(request.mToBucketName, request.mToObjectKey, request.mAction);
        requestMessage.setStringBody(bodyString);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<ImagePersistRequest, ImagePersistResult> executionContext = new ExecutionContext<ImagePersistRequest, ImagePersistResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ImagePersistResponseParser parser = new ResponseParsers.ImagePersistResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public PutSymlinkResult syncPutSymlink(PutSymlinkRequest request) throws ClientException, ServiceException {
        return this.putSymlink(request, null).getResult();
    }

    public OSSAsyncTask<PutSymlinkResult> putSymlink(PutSymlinkRequest request, OSSCompletedCallback<PutSymlinkRequest, PutSymlinkResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("symlink", "");
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        if (!OSSUtils.isEmptyString(request.getTargetObjectName())) {
            String targetObjectName = HttpUtil.urlEncode(request.getTargetObjectName(), "utf-8");
            requestMessage.getHeaders().put("x-oss-symlink-target", targetObjectName);
        }
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<PutSymlinkRequest, PutSymlinkResult> executionContext = new ExecutionContext<PutSymlinkRequest, PutSymlinkResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.PutSymlinkResponseParser parser = new ResponseParsers.PutSymlinkResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public GetSymlinkResult syncGetSymlink(GetSymlinkRequest request) throws ClientException, ServiceException {
        return this.getSymlink(request, null).getResult();
    }

    public OSSAsyncTask<GetSymlinkResult> getSymlink(GetSymlinkRequest request, OSSCompletedCallback<GetSymlinkRequest, GetSymlinkResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("symlink", "");
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetSymlinkRequest, GetSymlinkResult> executionContext = new ExecutionContext<GetSymlinkRequest, GetSymlinkResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetSymlinkResponseParser parser = new ResponseParsers.GetSymlinkResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public RestoreObjectResult syncRestoreObject(RestoreObjectRequest request) throws ClientException, ServiceException {
        return this.restoreObject(request, null).getResult();
    }

    public OSSAsyncTask<RestoreObjectResult> restoreObject(RestoreObjectRequest request, OSSCompletedCallback<RestoreObjectRequest, RestoreObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("restore", "");
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<RestoreObjectRequest, RestoreObjectResult> executionContext = new ExecutionContext<RestoreObjectRequest, RestoreObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.RestoreObjectResponseParser parser = new ResponseParsers.RestoreObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public PutObjectTaggingResult syncPutObjectTagging(PutObjectTaggingRequest request) throws ClientException, ServiceException {
        return this.putObjectTagging(request, null).getResult();
    }

    public OSSAsyncTask<PutObjectTaggingResult> putObjectTagging(PutObjectTaggingRequest request, OSSCompletedCallback<PutObjectTaggingRequest, PutObjectTaggingResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("tagging", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        try {
            byte[] bodyBytes = requestMessage.putObjectTaggingRequestBodyMarshall(request.getTags());
            if (bodyBytes != null && bodyBytes.length > 0) {
                requestMessage.getHeaders().put("Content-MD5", BinaryUtil.calculateBase64Md5(bodyBytes));
                requestMessage.getHeaders().put("Content-Length", String.valueOf(bodyBytes.length));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            if (completedCallback != null) {
                completedCallback.onFailure(request, new ClientException(e.getMessage(), e), null);
            }
            return OSSAsyncTask.wrapRequestTask(this.executorService.submit(new Callable(){

                public Object call() throws Exception {
                    throw e;
                }
            }), null);
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<PutObjectTaggingRequest, PutObjectTaggingResult> executionContext = new ExecutionContext<PutObjectTaggingRequest, PutObjectTaggingResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.PutObjectTaggingResponseParser parser = new ResponseParsers.PutObjectTaggingResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public GetObjectTaggingResult syncGetObjectTagging(GetObjectTaggingRequest request) throws ClientException, ServiceException {
        return this.getObjectTagging(request, null).getResult();
    }

    public OSSAsyncTask<GetObjectTaggingResult> getObjectTagging(GetObjectTaggingRequest request, OSSCompletedCallback<GetObjectTaggingRequest, GetObjectTaggingResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("tagging", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetObjectTaggingRequest, GetObjectTaggingResult> executionContext = new ExecutionContext<GetObjectTaggingRequest, GetObjectTaggingResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetObjectTaggingResponseParser parser = new ResponseParsers.GetObjectTaggingResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public DeleteObjectTaggingResult syncDeleteObjectTagging(DeleteObjectTaggingRequest request) throws ClientException, ServiceException {
        return this.deleteObjectTagging(request, null).getResult();
    }

    public OSSAsyncTask<DeleteObjectTaggingResult> deleteObjectTagging(DeleteObjectTaggingRequest request, OSSCompletedCallback<DeleteObjectTaggingRequest, DeleteObjectTaggingResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("tagging", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteObjectTaggingRequest, DeleteObjectTaggingResult> executionContext = new ExecutionContext<DeleteObjectTaggingRequest, DeleteObjectTaggingResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteObjectTaggingResponseParser parser = new ResponseParsers.DeleteObjectTaggingResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }
}

