/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        String result;
        if (in == null) {
            return "";
        }
        Reader reader = null;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[4096];
        try {
            int n;
            reader = new BufferedReader(new InputStreamReader(in, charset));
            while ((n = reader.read(buffer)) > 0) {
                ((Writer)writer).write(buffer, 0, n);
            }
            result = ((Object)writer).toString();
        }
        finally {
            IOUtils.safeClose(in);
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
        return result;
    }

    public static byte[] readStreamAsBytesArray(InputStream in) throws IOException {
        int len;
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) > -1) {
            output.write(buffer, 0, len);
        }
        output.flush();
        IOUtils.safeClose(output);
        return output.toByteArray();
    }

    public static byte[] readStreamAsBytesArray(InputStream in, int readLength) throws IOException {
        int len;
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        for (long readed = 0L; readed < (long)readLength && (len = in.read(buffer, 0, Math.min(2048, (int)((long)readLength - readed)))) > -1; readed += (long)len) {
            output.write(buffer, 0, len);
        }
        output.flush();
        IOUtils.safeClose(output);
        return output.toByteArray();
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

