/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.network;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.OSSRetryHandler;
import com.alibaba.sdk.android.oss.internal.OSSRetryType;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParser;
import com.alibaba.sdk.android.oss.internal.ResponseParsers;
import com.alibaba.sdk.android.oss.model.GetObjectRequest;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.alibaba.sdk.android.oss.network.NetworkProgressHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OSSRequestTask<T extends OSSResult>
implements Callable<T> {
    private ResponseParser<T> responseParser;
    private RequestMessage message;
    private ExecutionContext context;
    private OkHttpClient client;
    private OSSRetryHandler retryHandler;
    private int currentRetryCount = 0;

    public OSSRequestTask(RequestMessage message, ResponseParser parser, ExecutionContext context, int maxRetry) {
        this.responseParser = parser;
        this.message = message;
        this.context = context;
        this.client = context.getClient();
        this.retryHandler = new OSSRetryHandler(maxRetry);
    }

    @Override
    public T call() throws Exception {
        Request request = null;
        Response response = null;
        Exception exception = null;
        Call call = null;
        try {
            OSSLog.logDebug("[call] - ");
            Object ossRequest = this.context.getRequest();
            OSSUtils.ensureRequestValid(ossRequest, this.message);
            OSSUtils.signRequest(this.message);
            if (this.context.getCancellationHandler().isCancelled()) {
                throw new InterruptedIOException("This task is cancelled!");
            }
            Request.Builder requestBuilder = new Request.Builder();
            String url = this.message.buildCanonicalURL();
            requestBuilder = requestBuilder.url(url);
            for (String key : this.message.getHeaders().keySet()) {
                requestBuilder = requestBuilder.addHeader(key, this.message.getHeaders().get(key));
            }
            String contentType = this.message.getHeaders().get("Content-Type");
            switch (this.message.getMethod()) {
                case POST: 
                case PUT: {
                    OSSUtils.assertTrue(contentType != null, "Content type can't be null when upload!");
                    InputStream inputStream = null;
                    long length = 0L;
                    if (this.message.getUploadData() != null) {
                        inputStream = new ByteArrayInputStream(this.message.getUploadData());
                        length = this.message.getUploadData().length;
                    } else if (this.message.getUploadFilePath() != null) {
                        File file = new File(this.message.getUploadFilePath());
                        inputStream = new FileInputStream(file);
                        length = file.length();
                    } else if (this.message.getUploadInputStream() != null) {
                        inputStream = this.message.getUploadInputStream();
                        length = this.message.getReadStreamLength();
                    }
                    if (inputStream != null) {
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), (RequestBody)NetworkProgressHelper.addProgressRequestBody(inputStream, length, contentType, this.context));
                        break;
                    }
                    requestBuilder = requestBuilder.method(this.message.getMethod().toString(), RequestBody.create(null, (byte[])new byte[0]));
                    break;
                }
                case GET: {
                    requestBuilder = requestBuilder.get();
                    break;
                }
                case HEAD: {
                    requestBuilder = requestBuilder.head();
                    break;
                }
                case DELETE: {
                    requestBuilder = requestBuilder.delete();
                    break;
                }
            }
            request = requestBuilder.build();
            if (ossRequest instanceof GetObjectRequest) {
                this.client = NetworkProgressHelper.addProgressResponseListener(this.client, this.context);
                OSSLog.logDebug("getObject");
            }
            call = this.client.newCall(request);
            this.context.getCancellationHandler().setCall(call);
            response = call.execute();
            Map headerMap = response.headers().toMultimap();
            StringBuilder printRsp = new StringBuilder();
            printRsp.append("response:---------------------\n");
            printRsp.append("response code: " + response.code() + " for url: " + request.url() + "\n");
            printRsp.append("response msg: " + response.message() + "\n");
            for (String key : headerMap.keySet()) {
                printRsp.append("responseHeader [" + key + "]: ").append((String)((List)headerMap.get(key)).get(0) + "\n");
            }
            OSSLog.logDebug(printRsp.toString());
        }
        catch (Exception e) {
            OSSLog.logError("Encounter local execpiton: " + e.toString());
            if (OSSLog.isEnableLog()) {
                e.printStackTrace();
            }
            exception = new ClientException(e.getMessage(), e);
        }
        if (response != null) {
            String responseDateString = response.header("Date");
            try {
                long serverTime = DateUtil.parseRfc822Date(responseDateString).getTime();
                DateUtil.setCurrentServerTime(serverTime);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (exception == null && (response.code() == 203 || response.code() >= 300)) {
            try {
                exception = ResponseParsers.parseResponseErrorXML(response, request.method().equals("HEAD"));
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        } else if (exception == null) {
            try {
                T result = this.responseParser.parse(response);
                if (this.context.getCompletedCallback() != null) {
                    try {
                        this.context.getCompletedCallback().onSuccess(this.context.getRequest(), result);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                return result;
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        }
        if (call != null && call.isCanceled() || this.context.getCancellationHandler().isCancelled()) {
            exception = new ClientException("Task is cancelled!", exception.getCause(), true);
        }
        OSSRetryType retryType = this.retryHandler.shouldRetry(exception, this.currentRetryCount);
        OSSLog.logError("[run] - retry, retry type: " + (Object)((Object)retryType));
        if (retryType == OSSRetryType.OSSRetryTypeShouldRetry) {
            ++this.currentRetryCount;
            return (T)this.call();
        }
        if (retryType == OSSRetryType.OSSRetryTypeShouldFixedTimeSkewedAndRetry) {
            if (response != null) {
                this.message.getHeaders().put("Date", response.header("Date"));
            }
            ++this.currentRetryCount;
            return (T)this.call();
        }
        if (exception instanceof ClientException) {
            if (this.context.getCompletedCallback() != null) {
                this.context.getCompletedCallback().onFailure(this.context.getRequest(), (ClientException)exception, null);
            }
        } else if (this.context.getCompletedCallback() != null) {
            this.context.getCompletedCallback().onFailure(this.context.getRequest(), null, (ServiceException)exception);
        }
        throw exception;
    }
}

