/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.internal.AbstractResponseParser;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.AppendObjectResult;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.CopyObjectResult;
import com.alibaba.sdk.android.oss.model.CreateBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectResult;
import com.alibaba.sdk.android.oss.model.GetBucketACLResult;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.HeadObjectResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListObjectsResult;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.OSSObjectSummary;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import com.alibaba.sdk.android.oss.model.PartSummary;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import okhttp3.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ResponseParsers {
    public static final DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();

    private static CopyObjectResult parseCopyObjectResponseXML(InputStream in, CopyObjectResult result) throws ParseException, ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document dom = builder.parse(in);
        Element element = dom.getDocumentElement();
        OSSLog.logDebug("[item] - " + element.getNodeName());
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equals("LastModified")) {
                result.setLastModified(DateUtil.parseIso8601Date(ResponseParsers.checkChildNotNullAndGetValue(item)));
                continue;
            }
            if (!name.equals("ETag")) continue;
            result.setEtag(ResponseParsers.checkChildNotNullAndGetValue(item));
        }
        return result;
    }

    private static ListPartsResult parseListPartsResponseXML(InputStream in, ListPartsResult result) throws ParserConfigurationException, IOException, SAXException, ParseException {
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document dom = builder.parse(in);
        Element element = dom.getDocumentElement();
        OSSLog.logDebug("[parseObjectListResponse] - " + element.getNodeName());
        ArrayList<PartSummary> partEtagList = new ArrayList<PartSummary>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equals("Bucket")) {
                result.setBucketName(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("Key")) {
                result.setKey(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("UploadId")) {
                result.setUploadId(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("PartNumberMarker")) {
                String partNumberMarker = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (partNumberMarker == null) continue;
                result.setPartNumberMarker(Integer.valueOf(partNumberMarker));
                continue;
            }
            if (name.equals("NextPartNumberMarker")) {
                String nextPartNumberMarker = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (nextPartNumberMarker == null) continue;
                result.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarker));
                continue;
            }
            if (name.equals("MaxParts")) {
                String maxParts = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (maxParts == null) continue;
                result.setMaxParts(Integer.valueOf(maxParts));
                continue;
            }
            if (name.equals("IsTruncated")) {
                String isTruncated = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (isTruncated == null) continue;
                result.setTruncated(Boolean.valueOf(isTruncated));
                continue;
            }
            if (name.equals("StorageClass")) {
                String storageClass = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (storageClass == null) continue;
                result.setStorageClass(storageClass);
                continue;
            }
            if (!name.equals("Part")) continue;
            NodeList partNodeList = item.getChildNodes();
            PartSummary partSummary = new PartSummary();
            for (int k = 0; k < partNodeList.getLength(); ++k) {
                String size;
                Node partItem = partNodeList.item(k);
                String partItemName = partItem.getNodeName();
                if (partItemName == null) continue;
                if (partItemName.equals("PartNumber")) {
                    String partNumber = ResponseParsers.checkChildNotNullAndGetValue(partItem);
                    if (partNumber == null) continue;
                    partSummary.setPartNumber(Integer.valueOf(partNumber));
                    continue;
                }
                if (partItemName.equals("LastModified")) {
                    partSummary.setLastModified(DateUtil.parseIso8601Date(ResponseParsers.checkChildNotNullAndGetValue(partItem)));
                    continue;
                }
                if (partItemName.equals("ETag")) {
                    partSummary.setETag(ResponseParsers.checkChildNotNullAndGetValue(partItem));
                    continue;
                }
                if (!partItemName.equals("Size") || (size = ResponseParsers.checkChildNotNullAndGetValue(partItem)) == null) continue;
                partSummary.setSize(Integer.valueOf(size).intValue());
            }
            partEtagList.add(partSummary);
        }
        result.setParts(partEtagList);
        return result;
    }

    private static CompleteMultipartUploadResult parseCompleteMultipartUploadResponseXML(InputStream in, CompleteMultipartUploadResult result) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document dom = builder.parse(in);
        Element element = dom.getDocumentElement();
        OSSLog.logDebug("[item] - " + element.getNodeName());
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equalsIgnoreCase("Location")) {
                result.setLocation(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equalsIgnoreCase("Bucket")) {
                result.setBucketName(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equalsIgnoreCase("Key")) {
                result.setObjectKey(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (!name.equalsIgnoreCase("ETag")) continue;
            result.setETag(ResponseParsers.checkChildNotNullAndGetValue(item));
        }
        return result;
    }

    private static InitiateMultipartUploadResult parseInitMultipartResponseXML(InputStream in, InitiateMultipartUploadResult result) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document dom = builder.parse(in);
        Element element = dom.getDocumentElement();
        OSSLog.logDebug("[item] - " + element.getNodeName());
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equalsIgnoreCase("UploadId")) {
                result.setUploadId(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equalsIgnoreCase("Bucket")) {
                result.setBucketName(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (!name.equalsIgnoreCase("Key")) continue;
            result.setObjectKey(ResponseParsers.checkChildNotNullAndGetValue(item));
        }
        return result;
    }

    private static OSSObjectSummary parseObjectSummaryXML(NodeList list) throws ParseException {
        OSSObjectSummary object = new OSSObjectSummary();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equals("Key")) {
                object.setKey(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("LastModified")) {
                object.setLastModified(DateUtil.parseIso8601Date(ResponseParsers.checkChildNotNullAndGetValue(item)));
                continue;
            }
            if (name.equals("Size")) {
                String size = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (size == null) continue;
                object.setSize(Integer.valueOf(size).intValue());
                continue;
            }
            if (name.equals("ETag")) {
                object.setETag(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("Type")) {
                object.setType(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (!name.equals("StorageClass")) continue;
            object.setStorageClass(ResponseParsers.checkChildNotNullAndGetValue(item));
        }
        return object;
    }

    private static String parseCommonPrefixXML(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null || !name.equals("Prefix")) continue;
            return ResponseParsers.checkChildNotNullAndGetValue(item);
        }
        return "";
    }

    private static GetBucketACLResult parseGetBucketACLResponse(InputStream in, GetBucketACLResult result) throws ParserConfigurationException, IOException, SAXException, ParseException {
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document dom = builder.parse(in);
        Element element = dom.getDocumentElement();
        OSSLog.logDebug("[parseGetBucketACLResponse - " + element.getNodeName());
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equals("Owner")) {
                NodeList ownerList = item.getChildNodes();
                for (int j = 0; j < ownerList.getLength(); ++j) {
                    Node ownerItem = ownerList.item(j);
                    String ownerName = ownerItem.getNodeName();
                    if (ownerName == null) continue;
                    if (ownerName.equals("ID")) {
                        result.setBucketOwnerID(ResponseParsers.checkChildNotNullAndGetValue(ownerItem));
                        continue;
                    }
                    if (!ownerName.equals("DisplayName")) continue;
                    result.setBucketOwner(ResponseParsers.checkChildNotNullAndGetValue(ownerItem));
                }
                continue;
            }
            if (!name.equals("AccessControlList")) continue;
            NodeList aclList = item.getChildNodes();
            for (int k = 0; k < aclList.getLength(); ++k) {
                Node aclItem = aclList.item(k);
                String aclName = aclItem.getNodeName();
                if (aclName == null || !aclName.equals("Grant")) continue;
                result.setBucketACL(ResponseParsers.checkChildNotNullAndGetValue(aclItem));
            }
        }
        return result;
    }

    private static ListObjectsResult parseObjectListResponse(InputStream in, ListObjectsResult result) throws ParserConfigurationException, IOException, SAXException, ParseException {
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document dom = builder.parse(in);
        Element element = dom.getDocumentElement();
        OSSLog.logDebug("[parseObjectListResponse] - " + element.getNodeName());
        result.clearCommonPrefixes();
        result.clearObjectSummaries();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String prefix;
            Node item = list.item(i);
            String name = item.getNodeName();
            if (name == null) continue;
            if (name.equals("Name")) {
                result.setBucketName(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("Prefix")) {
                result.setPrefix(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("Marker")) {
                result.setMarker(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("Delimiter")) {
                result.setDelimiter(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("EncodingType")) {
                result.setEncodingType(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("MaxKeys")) {
                String maxKeys = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (maxKeys == null) continue;
                result.setMaxKeys(Integer.valueOf(maxKeys));
                continue;
            }
            if (name.equals("NextMarker")) {
                result.setNextMarker(ResponseParsers.checkChildNotNullAndGetValue(item));
                continue;
            }
            if (name.equals("IsTruncated")) {
                String isTruncated = ResponseParsers.checkChildNotNullAndGetValue(item);
                if (isTruncated == null) continue;
                result.setTruncated(Boolean.valueOf(isTruncated));
                continue;
            }
            if (name.equals("Contents")) {
                if (item.getChildNodes() == null) continue;
                result.addObjectSummary(ResponseParsers.parseObjectSummaryXML(item.getChildNodes()));
                continue;
            }
            if (!name.equals("CommonPrefixes") || item.getChildNodes() == null || (prefix = ResponseParsers.parseCommonPrefixXML(item.getChildNodes())) == null) continue;
            result.addCommonPrefix(prefix);
        }
        return result;
    }

    public static String trimQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws IOException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    objectMetadata.addUserMetadata(key, headers.get(key));
                    continue;
                }
                if (key.equals("Last-Modified") || key.equals("Date")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMetadata.setHeader(key, ResponseParsers.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static ServiceException parseResponseErrorXML(Response response, boolean isHeadRequest) throws IOException {
        int statusCode = response.code();
        String requestId = response.header("x-oss-request-id");
        String code = null;
        String message = null;
        String hostId = null;
        String errorMessage = null;
        if (!isHeadRequest) {
            try {
                errorMessage = response.body().string();
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(errorMessage));
                Document dom = builder.parse(is);
                Element element = dom.getDocumentElement();
                NodeList list = element.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Node item = list.item(i);
                    String name = item.getNodeName();
                    if (name == null) continue;
                    if (name.equals("Code")) {
                        code = ResponseParsers.checkChildNotNullAndGetValue(item);
                    }
                    if (name.equals("Message")) {
                        message = ResponseParsers.checkChildNotNullAndGetValue(item);
                    }
                    if (name.equals("RequestId")) {
                        requestId = ResponseParsers.checkChildNotNullAndGetValue(item);
                    }
                    if (!name.equals("HostId")) continue;
                    hostId = ResponseParsers.checkChildNotNullAndGetValue(item);
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return new ServiceException(statusCode, message, code, requestId, hostId, errorMessage);
    }

    public static String checkChildNotNullAndGetValue(Node item) {
        if (item.getFirstChild() != null) {
            return item.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static final class ListPartsResponseParser
    extends AbstractResponseParser<ListPartsResult> {
        @Override
        public ListPartsResult parseData(Response response, ListPartsResult result) throws Exception {
            result = ResponseParsers.parseListPartsResponseXML(response.body().byteStream(), result);
            return result;
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    extends AbstractResponseParser<CompleteMultipartUploadResult> {
        @Override
        public CompleteMultipartUploadResult parseData(Response response, CompleteMultipartUploadResult result) throws Exception {
            if (response.header("Content-Type").equals("application/xml")) {
                result = ResponseParsers.parseCompleteMultipartUploadResponseXML(response.body().byteStream(), result);
            } else if (response.body() != null) {
                result.setServerCallbackReturnBody(response.body().string());
            }
            return result;
        }
    }

    public static final class AbortMultipartUploadResponseParser
    extends AbstractResponseParser<AbortMultipartUploadResult> {
        @Override
        public AbortMultipartUploadResult parseData(Response response, AbortMultipartUploadResult result) throws IOException {
            return result;
        }
    }

    public static final class UploadPartResponseParser
    extends AbstractResponseParser<UploadPartResult> {
        @Override
        public UploadPartResult parseData(Response response, UploadPartResult result) throws IOException {
            result.setETag(ResponseParsers.trimQuotes(response.header("ETag")));
            return result;
        }
    }

    public static final class InitMultipartResponseParser
    extends AbstractResponseParser<InitiateMultipartUploadResult> {
        @Override
        public InitiateMultipartUploadResult parseData(Response response, InitiateMultipartUploadResult result) throws Exception {
            return ResponseParsers.parseInitMultipartResponseXML(response.body().byteStream(), result);
        }
    }

    public static final class ListObjectsResponseParser
    extends AbstractResponseParser<ListObjectsResult> {
        @Override
        public ListObjectsResult parseData(Response response, ListObjectsResult result) throws Exception {
            result = ResponseParsers.parseObjectListResponse(response.body().byteStream(), result);
            return result;
        }
    }

    public static final class DeleteObjectResponseParser
    extends AbstractResponseParser<DeleteObjectResult> {
        @Override
        public DeleteObjectResult parseData(Response response, DeleteObjectResult result) throws IOException {
            return result;
        }
    }

    public static final class GetBucketACLResponseParser
    extends AbstractResponseParser<GetBucketACLResult> {
        @Override
        public GetBucketACLResult parseData(Response response, GetBucketACLResult result) throws Exception {
            result = ResponseParsers.parseGetBucketACLResponse(response.body().byteStream(), result);
            return result;
        }
    }

    public static final class DeleteBucketResponseParser
    extends AbstractResponseParser<DeleteBucketResult> {
        @Override
        public DeleteBucketResult parseData(Response response, DeleteBucketResult result) throws IOException {
            return result;
        }
    }

    public static final class CreateBucketResponseParser
    extends AbstractResponseParser<CreateBucketResult> {
        @Override
        public CreateBucketResult parseData(Response response, CreateBucketResult result) throws IOException {
            if (result.getResponseHeader().containsKey("Location")) {
                result.bucketLocation = result.getResponseHeader().get("Location");
            }
            return result;
        }
    }

    public static final class CopyObjectResponseParser
    extends AbstractResponseParser<CopyObjectResult> {
        @Override
        public CopyObjectResult parseData(Response response, CopyObjectResult result) throws Exception {
            result = ResponseParsers.parseCopyObjectResponseXML(response.body().byteStream(), result);
            return result;
        }
    }

    public static final class GetObjectResponseParser
    extends AbstractResponseParser<GetObjectResult> {
        @Override
        public GetObjectResult parseData(Response response, GetObjectResult result) throws IOException {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            result.setContentLength(response.body().contentLength());
            result.setObjectContent(response.body().byteStream());
            return result;
        }

        @Override
        public boolean needCloseResponse() {
            return false;
        }
    }

    public static final class HeadObjectResponseParser
    extends AbstractResponseParser<HeadObjectResult> {
        @Override
        public HeadObjectResult parseData(Response response, HeadObjectResult result) throws IOException {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            return result;
        }
    }

    public static final class AppendObjectResponseParser
    extends AbstractResponseParser<AppendObjectResult> {
        @Override
        public AppendObjectResult parseData(Response response, AppendObjectResult result) throws IOException {
            String nextPosition = response.header("x-oss-next-append-position");
            if (nextPosition != null) {
                result.setNextPosition(Long.valueOf(nextPosition));
            }
            result.setObjectCRC64(response.header("x-oss-hash-crc64ecma"));
            return result;
        }
    }

    public static final class PutObjectResponseParser
    extends AbstractResponseParser<PutObjectResult> {
        @Override
        public PutObjectResult parseData(Response response, PutObjectResult result) throws IOException {
            result.setETag(ResponseParsers.trimQuotes(response.header("ETag")));
            if (response.body().contentLength() > 0L) {
                result.setServerCallbackReturnBody(response.body().string());
            }
            return result;
        }
    }
}

