/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.internal.sync;

import com.aliyun.core.utils.FunctionalUtils;
import darabonba.core.sync.ContentStreamProvider;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileContentStreamProvider
implements ContentStreamProvider {
    private final Path filePath;
    private final long offset;
    private InputStream currentStream;

    public FileContentStreamProvider(Path filePath) {
        this(filePath, 0L);
    }

    public FileContentStreamProvider(Path filePath, long offset) {
        this.filePath = filePath;
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public InputStream newStream() {
        this.closeCurrentStream();
        this.currentStream = (InputStream)FunctionalUtils.invokeSafely(() -> Files.newInputStream(this.filePath, new OpenOption[0]));
        FunctionalUtils.invokeSafely(() -> this.currentStream.skip(this.offset));
        return this.currentStream;
    }

    private void closeCurrentStream() {
        if (this.currentStream != null) {
            FunctionalUtils.invokeSafely(this.currentStream::close);
            this.currentStream = null;
        }
    }
}

