/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.CredentialsProviderFactory;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RsaKeyPairCredentialProvider;
import com.aliyun.credentials.utils.AuthConstant;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.ProfileUtils;
import com.aliyun.credentials.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private static volatile Map<String, Map<String, String>> ini;

    private static Map<String, Map<String, String>> getIni(String filePath) throws IOException {
        if (null == ini) {
            ini = ProfileUtils.parseFile(filePath);
        }
        return ini;
    }

    @Override
    public CredentialModel getCredentials() {
        Map<String, Map<String, String>> ini;
        String filePath = AuthUtils.getEnvironmentCredentialsFile();
        if (filePath == null) {
            filePath = AuthConstant.DEFAULT_CREDENTIALS_FILE_PATH;
        }
        if (filePath.length() == 0) {
            throw new CredentialException("The specified credentials file is empty.");
        }
        try {
            ini = ProfileCredentialsProvider.getIni(filePath);
        }
        catch (IOException e) {
            throw new CredentialException(String.format("Unable to open credentials file: %s.", filePath));
        }
        Map<String, Map<String, String>> client = this.loadIni(ini);
        Map<String, String> clientConfig = client.get(AuthUtils.getClientType());
        if (clientConfig == null) {
            throw new CredentialException("Client is not open in the specified credentials file.");
        }
        CredentialsProviderFactory credentialsProviderFactory = new CredentialsProviderFactory();
        return this.createCredential(clientConfig, credentialsProviderFactory);
    }

    private Map<String, Map<String, String>> loadIni(Map<String, Map<String, String>> ini) {
        HashMap<String, Map<String, String>> client = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, Map<String, String>> clientType : ini.entrySet()) {
            String enable = clientType.getValue().get("enable");
            if (!Boolean.parseBoolean(enable)) continue;
            HashMap<String, String> clientConfig = new HashMap<String, String>(16);
            for (Map.Entry<String, String> enabledClient : clientType.getValue().entrySet()) {
                clientConfig.put(enabledClient.getKey(), enabledClient.getValue());
            }
            client.put(clientType.getKey(), clientConfig);
        }
        return client;
    }

    private CredentialModel createCredential(Map<String, String> clientConfig, CredentialsProviderFactory factory) {
        String configType = clientConfig.get("type");
        if (StringUtils.isEmpty(configType)) {
            throw new CredentialException("The configured client type is empty.");
        }
        if ("ram_role_arn".equals(configType)) {
            return this.getSTSAssumeRoleSessionCredentials(clientConfig, factory);
        }
        if ("rsa_key_pair".equals(configType)) {
            return this.getSTSGetSessionAccessKeyCredentials(clientConfig, factory);
        }
        if ("ecs_ram_role".equals(configType)) {
            return this.getInstanceProfileCredentials(clientConfig, factory);
        }
        if ("oidc_role_arn".equals(configType)) {
            return this.getSTSOIDCRoleSessionCredentials(clientConfig, factory);
        }
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("The configured access_key_id or access_key_secret is empty.");
        }
        return CredentialModel.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).type("access_key").providerName(String.format("%s/%s", this.getProviderName(), "static_ak")).build();
    }

    private CredentialModel getSTSAssumeRoleSessionCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) {
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        String roleSessionName = clientConfig.get("role_session_name");
        String roleArn = clientConfig.get("role_arn");
        String regionId = clientConfig.get("region_id");
        String policy = clientConfig.get("policy");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("The configured access_key_id or access_key_secret is empty.");
        }
        if (StringUtils.isEmpty(roleSessionName) || StringUtils.isEmpty(roleArn)) {
            throw new CredentialException("The configured role_session_name or role_arn is empty.");
        }
        RamRoleArnCredentialProvider provider = factory.createCredentialsProvider(RamRoleArnCredentialProvider.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).roleArn(roleArn).roleSessionName(roleSessionName).regionId(regionId).policy(policy).build());
        CredentialModel credential = provider.getCredentials();
        return CredentialModel.builder().accessKeyId(credential.getAccessKeyId()).accessKeySecret(credential.getAccessKeySecret()).securityToken(credential.getSecurityToken()).type(credential.getType()).providerName(String.format("%s/%s", this.getProviderName(), credential.getProviderName())).build();
    }

    private CredentialModel getSTSOIDCRoleSessionCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) {
        String roleSessionName = clientConfig.get("role_session_name");
        String roleArn = clientConfig.get("role_arn");
        String OIDCProviderArn = clientConfig.get("oidc_provider_arn");
        String OIDCTokenFilePath = clientConfig.get("oidc_token_file_path");
        String regionId = clientConfig.get("region_id");
        String policy = clientConfig.get("policy");
        if (StringUtils.isEmpty(roleArn)) {
            throw new CredentialException("The configured role_arn is empty.");
        }
        if (StringUtils.isEmpty(OIDCProviderArn)) {
            throw new CredentialException("The configured oidc_provider_arn is empty.");
        }
        OIDCRoleArnCredentialProvider provider = factory.createCredentialsProvider(OIDCRoleArnCredentialProvider.builder().roleArn(roleArn).roleSessionName(roleSessionName).oidcProviderArn(OIDCProviderArn).oidcTokenFilePath(OIDCTokenFilePath).regionId(regionId).policy(policy).build());
        CredentialModel credential = provider.getCredentials();
        return CredentialModel.builder().accessKeyId(credential.getAccessKeyId()).accessKeySecret(credential.getAccessKeySecret()).securityToken(credential.getSecurityToken()).type(credential.getType()).providerName(String.format("%s/%s", this.getProviderName(), credential.getProviderName())).build();
    }

    private CredentialModel getSTSGetSessionAccessKeyCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) {
        String publicKeyId = clientConfig.get("public_key_id");
        String privateKeyFile = clientConfig.get("private_key_file");
        if (StringUtils.isEmpty(privateKeyFile)) {
            throw new CredentialException("The configured private_key_file is empty.");
        }
        String privateKey = AuthUtils.getPrivateKey(privateKeyFile);
        if (StringUtils.isEmpty(publicKeyId) || StringUtils.isEmpty(privateKey)) {
            throw new CredentialException("The configured public_key_id or private_key_file content is empty.");
        }
        RsaKeyPairCredentialProvider provider = factory.createCredentialsProvider(RsaKeyPairCredentialProvider.builder().publicKeyId(publicKeyId).privateKey(privateKey).build());
        CredentialModel credential = provider.getCredentials();
        return CredentialModel.builder().accessKeyId(credential.getAccessKeyId()).accessKeySecret(credential.getAccessKeySecret()).securityToken(credential.getSecurityToken()).type(credential.getType()).providerName(String.format("%s/%s", this.getProviderName(), credential.getProviderName())).build();
    }

    private CredentialModel getInstanceProfileCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) {
        String roleName = clientConfig.get("role_name");
        if (StringUtils.isEmpty(roleName)) {
            throw new CredentialException("The configured role_name is empty.");
        }
        EcsRamRoleCredentialProvider provider = factory.createCredentialsProvider(EcsRamRoleCredentialProvider.builder().roleName(roleName).build());
        CredentialModel credential = provider.getCredentials();
        return CredentialModel.builder().accessKeyId(credential.getAccessKeyId()).accessKeySecret(credential.getAccessKeySecret()).securityToken(credential.getSecurityToken()).type(credential.getType()).providerName(String.format("%s/%s", this.getProviderName(), credential.getProviderName())).build();
    }

    public String getProviderName() {
        return "profile";
    }

    public void close() {
    }
}

