/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import java.util.Calendar;
import java.util.Date;

public class Credential {
    private Date refreshDate;
    private Date expiredDate;
    private String accessKeyId;
    private String accessSecret;
    private String securityToken;

    public Credential() {
        this.refreshDate = new Date();
    }

    public Credential(String keyId, String secret) {
        this.accessKeyId = keyId;
        this.accessSecret = secret;
        this.refreshDate = new Date();
    }

    public Credential(String keyId, String secret, int expiredHours) {
        this.accessKeyId = keyId;
        this.accessSecret = secret;
        this.refreshDate = new Date();
        this.setExpiredDate(expiredHours);
    }

    private void setExpiredDate(int expiredHours) {
        if (expiredHours > 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(10, expiredHours);
            this.expiredDate = cal.getTime();
        }
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public boolean isExpired() {
        if (this.expiredDate == null) {
            return false;
        }
        return !this.expiredDate.after(new Date());
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public Date getRefreshDate() {
        return this.refreshDate;
    }

    public Date getExpiredDate() {
        return this.expiredDate;
    }
}

