/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.thread;

import java.lang.reflect.Method;

public class LaunchRunner
implements Runnable {
    private final String startClassName;
    private final String startMethodName;
    private final String[] args;

    public LaunchRunner(String startClassName, String ... args) {
        this(startClassName, "main", args);
    }

    public LaunchRunner(String startClassName, String startMethodName, String ... args) {
        this.startClassName = startClassName;
        this.startMethodName = startMethodName;
        this.args = args != null ? args : new String[]{};
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            Method entryMethod;
            Class<?> startClass = classLoader.loadClass(this.startClassName);
            try {
                entryMethod = startClass.getMethod(this.startMethodName, String[].class);
            }
            catch (NoSuchMethodException ex) {
                entryMethod = startClass.getDeclaredMethod(this.startMethodName, String[].class);
            }
            if (!entryMethod.isAccessible()) {
                entryMethod.setAccessible(true);
            }
            entryMethod.invoke(null, new Object[]{this.args});
        }
        catch (NoSuchMethodException ex) {
            Exception wrappedEx = new Exception(String.format("The specified entry class:%s doesn't contain an entry method:%s with appropriate signature.", this.startClassName, this.startMethodName), ex);
            thread.getThreadGroup().uncaughtException(thread, wrappedEx);
        }
        catch (Throwable ex) {
            thread.getThreadGroup().uncaughtException(thread, ex);
        }
    }

    public static void join(ThreadGroup threadGroup) {
        boolean hasNonDaemonThreads;
        do {
            hasNonDaemonThreads = false;
            Thread[] threads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null || thread.isDaemon()) continue;
                try {
                    hasNonDaemonThreads = true;
                    thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (hasNonDaemonThreads);
    }
}

