/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.startup;

import com.alipay.sofa.ark.common.util.AssertUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EntryMethod {
    private final Method method;

    public EntryMethod() {
        this(Thread.currentThread());
    }

    public EntryMethod(Thread thread) {
        AssertUtils.assertNotNull((Object)thread, (String)"Thread must not be null");
        this.method = this.getMainMethod(thread);
    }

    private Method getMainMethod(Thread thread) {
        for (StackTraceElement element : thread.getStackTrace()) {
            Method method;
            if (!"main".equals(element.getMethodName()) || (method = this.getMainMethod(element)) == null) continue;
            return method;
        }
        throw new IllegalStateException("Unable to find main method");
    }

    private Method getMainMethod(StackTraceElement element) {
        try {
            Class<?> elementClass = Class.forName(element.getClassName());
            Method method = elementClass.getDeclaredMethod("main", String[].class);
            if (Modifier.isStatic(method.getModifiers())) {
                return method;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getDeclaringClassName() {
        return this.method.getDeclaringClass().getName();
    }

    public String getMethodName() {
        return this.method.getName();
    }
}

