/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.biz;

import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.biz.BizDeployer;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;

public class DefaultBizDeployer
implements BizDeployer {
    @ArkInject
    private BizManagerService bizManagerService;
    private String[] arguments;

    public void init(String[] args) {
        this.arguments = args;
    }

    public void deploy() {
        for (Biz biz : this.bizManagerService.getBizInOrder()) {
            if (this.isEmbedStaticBizAndIllegalState(biz)) continue;
            try {
                ArkLoggerFactory.getDefaultLogger().info(String.format("Begin to start biz: %s", biz.getBizName()));
                biz.start(this.arguments);
                ArkLoggerFactory.getDefaultLogger().info(String.format("Finish to start biz: %s", biz.getBizName()));
            }
            catch (Throwable e) {
                ArkLoggerFactory.getDefaultLogger().error(String.format("Start biz: %s meet error", biz.getBizName()), e);
                throw new ArkRuntimeException(e);
            }
        }
    }

    public void unDeploy() {
        for (Biz biz : this.bizManagerService.getBizInOrder()) {
            try {
                ArkLoggerFactory.getDefaultLogger().info(String.format("Begin to stop biz: %s", biz.getBizName()));
                biz.stop();
                ArkLoggerFactory.getDefaultLogger().info(String.format("Finish to stop biz: %s", biz.getBizName()));
            }
            catch (Throwable e) {
                ArkLoggerFactory.getDefaultLogger().error(String.format("stop biz: %s meet error", biz.getBizName()), e);
                throw new ArkRuntimeException(e);
            }
        }
    }

    public boolean isEmbedStaticBizAndIllegalState(Biz biz) {
        return ArkConfigs.isEmbedStaticBizEnable() && !BizState.RESOLVED.equals((Object)biz.getBizState());
    }

    public String getDesc() {
        return String.format("{name='%s', provider='%s'}", "DefaultBizDeployer", "Ark Container");
    }
}

