/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.bootstrap.ClasspathLauncher;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.FileUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.pipeline.DeployBizStage;
import com.alipay.sofa.ark.container.pipeline.HandleArchiveStage;
import com.alipay.sofa.ark.container.service.ArkServiceContainer;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.loader.EmbedClassPathArchive;
import com.alipay.sofa.ark.loader.ExecutableArkBizJar;
import com.alipay.sofa.ark.loader.archive.ExplodedArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.BizArchive;
import com.alipay.sofa.ark.spi.archive.ExecutableArchive;
import com.alipay.sofa.ark.spi.argument.LaunchCommand;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.pipeline.Pipeline;
import com.alipay.sofa.ark.spi.pipeline.PipelineContext;
import com.alipay.sofa.ark.spi.service.biz.AddBizToStaticDeployHook;
import com.alipay.sofa.ark.spi.service.extension.ArkServiceLoader;
import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.utils.ReportUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArkContainer {
    private ArkServiceContainer arkServiceContainer;
    private PipelineContext pipelineContext;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private long start = System.currentTimeMillis();
    private List<AddBizToStaticDeployHook> addBizToStaticDeployHooks;
    private static final int MINIMUM_ARGS_SIZE = 1;

    public static Object main(String[] args) throws ArkRuntimeException {
        if (args.length < 1) {
            throw new ArkRuntimeException("Please provide suitable arguments to continue !");
        }
        try {
            LaunchCommand launchCommand = LaunchCommand.parse((String[])args);
            if (launchCommand.isExecutedByCommandLine()) {
                File rootFile = FileUtils.file((String)launchCommand.getExecutableArkBizJar().getFile());
                ExecutableArkBizJar executableArchive = rootFile.isDirectory() ? new ExecutableArkBizJar((Archive)new ExplodedArchive(rootFile)) : new ExecutableArkBizJar((Archive)new JarFileArchive(rootFile, launchCommand.getExecutableArkBizJar()));
                return new ArkContainer((ExecutableArchive)executableArchive, launchCommand).start();
            }
            Object classPathArchive = ArkConfigs.isEmbedEnable() ? new EmbedClassPathArchive(launchCommand.getEntryClassName(), launchCommand.getEntryMethodName(), launchCommand.getClasspath()) : new ClasspathLauncher.ClassPathArchive(launchCommand.getEntryClassName(), launchCommand.getEntryMethodName(), launchCommand.getClasspath());
            return new ArkContainer((ExecutableArchive)classPathArchive, launchCommand).start();
        }
        catch (IOException e) {
            throw new ArkRuntimeException(String.format("SOFAArk startup failed, commandline=%s", LaunchCommand.toString((String[])args)), (Throwable)e);
        }
    }

    public ArkContainer(ExecutableArchive executableArchive) throws Exception {
        this(executableArchive, new LaunchCommand().setExecutableArkBizJar(executableArchive.getUrl()));
    }

    public ArkContainer(ExecutableArchive executableArchive, LaunchCommand launchCommand) {
        this.arkServiceContainer = new ArkServiceContainer(launchCommand.getLaunchArgs());
        this.pipelineContext = new PipelineContext();
        this.pipelineContext.setExecutableArchive(executableArchive);
        this.pipelineContext.setLaunchCommand(launchCommand);
    }

    public Object start() throws ArkRuntimeException {
        AssertUtils.assertNotNull((Object)this.arkServiceContainer, (String)"arkServiceContainer is null !");
        if (this.started.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    ArkContainer.this.stop();
                }
            }));
            this.prepareArkConfig();
            this.reInitializeArkLogger();
            this.arkServiceContainer.start();
            Pipeline pipeline = this.arkServiceContainer.getService(Pipeline.class);
            pipeline.process(this.pipelineContext);
            System.out.println("Ark container started in " + (System.currentTimeMillis() - this.start) + " ms.");
        }
        return this;
    }

    public Object deployBizAfterMasterBizReady() throws Exception {
        HandleArchiveStage handleArchiveStage = ArkServiceContainerHolder.getContainer().getService(HandleArchiveStage.class);
        handleArchiveStage.processStaticBizFromClasspath(this.pipelineContext);
        this.addStaticBizFromCustomHooks();
        DeployBizStage deployBizStage = ArkServiceContainerHolder.getContainer().getService(DeployBizStage.class);
        deployBizStage.processStaticBiz(this.pipelineContext);
        return this;
    }

    private void addStaticBizFromCustomHooks() throws Exception {
        this.addBizToStaticDeployHooks = ArkServiceLoader.loadExtensionsFromArkBiz(AddBizToStaticDeployHook.class, (String)ArkClient.getMasterBiz().getIdentity());
        for (AddBizToStaticDeployHook hook : this.addBizToStaticDeployHooks) {
            List bizsFromHook = hook.getStaticBizToAdd();
            this.addStaticBiz(bizsFromHook);
        }
    }

    private void addStaticBiz(List<BizArchive> bizArchives) throws IOException {
        if (null == bizArchives) {
            return;
        }
        for (BizArchive bizArchive : bizArchives) {
            Biz biz = ArkClient.getBizFactoryService().createBiz(bizArchive);
            ArkClient.getBizManagerService().registerBiz(biz);
        }
    }

    public void prepareArkConfig() throws ArkRuntimeException {
        try {
            ArkConfigs.setSystemProperty((String)"endpoints.jmx.enabled", (String)String.valueOf(false));
            ArkConfigs.setSystemProperty((String)"log4j.ignoreTCL", (String)String.valueOf(true));
            ArkConfigs.setSystemProperty((String)"hessian.parent.context.create", (String)"false");
            List<URL> urls = this.getProfileConfFiles(this.pipelineContext.getLaunchCommand().getProfiles());
            ArkConfigs.init(urls);
        }
        catch (Throwable throwable) {
            throw new ArkRuntimeException(throwable);
        }
    }

    public List<URL> getProfileConfFiles(String ... profiles) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String profile : profiles) {
            URL url = StringUtils.isEmpty((String)profile) ? this.getClass().getClassLoader().getResource("bootstrap.properties") : this.getClass().getClassLoader().getResource(String.format("bootstrap-%s.properties", profile));
            if (url != null) {
                urls.add(url);
                continue;
            }
            if (StringUtils.isEmpty((String)profile)) continue;
            ReportUtil.reportWarn((String)String.format("The %s conf file is not found.", profile));
        }
        return urls;
    }

    public void reInitializeArkLogger() throws ArkRuntimeException {
        HashMap<String, String> arkLogConfig = new HashMap<String, String>();
        for (String key : ArkConfigs.keySet()) {
            if (!this.filterAllLogConfig(key)) continue;
            arkLogConfig.put(key, ArkConfigs.getStringValue((String)key));
        }
        arkLogConfig.put("logging.path", ArkConfigs.getStringValue((String)"logging.path", (String)Constants.LOGGING_PATH_DEFAULT));
        arkLogConfig.put("logging.file.path", ArkConfigs.getStringValue((String)"logging.file.path", (String)Constants.LOGGING_PATH_DEFAULT));
        arkLogConfig.put("file.encoding", ArkConfigs.getStringValue((String)"file.encoding", (String)"UTF-8"));
        MultiAppLoggerSpaceManager.init((String)"com.alipay.sofa.ark", arkLogConfig);
    }

    private boolean filterAllLogConfig(String key) {
        return key.startsWith("sofa.middleware.log.") || key.startsWith("logging.level.") || key.startsWith("logging.path.") || key.startsWith("logging.config.") || key.equals("logging.path") || key.equals("loggingRoot") || key.equals("logging.file.path") || key.equals("file.encoding");
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void stop() throws ArkRuntimeException {
        AssertUtils.assertNotNull((Object)this.arkServiceContainer, (String)"arkServiceContainer is null !");
        if (this.stopped.compareAndSet(false, true)) {
            this.arkServiceContainer.stop();
        }
    }

    public boolean isRunning() {
        return this.isStarted() && !this.stopped.get();
    }

    public ArkServiceContainer getArkServiceContainer() {
        return this.arkServiceContainer;
    }

    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }
}

