/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot1.web;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.tomcat.ConnectorStartFailedException;
import org.springframework.util.Assert;

public class ArkTomcatEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(ArkTomcatEmbeddedServletContainer.class);
    private static final AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Object monitor = new Object();
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final Tomcat tomcat;
    private final boolean autoStart;
    private volatile boolean started;
    private Thread awaitThread;
    private Tomcat arkEmbedTomcat;

    public ArkTomcatEmbeddedServletContainer(Tomcat tomcat) {
        this(tomcat, true);
    }

    public ArkTomcatEmbeddedServletContainer(Tomcat tomcat, boolean autoStart) {
        Assert.notNull((Object)tomcat, (String)"Tomcat Server must not be null");
        this.tomcat = tomcat;
        this.autoStart = autoStart;
        this.initialize();
    }

    public ArkTomcatEmbeddedServletContainer(Tomcat tomcat, boolean autoStart, Tomcat arkEmbedTomcat) {
        this(tomcat, autoStart);
        this.arkEmbedTomcat = arkEmbedTomcat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws EmbeddedServletContainerException {
        logger.info((Object)("Tomcat initialized with port(s): " + this.getPortsDescription(false)));
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.addInstanceIdToEngineName();
                Context context = this.findContext();
                context.addLifecycleListener(event -> {
                    if (context.equals(event.getSource()) && "start".equals(event.getType())) {
                        this.removeServiceConnectors();
                    }
                });
                this.tomcat.start();
                this.rethrowDeferredStartupExceptions();
                try {
                    ContextBindings.bindClassLoader((Object)context, (Object)context.getNamingToken(), (ClassLoader)Thread.currentThread().getContextClassLoader());
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.startDaemonAwaitThread();
            }
            catch (Exception ex) {
                this.stopSilently();
                throw new EmbeddedServletContainerException("Unable to start embedded Tomcat", (Throwable)ex);
            }
        }
    }

    private Context findContext() {
        for (Container child : this.tomcat.getHost().findChildren()) {
            if (!(child instanceof Context) || !child.getParentClassLoader().equals(Thread.currentThread().getContextClassLoader())) continue;
            return (Context)child;
        }
        throw new IllegalStateException("The host does not contain a Context");
    }

    private void addInstanceIdToEngineName() {
        int instanceId = containerCounter.incrementAndGet();
        if (instanceId > 0) {
            Engine engine = this.tomcat.getEngine();
            engine.setName(engine.getName() + "-" + instanceId);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.tomcat.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            for (Connector connector : connectors) {
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] children;
        for (Container container : children = this.tomcat.getHost().findChildren()) {
            if (container.getParentClassLoader() != Thread.currentThread().getContextClassLoader() || LifecycleState.STARTED.equals((Object)container.getState())) continue;
            throw new IllegalStateException(container + " failed to start");
        }
    }

    private void startDaemonAwaitThread() {
        this.awaitThread = new Thread("container-" + containerCounter.get()){

            @Override
            public void run() {
                ArkTomcatEmbeddedServletContainer.this.getTomcat().getServer().await();
            }
        };
        this.awaitThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        this.awaitThread.setDaemon(false);
        this.awaitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                this.addPreviouslyRemovedConnectors();
                this.tomcat.getConnector();
                this.checkThatConnectorsHaveStarted();
                this.started = true;
                logger.info((Object)("Tomcat started on port(s): " + this.getPortsDescription(true) + " with context path '" + this.getContextPath() + "'"));
            }
            catch (ConnectorStartFailedException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to start embedded Tomcat server", (Throwable)ex);
            }
            finally {
                Context context = this.findContext();
                ContextBindings.unbindClassLoader((Object)context, (Object)context.getNamingToken(), (ClassLoader)this.getClass().getClassLoader());
            }
        }
    }

    private void checkThatConnectorsHaveStarted() {
        this.checkConnectorHasStarted(this.tomcat.getConnector());
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            this.checkConnectorHasStarted(connector);
        }
    }

    private void checkConnectorHasStarted(Connector connector) {
        if (LifecycleState.FAILED.equals((Object)connector.getState())) {
            throw new ConnectorStartFailedException(connector.getPort());
        }
    }

    public void stopSilently() {
        this.stopContext();
        try {
            this.stopTomcatIfNecessary();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void stopContext() {
        Context context = this.findContext();
        this.getTomcat().getHost().removeChild((Container)context);
    }

    private void stopTomcatIfNecessary() throws LifecycleException {
        if (this.tomcat != this.arkEmbedTomcat) {
            this.tomcat.destroy();
        }
        this.awaitThread.stop();
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] services;
        for (Service service : services = this.tomcat.getServer().findServices()) {
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot pause connector: ", (Throwable)ex);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            boolean wasStarted = this.started;
            try {
                this.started = false;
                try {
                    this.stopContext();
                    this.stopTomcatIfNecessary();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to stop embedded Tomcat", (Throwable)ex);
            }
            finally {
                if (wasStarted) {
                    containerCounter.decrementAndGet();
                }
            }
        }
    }

    private String getPortsDescription(boolean localPort) {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            if (ports.length() != 0) {
                ports.append(' ');
            }
            int port = localPort ? connector.getLocalPort() : connector.getPort();
            ports.append(port).append(" (").append(connector.getScheme()).append(')');
        }
        return ports.toString();
    }

    public int getPort() {
        Connector connector = this.tomcat.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return 0;
    }

    private String getContextPath() {
        return this.findContext().getPath();
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }
}

