/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.NetworkAddressUtil;
import com.alipay.sofa.rpc.boot.common.RpcThreadPoolMonitor;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class ServerConfigContainer {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(ServerConfigContainer.class);
    private SofaBootRpcProperties sofaBootRpcProperties;
    private volatile ServerConfig boltServerConfig;
    private final Object BOLT_LOCK = new Object();
    private volatile ServerConfig restServerConfig;
    private final Object REST_LOCK = new Object();
    private volatile ServerConfig dubboServerConfig;
    private final Object DUBBO_LOCK = new Object();
    private volatile ServerConfig h2cServerConfig;
    private final Object H2C_LOCK = new Object();
    private Map<String, ServerConfig> customServerConfigs = new ConcurrentHashMap<String, ServerConfig>();

    public ServerConfigContainer(SofaBootRpcProperties sofaBootRpcProperties) {
        this.sofaBootRpcProperties = sofaBootRpcProperties;
        NetworkAddressUtil.caculate(sofaBootRpcProperties.getEnabledIpRange(), sofaBootRpcProperties.getBindNetworkInterface());
    }

    public void startServers() {
        if (this.boltServerConfig != null) {
            this.boltServerConfig.buildIfAbsent().start();
            BoltServer server = (BoltServer)this.boltServerConfig.getServer();
            ThreadPoolExecutor threadPoolExecutor = server.getBizThreadPool();
            if (threadPoolExecutor != null) {
                new RpcThreadPoolMonitor(threadPoolExecutor).start();
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("the business threadpool can not be get");
            }
        }
        if (this.restServerConfig != null) {
            this.restServerConfig.buildIfAbsent().start();
        }
        if (this.h2cServerConfig != null) {
            this.h2cServerConfig.buildIfAbsent().start();
        }
        for (Map.Entry<String, ServerConfig> entry : this.customServerConfigs.entrySet()) {
            ServerConfig serverConfig = entry.getValue();
            if (serverConfig == null) continue;
            serverConfig.buildIfAbsent().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfig getServerConfig(String protocol) {
        if (protocol.equalsIgnoreCase("bolt")) {
            if (this.boltServerConfig == null) {
                Object object = this.BOLT_LOCK;
                synchronized (object) {
                    if (this.boltServerConfig == null) {
                        this.boltServerConfig = this.createBoltServerConfig();
                    }
                }
            }
            return this.boltServerConfig;
        }
        if (protocol.equalsIgnoreCase("rest")) {
            if (this.restServerConfig == null) {
                Object object = this.REST_LOCK;
                synchronized (object) {
                    if (this.restServerConfig == null) {
                        this.restServerConfig = this.createRestServerConfig();
                    }
                }
            }
            return this.restServerConfig;
        }
        if (protocol.equalsIgnoreCase("dubbo")) {
            if (this.dubboServerConfig == null) {
                Object object = this.DUBBO_LOCK;
                synchronized (object) {
                    if (this.dubboServerConfig == null) {
                        this.dubboServerConfig = this.createDubboServerConfig();
                    }
                }
            }
            return this.dubboServerConfig;
        }
        if (protocol.equalsIgnoreCase("h2c")) {
            if (this.h2cServerConfig == null) {
                Object object = this.H2C_LOCK;
                synchronized (object) {
                    if (this.h2cServerConfig == null) {
                        this.h2cServerConfig = this.createH2cServerConfig();
                    }
                }
            }
            return this.h2cServerConfig;
        }
        if (this.customServerConfigs.get(protocol) != null) {
            return this.customServerConfigs.get(protocol);
        }
        throw new SofaBootRpcRuntimeException("protocol [" + protocol + "] is not supported");
    }

    private void addCommonServerConfig(ServerConfig serverConfig) {
        String boundHostStr = this.sofaBootRpcProperties.getBoundHost();
        String virtualHostStr = this.sofaBootRpcProperties.getVirtualHost();
        String virtualPortStr = this.sofaBootRpcProperties.getVirtualPort();
        serverConfig.setVirtualHost(NetworkAddressUtil.getLocalIP());
        serverConfig.setBoundHost(NetworkAddressUtil.getLocalBindIP());
        if (StringUtils.hasText((String)boundHostStr)) {
            serverConfig.setBoundHost(boundHostStr);
        }
        if (StringUtils.hasText((String)virtualHostStr)) {
            serverConfig.setVirtualHost(virtualHostStr);
        }
        if (StringUtils.hasText((String)virtualPortStr)) {
            serverConfig.setVirtualPort(Integer.valueOf(Integer.parseInt(virtualPortStr)));
        }
    }

    ServerConfig createH2cServerConfig() {
        String portStr = this.sofaBootRpcProperties.getH2cPort();
        String h2cThreadPoolCoreSizeStr = this.sofaBootRpcProperties.getH2cThreadPoolCoreSize();
        String h2cThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getH2cThreadPoolMaxSize();
        String acceptsSizeStr = this.sofaBootRpcProperties.getH2cAcceptsSize();
        String h2cThreadPoolQueueSizeStr = this.sofaBootRpcProperties.getH2cThreadPoolQueueSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(12300);
        }
        if (StringUtils.hasText((String)h2cThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(h2cThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)h2cThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(h2cThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)acceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsSizeStr));
        }
        if (StringUtils.hasText((String)h2cThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(h2cThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        return serverConfig.setProtocol("h2c");
    }

    ServerConfig createBoltServerConfig() {
        String portStr = this.sofaBootRpcProperties.getBoltPort();
        String boltThreadPoolCoreSizeStr = this.sofaBootRpcProperties.getBoltThreadPoolCoreSize();
        String boltThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getBoltThreadPoolMaxSize();
        String acceptsSizeStr = this.sofaBootRpcProperties.getBoltAcceptsSize();
        String boltThreadPoolQueueSizeStr = this.sofaBootRpcProperties.getBoltThreadPoolQueueSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(12200);
        }
        if (StringUtils.hasText((String)boltThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(boltThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)boltThreadPoolCoreSizeStr)) {
            serverConfig.setCoreThreads(Integer.parseInt(boltThreadPoolCoreSizeStr));
        }
        if (StringUtils.hasText((String)acceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsSizeStr));
        }
        if (StringUtils.hasText((String)boltThreadPoolQueueSizeStr)) {
            serverConfig.setQueues(Integer.parseInt(boltThreadPoolQueueSizeStr));
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("bolt");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    ServerConfig createRestServerConfig() {
        String hostName = this.sofaBootRpcProperties.getRestHostname();
        String portStr = this.sofaBootRpcProperties.getRestPort();
        String ioThreadSizeStr = this.sofaBootRpcProperties.getRestIoThreadSize();
        String contextPath = this.sofaBootRpcProperties.getRestContextPath();
        String restThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getRestThreadPoolMaxSize();
        String maxRequestSizeStr = this.sofaBootRpcProperties.getRestMaxRequestSize();
        String telnetStr = this.sofaBootRpcProperties.getRestTelnet();
        String daemonStr = this.sofaBootRpcProperties.getRestDaemon();
        if (!StringUtils.hasText((String)hostName)) {
            hostName = null;
        }
        int port = !StringUtils.hasText((String)portStr) ? 8341 : Integer.parseInt(portStr);
        int ioThreadCount = !StringUtils.hasText((String)ioThreadSizeStr) ? SofaBootRpcConfigConstants.REST_IO_THREAD_COUNT_DEFAULT : Integer.parseInt(ioThreadSizeStr);
        int restThreadPoolMaxSize = !StringUtils.hasText((String)restThreadPoolMaxSizeStr) ? 200 : Integer.parseInt(restThreadPoolMaxSizeStr);
        int maxRequestSize = !StringUtils.hasText((String)maxRequestSizeStr) ? 0xA00000 : Integer.parseInt(maxRequestSizeStr);
        boolean telnet = !StringUtils.hasText((String)telnetStr) ? true : Boolean.parseBoolean(telnetStr);
        boolean daemon = !StringUtils.hasText((String)daemonStr) ? true : Boolean.parseBoolean(daemonStr);
        ServerConfig serverConfig = new ServerConfig().setPort(port).setIoThreads(ioThreadCount).setMaxThreads(restThreadPoolMaxSize).setPayload(maxRequestSize).setTelnet(telnet).setDaemon(daemon);
        if (!StringUtils.isEmpty((Object)contextPath)) {
            serverConfig.setContextPath(contextPath);
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("rest");
        this.addCommonServerConfig(serverConfig);
        serverConfig.setBoundHost(hostName);
        return serverConfig;
    }

    ServerConfig createDubboServerConfig() {
        String portStr = this.sofaBootRpcProperties.getDubboPort();
        String ioThreadSizeStr = this.sofaBootRpcProperties.getDubboIoThreadSize();
        String dubboThreadPoolMaxSizeStr = this.sofaBootRpcProperties.getDubboThreadPoolMaxSize();
        String dubboAcceptsSizeStr = this.sofaBootRpcProperties.getDubboAcceptsSize();
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(20880);
        }
        if (StringUtils.hasText((String)ioThreadSizeStr)) {
            serverConfig.setIoThreads(Integer.parseInt(ioThreadSizeStr));
        }
        if (StringUtils.hasText((String)dubboThreadPoolMaxSizeStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(dubboThreadPoolMaxSizeStr));
        }
        if (StringUtils.hasText((String)dubboAcceptsSizeStr)) {
            serverConfig.setAccepts(Integer.parseInt(dubboAcceptsSizeStr));
        }
        serverConfig.setAutoStart(false);
        serverConfig.setProtocol("dubbo");
        this.addCommonServerConfig(serverConfig);
        return serverConfig;
    }

    public void closeAllServer() {
        if (this.boltServerConfig != null) {
            this.boltServerConfig.destroy();
            this.boltServerConfig = null;
        }
        if (this.restServerConfig != null) {
            this.restServerConfig.destroy();
            this.restServerConfig = null;
        }
        if (this.dubboServerConfig != null) {
            this.dubboServerConfig.destroy();
            this.dubboServerConfig = null;
        }
        if (this.h2cServerConfig != null) {
            this.h2cServerConfig.destroy();
            this.h2cServerConfig = null;
        }
        for (Map.Entry<String, ServerConfig> entry : this.customServerConfigs.entrySet()) {
            ServerConfig serverConfig = entry.getValue();
            if (serverConfig == null) continue;
            serverConfig.destroy();
        }
        this.customServerConfigs.clear();
    }

    public boolean registerCustomServerConfig(String protocol, ServerConfig serverConfig) {
        if (this.customServerConfigs.containsKey(protocol)) {
            return false;
        }
        this.customServerConfigs.put(protocol, serverConfig);
        return true;
    }

    public boolean unRegisterCustomServerConfig(String protocol) {
        this.customServerConfigs.remove(protocol);
        return true;
    }
}

