/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.config.RegistryConfigureProcessor;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;

public class LocalFileConfigurator
implements RegistryConfigureProcessor {
    private static String COLON = ":";

    public String parseConfig(String config) {
        String file = null;
        if (StringUtils.isNotEmpty((CharSequence)config) && config.startsWith("local") && config.length() > "local".length()) {
            file = config.substring("local".length() + COLON.length());
        }
        return file;
    }

    @Override
    public RegistryConfig buildFromAddress(String address) {
        String filePath = this.parseConfig(address);
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            filePath = SofaBootRpcConfigConstants.REGISTRY_FILE_PATH_DEFAULT;
        }
        return new RegistryConfig().setFile(filePath).setProtocol("local");
    }
}

