/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.logging;

import com.alipay.sofa.boot.logging.LocalEnvUtil;
import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class LogEnvironmentPreparingListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.defaultConsoleLoggers();
        this.prepare(event.getEnvironment());
    }

    public int getOrder() {
        return -2147483628;
    }

    private void prepare(ConfigurableEnvironment environment) {
        HashMap<String, String> context = new HashMap<String, String>();
        this.loadLogConfiguration("logging.path", environment.getProperty("logging.path"), Constants.LOGGING_PATH_DEFAULT, context);
        this.loadLogConfiguration("loggingRoot", environment.getProperty("loggingRoot"), (String)context.get("logging.path"), context);
        this.loadLogConfiguration("file.encoding", environment.getProperty("file.encoding"), context);
        LogEnvUtils.keepCompatible(context, (boolean)true);
        for (Map.Entry entry : context.entrySet()) {
            CommonLoggingConfigurations.loadExternalConfiguration((String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!LogEnvUtils.isSofaCommonLoggingConfig((String)key)) continue;
                CommonLoggingConfigurations.loadExternalConfiguration((String)key, (String)environment.getProperty(key));
            }
        }
    }

    private void defaultConsoleLoggers() {
        if (LocalEnvUtil.isLocalEnv() || LocalEnvUtil.isTestEnv()) {
            CommonLoggingConfigurations.loadExternalConfiguration((String)"sofa.middleware.log.console", (String)"true");
        }
    }

    private void loadLogConfiguration(String key, String value, String defaultValue, Map<String, String> context) {
        if (!StringUtil.isBlank((String)value)) {
            context.put(key, value);
        } else {
            context.put(key, defaultValue);
        }
    }

    private void loadLogConfiguration(String key, String value, Map<String, String> context) {
        if (!StringUtil.isBlank((String)value)) {
            context.put(key, value);
        }
    }
}

