/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel.util;

import com.alipay.easysdk.kernel.AlipayConstants;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Signer.class);

    public static String getSignCheckContent(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static boolean verify(String content, String sign, String publicKeyPem) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = publicKeyPem.getBytes();
            encodedKey = Base64.decode((byte[])encodedKey);
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(publicKey);
            signature.update(content.getBytes(AlipayConstants.DEFAULT_CHARSET));
            return signature.verify(Base64.decode((byte[])sign.getBytes()));
        }
        catch (Exception e) {
            String errorMessage = "\u9a8c\u7b7e\u906d\u9047\u5f02\u5e38\uff0ccontent=" + content + " sign=" + sign + " publicKey=" + publicKeyPem + " reason=" + e.getMessage();
            LOGGER.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public String sign(String content, String privateKeyPem) {
        try {
            byte[] encodedKey = privateKeyPem.getBytes();
            encodedKey = Base64.decode((byte[])encodedKey);
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(privateKey);
            signature.update(content.getBytes(AlipayConstants.DEFAULT_CHARSET));
            byte[] signed = signature.sign();
            return new String(Base64.encode((byte[])signed));
        }
        catch (Exception e) {
            String errorMessage = "\u7b7e\u540d\u906d\u9047\u5f02\u5e38\uff0ccontent=" + content + " privateKeySize=" + privateKeyPem.length() + " reason=" + e.getMessage();
            LOGGER.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static boolean verifyParams(Map<String, String> parameters, String publicKey) {
        String sign = parameters.get("sign");
        parameters.remove("sign");
        parameters.remove("sign_type");
        String content = Signer.getSignCheckContent(parameters);
        return Signer.verify(content, sign, publicKey);
    }
}

