/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redisson;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redisson.RedissonBroadcastManager;
import com.alicp.jetcache.redisson.RedissonCache;
import com.alicp.jetcache.redisson.RedissonCacheConfig;
import com.alicp.jetcache.support.BroadcastManager;
import org.redisson.api.RedissonClient;

public class RedissonCacheBuilder<T extends ExternalCacheBuilder<T>>
extends ExternalCacheBuilder<T> {
    public static RedissonDataCacheBuilderImpl createBuilder() {
        return new RedissonDataCacheBuilderImpl();
    }

    protected RedissonCacheBuilder() {
        this.buildFunc(config -> new RedissonCache((RedissonCacheConfig)((Object)config)));
    }

    public RedissonCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new RedissonCacheConfig();
        }
        return (RedissonCacheConfig)this.config;
    }

    public T redissonClient(RedissonClient client) {
        this.getConfig().setRedissonClient(client);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public boolean supportBroadcast() {
        return true;
    }

    public BroadcastManager createBroadcastManager(CacheManager cacheManager) {
        RedissonCacheConfig c = (RedissonCacheConfig)this.getConfig().clone();
        return new RedissonBroadcastManager(cacheManager, c);
    }

    public static class RedissonDataCacheBuilderImpl
    extends RedissonCacheBuilder<RedissonDataCacheBuilderImpl> {
    }
}

