/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis.springdata;

import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redis.springdata.RedisSpringDataCacheConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;

public class RedisSpringDataCache<K, V>
extends AbstractExternalCache<K, V> {
    private Logger logger = LoggerFactory.getLogger(RedisSpringDataCache.class);
    private RedisConnectionFactory connectionFactory;
    private RedisSpringDataCacheConfig<K, V> config;
    private Function<Object, byte[]> valueEncoder;
    private Function<byte[], Object> valueDecoder;

    public RedisSpringDataCache(RedisSpringDataCacheConfig<K, V> config) {
        super(config);
        this.connectionFactory = config.getConnectionFactory();
        if (this.connectionFactory == null) {
            throw new CacheConfigException("connectionFactory is required");
        }
        this.config = config;
        this.valueEncoder = config.getValueEncoder();
        this.valueDecoder = config.getValueDecoder();
    }

    private void closeConnection(RedisConnection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception ex) {
            this.logger.error("RedisConnection close fail: {}, {}", (Object)ex.getMessage(), (Object)ex.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheGetResult<V> do_GET(K key) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            byte[] newKey = this.buildKey(key);
            byte[] resultBytes = con.get(newKey);
            if (resultBytes != null) {
                CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply(resultBytes);
                if (System.currentTimeMillis() >= holder.getExpireTime()) {
                    CacheGetResult cacheGetResult = CacheGetResult.EXPIRED_WITHOUT_MSG;
                    return cacheGetResult;
                }
                CacheGetResult cacheGetResult = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                return cacheGetResult;
            }
            CacheGetResult cacheGetResult = CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
            return cacheGetResult;
        }
        catch (Exception ex) {
            this.logError("GET", key, ex);
            CacheGetResult cacheGetResult = new CacheGetResult((Throwable)ex);
            return cacheGetResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> this.buildKey(k)).toArray(x$0 -> new byte[x$0][]);
            HashMap<K, CacheGetResult> resultMap = new HashMap<K, CacheGetResult>();
            if (newKeys.length > 0) {
                List mgetResults = con.mGet(newKeys);
                for (int i = 0; i < mgetResults.size(); ++i) {
                    Object value = mgetResults.get(i);
                    K key = keyList.get(i);
                    if (value != null) {
                        CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply((byte[])value);
                        if (System.currentTimeMillis() >= holder.getExpireTime()) {
                            resultMap.put(key, CacheGetResult.EXPIRED_WITHOUT_MSG);
                            continue;
                        }
                        CacheGetResult r = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                        resultMap.put(key, r);
                        continue;
                    }
                    resultMap.put(key, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                }
            }
            MultiGetResult multiGetResult = new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
            return multiGetResult;
        }
        catch (Exception ex) {
            this.logError("GET_ALL", "keys(" + keys.size() + ")", ex);
            MultiGetResult multiGetResult = new MultiGetResult((Throwable)ex);
            return multiGetResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] keyBytes = this.buildKey(key);
            byte[] valueBytes = this.valueEncoder.apply(holder);
            Boolean result = con.pSetEx(keyBytes, timeUnit.toMillis(expireAfterWrite), valueBytes);
            if (Boolean.TRUE.equals(result)) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, "result:" + result);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            int failCount = 0;
            for (Map.Entry<K, V> en : map.entrySet()) {
                CacheValueHolder holder = new CacheValueHolder(en.getValue(), timeUnit.toMillis(expireAfterWrite));
                Boolean result = con.pSetEx(this.buildKey(en.getKey()), timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
                if (Boolean.TRUE.equals(result)) continue;
                ++failCount;
            }
            CacheResult cacheResult = failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == map.size() ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_REMOVE(K key) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            byte[] keyBytes = this.buildKey(key);
            Long result = con.del((byte[][])new byte[][]{keyBytes});
            if (result == null) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, "result:" + result);
                return cacheResult;
            }
            if (result == 1L) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            if (result == 0L) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.NOT_EXISTS, null);
                return cacheResult;
            }
            CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("REMOVE", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            byte[][] newKeys = (byte[][])keys.stream().map(k -> this.buildKey(k)).toArray(len -> new byte[keys.size()][]);
            Long result = con.del(newKeys);
            if (result != null) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, "result:" + result);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        RedisConnection con = null;
        try {
            con = this.connectionFactory.getConnection();
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            Boolean result = con.set(newKey, this.valueEncoder.apply(holder), Expiration.from((long)expireAfterWrite, (TimeUnit)timeUnit), RedisStringCommands.SetOption.ifAbsent());
            if (Boolean.TRUE.equals(result)) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            CacheResult cacheResult = CacheResult.EXISTS_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT_IF_ABSENT", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            this.closeConnection(con);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException("RedisSpringDataCache does not support unwrap");
    }

    public RedisSpringDataCacheConfig<K, V> config() {
        return this.config;
    }

    protected boolean needLogStackTrace(Throwable e) {
        return !(e instanceof RedisConnectionFailureException);
    }
}

