/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.alicp.jetcache.support.ObjectPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class JavaValueEncoder
extends AbstractValueEncoder {
    public static final JavaValueEncoder INSTANCE = new JavaValueEncoder(true);
    private static final int INIT_BUF_SIZE = 2048;
    static ObjectPool<ByteArrayOutputStream> bosPool = new ObjectPool<ByteArrayOutputStream>(16, new ObjectPool.ObjectFactory<ByteArrayOutputStream>(){

        @Override
        public ByteArrayOutputStream create() {
            return new ByteArrayOutputStream(2048);
        }

        @Override
        public void reset(ByteArrayOutputStream obj) {
            obj.reset();
        }
    });

    public JavaValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    @Override
    public byte[] apply(Object value) {
        ByteArrayOutputStream bos = null;
        try {
            bos = bosPool.borrowObject();
            if (this.useIdentityNumber) {
                bos.write(74);
                bos.write(149);
                bos.write(58);
                bos.write(128);
            }
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder("Java Encode error. ");
            sb.append("msg=").append(e.getMessage());
            throw new CacheEncodeException(sb.toString(), e);
        }
        finally {
            if (bos != null) {
                bosPool.returnObject(bos);
            }
        }
    }
}

