/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import java.lang.ref.WeakReference;

public class KryoValueEncoder
extends AbstractValueEncoder {
    public static final KryoValueEncoder INSTANCE = new KryoValueEncoder(true);
    private static int INIT_BUFFER_SIZE = 256;
    static ThreadLocal<Object[]> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        byte[] buffer = new byte[INIT_BUFFER_SIZE];
        WeakReference<byte[]> ref = new WeakReference<byte[]>(buffer);
        return new Object[]{kryo, ref};
    });

    public KryoValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(Object value) {
        byte[] byArray;
        Object[] kryoAndBuffer = kryoThreadLocal.get();
        Kryo kryo = (Kryo)kryoAndBuffer[0];
        WeakReference<byte[]> ref = (WeakReference<byte[]>)kryoAndBuffer[1];
        byte[] buffer = (byte[])ref.get();
        if (buffer == null) {
            buffer = new byte[INIT_BUFFER_SIZE];
        }
        Output output = new Output(buffer, -1);
        try {
            if (this.useIdentityNumber) {
                this.writeInt(output, 1251293826);
            }
            kryo.writeClassAndObject(output, value);
            byArray = output.toBytes();
        }
        catch (Throwable throwable) {
            try {
                if (ref.get() == null || buffer != output.getBuffer()) {
                    kryoAndBuffer[1] = ref = new WeakReference<byte[]>(output.getBuffer());
                }
                throw throwable;
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder("Kryo Encode error. ");
                sb.append("msg=").append(e.getMessage());
                throw new CacheEncodeException(sb.toString(), e);
            }
        }
        if (ref.get() == null || buffer != output.getBuffer()) {
            kryoAndBuffer[1] = ref = new WeakReference<byte[]>(output.getBuffer());
        }
        return byArray;
    }

    private void writeInt(Output output, int value) {
        output.writeByte(value >>> 24);
        output.writeByte(value >>> 16);
        output.writeByte(value >>> 8);
        output.writeByte(value);
    }
}

