/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class JetCacheExecutor {
    protected static volatile ScheduledExecutorService defaultExecutor;
    protected static volatile ScheduledExecutorService heavyIOExecutor;
    private static AtomicInteger threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService defaultExecutor() {
        if (defaultExecutor != null) {
            return defaultExecutor;
        }
        Class<JetCacheExecutor> clazz = JetCacheExecutor.class;
        synchronized (JetCacheExecutor.class) {
            if (defaultExecutor == null) {
                ThreadFactory tf = r -> {
                    Thread t = new Thread(r, "JetCacheDefaultExecutor");
                    t.setDaemon(true);
                    return t;
                };
                defaultExecutor = new ScheduledThreadPoolExecutor(1, tf, new ThreadPoolExecutor.DiscardPolicy());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService heavyIOExecutor() {
        if (heavyIOExecutor != null) {
            return heavyIOExecutor;
        }
        Class<JetCacheExecutor> clazz = JetCacheExecutor.class;
        synchronized (JetCacheExecutor.class) {
            if (heavyIOExecutor == null) {
                ThreadFactory tf = r -> {
                    Thread t = new Thread(r, "JetCacheHeavyIOExecutor" + threadCount.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                };
                heavyIOExecutor = new ScheduledThreadPoolExecutor(10, tf, new ThreadPoolExecutor.DiscardPolicy());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return heavyIOExecutor;
        }
    }

    public static void setDefaultExecutor(ScheduledExecutorService executor) {
        defaultExecutor = executor;
    }

    public static void setHeavyIOExecutor(ScheduledExecutorService heavyIOExecutor) {
        JetCacheExecutor.heavyIOExecutor = heavyIOExecutor;
    }

    static {
        threadCount = new AtomicInteger(0);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (defaultExecutor != null) {
                    defaultExecutor.shutdownNow();
                }
                if (heavyIOExecutor != null) {
                    heavyIOExecutor.shutdownNow();
                }
            }
        });
    }
}

