/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;

public class JavaValueEncoder
extends AbstractValueEncoder {
    public static final JavaValueEncoder INSTANCE = new JavaValueEncoder(true);
    private static final int INIT_BUF_SIZE = 256;
    private static ThreadLocal<WeakReference<ByteArrayOutputStream>> threadLocal = ThreadLocal.withInitial(() -> new WeakReference<ByteArrayOutputStream>(new ByteArrayOutputStream(256)));

    public JavaValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(Object value) {
        WeakReference<ByteArrayOutputStream> ref = threadLocal.get();
        ByteArrayOutputStream bos = (ByteArrayOutputStream)ref.get();
        if (bos == null) {
            bos = new ByteArrayOutputStream(256);
            threadLocal.set(new WeakReference<ByteArrayOutputStream>(bos));
        }
        try {
            if (this.useIdentityNumber) {
                bos.write(74);
                bos.write(149);
                bos.write(58);
                bos.write(128);
            }
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.flush();
            byte[] byArray = bos.toByteArray();
            bos.reset();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                bos.reset();
                throw throwable;
            }
            catch (IOException e) {
                StringBuilder sb = new StringBuilder("Java Encode error. ");
                sb.append("msg=").append(e.getMessage());
                throw new CacheEncodeException(sb.toString(), e);
            }
        }
    }
}

