/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.support.CacheMessage;
import java.util.function.Function;

public class CacheNotifyMonitor
implements CacheMonitor {
    private final BroadcastManager broadcastManager;
    private final String area;
    private final String cacheName;
    private final String sourceId;

    public CacheNotifyMonitor(CacheManager cacheManager, String area, String cacheName) {
        this.broadcastManager = cacheManager.getBroadcastManager(area);
        this.area = area;
        this.cacheName = cacheName;
        this.sourceId = this.broadcastManager != null ? this.broadcastManager.getSourceId() : null;
    }

    public CacheNotifyMonitor(CacheManager cacheManager, String cacheName) {
        this(cacheManager, "default", cacheName);
    }

    private Object convertKey(Object key, AbstractEmbeddedCache localCache) {
        Function keyConvertor = localCache.config().getKeyConvertor();
        if (keyConvertor == null) {
            return key;
        }
        return keyConvertor.apply(key);
    }

    private AbstractEmbeddedCache getLocalCache(AbstractCache absCache) {
        if (!(absCache instanceof MultiLevelCache)) {
            return null;
        }
        for (Cache c : ((MultiLevelCache)absCache).caches()) {
            if (!(c instanceof AbstractEmbeddedCache)) continue;
            return (AbstractEmbeddedCache)c;
        }
        return null;
    }

    @Override
    public void afterOperation(CacheEvent event) {
        if (this.broadcastManager == null) {
            return;
        }
        AbstractCache absCache = CacheUtil.getAbstractCache(event.getCache());
        if (absCache.isClosed()) {
            return;
        }
        AbstractEmbeddedCache localCache = this.getLocalCache(absCache);
        if (localCache == null) {
            return;
        }
        if (event instanceof CachePutEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CachePutEvent e = (CachePutEvent)event;
            m.setType(1);
            m.setKeys(new Object[]{this.convertKey(e.getKey(), localCache)});
            this.broadcastManager.publish(m);
        } else if (event instanceof CacheRemoveEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CacheRemoveEvent e = (CacheRemoveEvent)event;
            m.setType(3);
            m.setKeys(new Object[]{this.convertKey(e.getKey(), localCache)});
            this.broadcastManager.publish(m);
        } else if (event instanceof CachePutAllEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CachePutAllEvent e = (CachePutAllEvent)event;
            m.setType(2);
            if (e.getMap() != null) {
                m.setKeys(e.getMap().keySet().stream().map(k -> this.convertKey(k, localCache)).toArray());
            }
            this.broadcastManager.publish(m);
        } else if (event instanceof CacheRemoveAllEvent) {
            CacheMessage m = new CacheMessage();
            m.setArea(this.area);
            m.setCacheName(this.cacheName);
            m.setSourceId(this.sourceId);
            CacheRemoveAllEvent e = (CacheRemoveAllEvent)event;
            m.setType(4);
            if (e.getKeys() != null) {
                m.setKeys(e.getKeys().stream().map(k -> this.convertKey(k, localCache)).toArray());
            }
            this.broadcastManager.publish(m);
        }
    }
}

