/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.support.CacheMessage;
import com.alicp.jetcache.support.SquashedLogger;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BroadcastManager
implements AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(BroadcastManager.class);
    private final String sourceId = UUID.randomUUID().toString();
    private final CacheManager cacheManager;

    public BroadcastManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void checkConfig(ExternalCacheConfig config) {
        if (config.getBroadcastChannel() == null) {
            throw new CacheConfigException("BroadcastChannel not set");
        }
        if (config.getValueEncoder() == null) {
            throw new CacheConfigException("no value encoder");
        }
        if (config.getValueDecoder() == null) {
            throw new CacheConfigException("no value decoder");
        }
    }

    public abstract CacheResult publish(CacheMessage var1);

    public abstract void startSubscribe();

    @Override
    public void close() throws Exception {
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected void processNotification(byte[] message, Function<byte[], Object> decoder) {
        try {
            if (message == null) {
                logger.error("notify message is null");
                return;
            }
            Object value = decoder.apply(message);
            if (value == null) {
                logger.error("notify message is null");
                return;
            }
            if (value instanceof CacheMessage) {
                this.processCacheMessage((CacheMessage)value);
            } else {
                logger.error("the message is not instance of CacheMessage, class={}", value.getClass());
            }
        }
        catch (Throwable e) {
            SquashedLogger.getLogger(logger).error("receive cache notify error", e);
        }
    }

    private void processCacheMessage(CacheMessage cacheMessage) {
        Cache c;
        AbstractCache localCache;
        if (this.sourceId.equals(cacheMessage.getSourceId())) {
            return;
        }
        Cache cache = this.cacheManager.getCache(cacheMessage.getArea(), cacheMessage.getCacheName());
        if (cache == null) {
            logger.warn("Cache instance not exists: {},{}", (Object)cacheMessage.getArea(), (Object)cacheMessage.getCacheName());
            return;
        }
        AbstractCache absCache = CacheUtil.getAbstractCache(cache);
        if (!(absCache instanceof MultiLevelCache)) {
            logger.warn("Cache instance is not MultiLevelCache: {},{}", (Object)cacheMessage.getArea(), (Object)cacheMessage.getCacheName());
            return;
        }
        Cache[] caches = ((MultiLevelCache)absCache).caches();
        Set keys = Stream.of(cacheMessage.getKeys()).collect(Collectors.toSet());
        Cache[] cacheArray = caches;
        int n = cacheArray.length;
        for (int i = 0; i < n && (localCache = CacheUtil.getAbstractCache(c = cacheArray[i])) instanceof AbstractEmbeddedCache; ++i) {
            ((AbstractEmbeddedCache)localCache).__removeAll(keys);
        }
    }
}

