/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.external;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.anno.KeyConvertor;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.external.ExternalKeyUtil;
import java.io.IOException;

public abstract class AbstractExternalCache<K, V>
extends AbstractCache<K, V> {
    private ExternalCacheConfig<K, V> config;

    public AbstractExternalCache(ExternalCacheConfig<K, V> config) {
        this.config = config;
        this.checkConfig();
    }

    protected void checkConfig() {
        if (this.config.getValueEncoder() == null) {
            throw new CacheConfigException("no value encoder");
        }
        if (this.config.getValueDecoder() == null) {
            throw new CacheConfigException("no value decoder");
        }
        if (this.config.getKeyPrefix() == null) {
            throw new CacheConfigException("keyPrefix is required");
        }
    }

    public byte[] buildKey(K key) {
        try {
            Object newKey = key;
            if (this.config.getKeyConvertor() != null) {
                if (this.config.getKeyConvertor() instanceof KeyConvertor) {
                    if (!this.isPreservedKey(key)) {
                        newKey = this.config.getKeyConvertor().apply(key);
                    }
                } else {
                    newKey = key instanceof byte[] ? key : (key instanceof String ? key : this.config.getKeyConvertor().apply(key));
                }
            }
            return ExternalKeyUtil.buildKeyAfterConvert(newKey, this.config.getKeyPrefix());
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    private boolean isPreservedKey(Object key) {
        if (key instanceof byte[]) {
            byte[] keyBytes = (byte[])key;
            return this.endWith(keyBytes, RefreshCache.LOCK_KEY_SUFFIX) || this.endWith(keyBytes, RefreshCache.TIMESTAMP_KEY_SUFFIX);
        }
        return false;
    }

    private boolean endWith(byte[] key, byte[] suffix) {
        int len = suffix.length;
        if (key.length < len) {
            return false;
        }
        int startPos = key.length - len;
        for (int i = 0; i < len; ++i) {
            if (key[startPos + i] == suffix[i]) continue;
            return false;
        }
        return true;
    }
}

