/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueDecoder;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.Kryo5ValueDecoder;
import com.alicp.jetcache.support.KryoValueDecoder;
import com.alicp.jetcache.support.SpringJavaValueDecoder;
import java.util.concurrent.ConcurrentHashMap;

public class DecoderMap {
    private final ConcurrentHashMap<Integer, AbstractValueDecoder> decoderMap = new ConcurrentHashMap();
    private volatile boolean inited = false;
    private static final DecoderMap instance = new DecoderMap();

    public static DecoderMap defaultInstance() {
        return instance;
    }

    public AbstractValueDecoder getDecoder(int identityNumber) {
        return this.decoderMap.get(identityNumber);
    }

    public synchronized void register(int identityNumber, AbstractValueDecoder decoder) {
        this.decoderMap.put(identityNumber, decoder);
        this.inited = true;
    }

    public synchronized void clear() {
        this.decoderMap.clear();
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultDecoder() {
        if (this.inited) {
            return;
        }
        DecoderMap decoderMap = this;
        synchronized (decoderMap) {
            if (this.inited) {
                return;
            }
            this.register(1251293824, DecoderMap.defaultJavaValueDecoder());
            this.register(1251293826, KryoValueDecoder.INSTANCE);
            this.register(-153049664, Kryo5ValueDecoder.INSTANCE);
            this.inited = true;
        }
    }

    public static JavaValueDecoder defaultJavaValueDecoder() {
        try {
            Class.forName("org.springframework.core.ConfigurableObjectInputStream");
            return SpringJavaValueDecoder.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            return JavaValueDecoder.INSTANCE;
        }
    }
}

