/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.template;

import com.alicp.jetcache.RefreshPolicy;
import com.alicp.jetcache.anno.CacheType;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public class QuickConfig {
    private String area = "default";
    private String name;
    private Duration expire;
    private Duration localExpire;
    private Integer localLimit;
    private CacheType cacheType;
    private Boolean syncLocal;
    private Function<Object, Object> keyConvertor;
    private Function<Object, byte[]> valueEncoder;
    private Function<byte[], Object> valueDecoder;
    private Boolean cacheNullValue;
    private Boolean useAreaInPrefix;
    private Boolean penetrationProtect;
    private Duration penetrationProtectTimeout;
    private RefreshPolicy refreshPolicy;

    private QuickConfig() {
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public static Builder newBuilder(String area, String name) {
        return new Builder(area, name);
    }

    public String getArea() {
        return this.area;
    }

    public String getName() {
        return this.name;
    }

    public Duration getExpire() {
        return this.expire;
    }

    public Duration getLocalExpire() {
        return this.localExpire;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public Integer getLocalLimit() {
        return this.localLimit;
    }

    public Boolean getSyncLocal() {
        return this.syncLocal;
    }

    public Function<Object, Object> getKeyConvertor() {
        return this.keyConvertor;
    }

    public Function<Object, byte[]> getValueEncoder() {
        return this.valueEncoder;
    }

    public Function<byte[], Object> getValueDecoder() {
        return this.valueDecoder;
    }

    public Boolean getCacheNullValue() {
        return this.cacheNullValue;
    }

    public Boolean getUseAreaInPrefix() {
        return this.useAreaInPrefix;
    }

    public Boolean getPenetrationProtect() {
        return this.penetrationProtect;
    }

    public Duration getPenetrationProtectTimeout() {
        return this.penetrationProtectTimeout;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public static class Builder {
        private String area = "default";
        private final String name;
        private Duration expire;
        private Duration localExpire;
        private Integer localLimit;
        private CacheType cacheType;
        private Boolean syncLocal;
        private Function<Object, Object> keyConvertor;
        private Function<Object, byte[]> valueEncoder;
        private Function<byte[], Object> valueDecoder;
        private Boolean cacheNullValue;
        private Boolean useAreaInPrefix;
        private Boolean penetrationProtect;
        private Duration penetrationProtectTimeout;
        private RefreshPolicy refreshPolicy;

        Builder(String name) {
            Objects.requireNonNull(name);
            this.name = name;
        }

        Builder(String area, String name) {
            Objects.requireNonNull(area);
            Objects.requireNonNull(name);
            this.area = area;
            this.name = name;
        }

        public QuickConfig build() {
            QuickConfig c = new QuickConfig();
            c.area = this.area;
            c.name = this.name;
            c.expire = this.expire;
            c.localExpire = this.localExpire;
            c.localLimit = this.localLimit;
            c.cacheType = this.cacheType;
            c.syncLocal = this.syncLocal;
            c.keyConvertor = this.keyConvertor;
            c.valueEncoder = this.valueEncoder;
            c.valueDecoder = this.valueDecoder;
            c.cacheNullValue = this.cacheNullValue;
            c.useAreaInPrefix = this.useAreaInPrefix;
            c.penetrationProtect = this.penetrationProtect;
            c.penetrationProtectTimeout = this.penetrationProtectTimeout;
            c.refreshPolicy = this.refreshPolicy;
            return c;
        }

        public Builder expire(Duration expire) {
            this.expire = expire;
            return this;
        }

        public Builder localExpire(Duration localExpire) {
            this.localExpire = localExpire;
            return this;
        }

        public Builder localLimit(Integer localLimit) {
            this.localLimit = localLimit;
            return this;
        }

        public Builder cacheType(CacheType cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder syncLocal(Boolean syncLocal) {
            this.syncLocal = syncLocal;
            return this;
        }

        public Builder keyConvertor(Function<Object, Object> keyConvertor) {
            this.keyConvertor = keyConvertor;
            return this;
        }

        public Builder valueEncoder(Function<Object, byte[]> valueEncoder) {
            this.valueEncoder = valueEncoder;
            return this;
        }

        public Builder valueDecoder(Function<byte[], Object> valueDecoder) {
            this.valueDecoder = valueDecoder;
            return this;
        }

        public Builder cacheNullValue(Boolean cacheNullValue) {
            this.cacheNullValue = cacheNullValue;
            return this;
        }

        public Builder useAreaInPrefix(Boolean useAreaInPrefix) {
            this.useAreaInPrefix = useAreaInPrefix;
            return this;
        }

        public Builder penetrationProtect(Boolean penetrationProtect) {
            this.penetrationProtect = penetrationProtect;
            return this;
        }

        public Builder penetrationProtectTimeout(Duration penetrationProtectTimeout) {
            this.penetrationProtectTimeout = penetrationProtectTimeout;
            return this;
        }

        public Builder refreshPolicy(RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }
    }
}

