/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.CacheStat;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.JetCacheExecutor;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.support.StatInfoLogger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetricsManager.class);
    protected CopyOnWriteArrayList<DefaultCacheMonitor> monitorList = new CopyOnWriteArrayList();
    private ScheduledFuture<?> future;
    private int resetTime;
    private TimeUnit resetTimeUnit;
    private Consumer<StatInfo> metricsCallback;
    Runnable cmd = new Runnable(){
        private long time = System.currentTimeMillis();

        @Override
        public void run() {
            try {
                List<CacheStat> stats = DefaultMetricsManager.this.monitorList.stream().map(m -> {
                    CacheStat stat = m.getCacheStat();
                    m.resetStat();
                    return stat;
                }).collect(Collectors.toList());
                long endTime = System.currentTimeMillis();
                StatInfo statInfo = new StatInfo();
                statInfo.setStartTime(this.time);
                statInfo.setEndTime(endTime);
                statInfo.setStats(stats);
                this.time = endTime;
                DefaultMetricsManager.this.metricsCallback.accept(statInfo);
            }
            catch (Exception e) {
                logger.error("jetcache DefaultMetricsManager error", (Throwable)e);
            }
        }
    };

    public DefaultMetricsManager(int resetTime, TimeUnit resetTimeUnit, Consumer<StatInfo> metricsCallback) {
        this.resetTime = resetTime;
        this.resetTimeUnit = resetTimeUnit;
        this.metricsCallback = metricsCallback;
    }

    public DefaultMetricsManager(int resetTime, TimeUnit resetTimeUnit) {
        this(resetTime, resetTimeUnit, false);
    }

    public DefaultMetricsManager(int resetTime, TimeUnit resetTimeUnit, boolean verboseLog) {
        this.resetTime = resetTime;
        this.resetTimeUnit = resetTimeUnit;
        this.metricsCallback = new StatInfoLogger(verboseLog);
    }

    @PostConstruct
    public synchronized void start() {
        if (this.future != null) {
            return;
        }
        long delay = DefaultMetricsManager.firstDelay(this.resetTime, this.resetTimeUnit);
        this.future = JetCacheExecutor.defaultExecutor().scheduleAtFixedRate(this.cmd, delay, this.resetTimeUnit.toMillis(this.resetTime), TimeUnit.MILLISECONDS);
        logger.info("cache stat period at " + this.resetTime + " " + (Object)((Object)this.resetTimeUnit));
    }

    @PreDestroy
    public synchronized void stop() {
        this.future.cancel(false);
        logger.info("cache stat canceled");
        this.future = null;
    }

    public void add(DefaultCacheMonitor ... monitors) {
        this.monitorList.addAll(Arrays.asList(monitors));
    }

    public void clear() {
        this.monitorList.clear();
    }

    protected static long firstDelay(int resetTime, TimeUnit resetTimeUnit) {
        LocalDateTime firstResetTime = DefaultMetricsManager.computeFirstResetTime(LocalDateTime.now(), resetTime, resetTimeUnit);
        return firstResetTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - System.currentTimeMillis();
    }

    protected static LocalDateTime computeFirstResetTime(LocalDateTime baseTime, int time, TimeUnit unit) {
        if (unit != TimeUnit.SECONDS && unit != TimeUnit.MINUTES && unit != TimeUnit.HOURS && unit != TimeUnit.DAYS) {
            throw new IllegalArgumentException();
        }
        LocalDateTime t = baseTime;
        switch (unit) {
            case DAYS: {
                t = t.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                break;
            }
            case HOURS: {
                t = 24 % time == 0 ? t.plusHours(time - t.getHour() % time) : t.plusHours(1L);
                t = t.withMinute(0).withSecond(0).withNano(0);
                break;
            }
            case MINUTES: {
                t = 60 % time == 0 ? t.plusMinutes(time - t.getMinute() % time) : t.plusMinutes(1L);
                t = t.withSecond(0).withNano(0);
                break;
            }
            case SECONDS: {
                t = 60 % time == 0 ? t.plusSeconds(time - t.getSecond() % time) : t.plusSeconds(1L);
                t = t.withNano(0);
            }
        }
        return t;
    }
}

